-- VHDL Entity R6502_TC.ADD_SUB.symbol
--
-- Created:
--          by - eda.UNKNOWN (ENTWICKL4-XP-PR)
--          at - 19:48:45 17.04.2008
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2007.1a (Build 13)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

entity ADD_SUB is
   port( 
      ch_a_i           : in     std_logic_vector ( 7 downto 0 ) := X"00";
      ch_b_i           : in     std_logic_vector ( 7 downto 0 ) := X"00";
      reg_0flag_i      : in     std_logic                       := '0';
      reg_7flag_core_i : in     std_logic                       := '0';
      sel              : in     std_logic_vector ( 1 downto 0 ) := "00";
      q_a_o            : out    std_logic_vector ( 7 downto 0 ) := X"00";
      reg_0flag_o      : out    std_logic                       := '0';
      reg_6flag_o      : out    std_logic                       := '0';
      zw_alu           : inout  std_logic_vector ( 8 downto 0 ) := '0' & X"00";
      zw_alu1          : inout  std_logic_vector ( 8 downto 0 ) := '0' & X"00";
      zw_alu2          : inout  std_logic_vector ( 8 downto 0 ) := '0' & X"00";
      zw_alu3          : inout  std_logic_vector ( 8 downto 0 ) := '0' & X"00";
      zw_alu4          : inout  std_logic_vector ( 8 downto 0 ) := '0' & X"00";
      zw_alu5          : inout  std_logic_vector ( 8 downto 0 ) := '0' & X"00";
      zw_alu6          : inout  std_logic_vector ( 8 downto 0 ) := '0' & X"00"
   );

-- Declarations

end ADD_SUB ;

-- Jens-D. Gutschmidt     Project:  R6502_TC  
-- scantara2003@yahoo.de                      
-- COPYRIGHT (C) 2008 by Jens Gutschmidt and OPENCORES.ORG                                                                                     
--                                                                                                                                             
-- This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by   
-- the Free Software Foundation, either version 3 of the License, or any later version.                                                        
--                                                                                                                                             
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of              
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.                                  
--                                                                                                                                             
-- You should have received a copy of the GNU General Public License along with this program.  If not, see <http://www.gnu.org/licenses/>.     
--                                                                                                                                             
-- CVS Revisins History                                                                                                                        
--                                                                                                                                             
-- $Log: add_sub.vhd,v $
-- Revision 1.2  2008/04/17 18:39:34  fpga_is_funny
-- Bugfixes for all relationchips with interrupts BRK, IRQ and NMI.
-- The control for the stack pointer within fsm*s of BRK, IRQ and NMI was incorrect. The stack was allways growing up instead of growing down.
-- The "B" status flag was never set within BRK.
-- The relationchip between addresses and data while writing onto the stack was badly misalligned.
--                                                                                                                           
--   <<-- more -->>                                                                                                                            
-- Title:  Adder and Substractor  
-- Path:  R6502_TC/ADD_SUB/flow  
-- Edited:  by eda on 08 Apr 2008  
--
-- VHDL Architecture R6502_TC.ADD_SUB.flow
--
-- Created:
--          by - eda.UNKNOWN (ENTWICKL4-XP-PR)
--          at - 19:48:45 17.04.2008
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2007.1a (Build 13)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
architecture flow of ADD_SUB is

begin

   -----------------------------------------------------------------
   process0_proc : process (ch_a_i, ch_b_i, reg_0flag_i, reg_7flag_core_i, sel, zw_alu, zw_alu1, zw_alu2, zw_alu3, zw_alu4, zw_alu5, zw_alu6)
   -----------------------------------------------------------------
   begin
      case sel(1 downto 0) is
      when "01" =>
         reg_6flag_o <= reg_7flag_core_i XOR zw_ALU(7);
         reg_0flag_o <= zw_ALU4(4);
         q_a_o <= zw_ALU(7 downto 0);
         zw_ALU(7 downto 4) <= unsigned (zw_ALU2(3 downto 0)) +
          unsigned (zw_ALU6(7 downto 5));
         zw_ALU(3 downto 0) <= unsigned (zw_ALU1(3 downto 0)) +
          unsigned (zw_ALU5(7 downto 5));
         
         zw_ALU6(7 downto 5) <=  (zw_ALU2(4) OR zw_ALU4(4)) &
          (zw_ALU2(4) OR zw_ALU4(4)) & '0';
         zw_ALU5(7 downto 5) <=  (zw_ALU1(4) OR zw_ALU3(4)) &
          (zw_ALU1(4) OR zw_ALU3(4)) & '0';
         
         zw_ALU4(4 downto 0) <= unsigned ('0' & zw_ALU2(3 downto 0)) + 6;
         zw_ALU2(4 downto 0) <= unsigned ('0' & ch_a_i(7 downto 4)) + unsigned 
         ('0' & ch_b_i(7 downto 4)) + (zw_ALU1(4) OR zw_ALU3(4));
         
         zw_ALU3(4 downto 0) <= unsigned ('0' & zw_ALU1(3 downto 0)) + 6;
         zw_ALU1(4 downto 0) <= unsigned ('0' & ch_a_i(3 downto 0)) + unsigned 
         ('0' & ch_b_i(3 downto 0)) + reg_0flag_i;
      when "00" =>
         reg_6flag_o <= reg_7flag_core_i XOR zw_ALU(7);
         reg_0flag_o <= zw_ALU(8);
         q_a_o <= zw_ALU(7 downto 0);
         zw_ALU <= unsigned ('0' & ch_a_i) + unsigned ('0' & ch_b_i) + reg_0flag_i;
      when "10" =>
         reg_6flag_o <= reg_7flag_core_i XOR zw_ALU(7);
         reg_0flag_o <= zw_ALU(8);
         q_a_o <= zw_ALU(7 downto 0);
         zw_ALU <= unsigned ('0' & ch_a_i) + unsigned ('0' & NOT (ch_b_i)) + reg_0flag_i;
      when "11" =>
         reg_6flag_o <= reg_7flag_core_i XOR zw_ALU(7);
         reg_0flag_o <= zw_ALU2(4);
         q_a_o <= zw_ALU(7 downto 0);
         zw_ALU(7 downto 4) <= unsigned (zw_ALU2(3 downto 0)) + 
         unsigned ((zw_ALU6(8 downto 5)));
         zw_ALU(3 downto 0) <= unsigned (zw_ALU1(3 downto 0)) + 
         unsigned ((zw_ALU5(8 downto 5)));
         
         zw_ALU6(8 downto 5) <= (zw_ALU4(4) OR NOT (zw_ALU2(4))) & '0' & 
         (zw_ALU4(4) OR NOT (zw_ALU2(4))) & '0';
         zw_ALU5(8 downto 5) <= (zw_ALU3(4) OR NOT (zw_ALU1(4))) & '0' & 
         (zw_ALU3(4) OR NOT (zw_ALU1(4))) & '0' ;
         
         zw_ALU4(4 downto 0) <= unsigned ('0' & zw_ALU2(3 downto 0)) + 6;
         zw_ALU2(4 downto 0) <= unsigned ('0' & ch_a_i(7 downto 4)) + unsigned 
         ('0' & NOT (ch_b_i(7 downto 4))) + zw_ALU1(4);
         
         zw_ALU3(4 downto 0) <= unsigned ('0' & zw_ALU1(3 downto 0)) + 6;
         zw_ALU1(4 downto 0) <= unsigned ('0' & ch_a_i(3 downto 0)) + unsigned 
         ('0' & NOT (ch_b_i(3 downto 0))) + reg_0flag_i;
      when others =>
         reg_6flag_o <= reg_7flag_core_i XOR zw_ALU(7);
         reg_0flag_o <= zw_ALU(8);
         q_a_o <= zw_ALU(7 downto 0);
         zw_ALU <= unsigned ('0' & ch_a_i) + unsigned ('0' & ch_b_i) + reg_0flag_i;
      end case;
   end process process0_proc;


end flow;
