-- VHDL Entity R6502_TC.ALU.symbol
--
-- Created:
--          by - eda.UNKNOWN (ENTWICKL4-XP-PR)
--          at - 19:48:45 17.04.2008
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2007.1a (Build 13)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

entity ALU is
   port( 
      ch_a_i           : in     std_logic_vector (7 downto 0);
      ch_b_i           : in     std_logic_vector (7 downto 0);
      reg_0flag_core_i : in     std_logic;
      reg_3flag_core_i : in     std_logic;
      reg_7flag_core_i : in     std_logic;
      sel_alu_as_i     : in     std_logic;
      sel_alu_out_i    : in     std_logic_vector (2 downto 0);
      d_alu_o          : out    std_logic_vector (7 downto 0);
      reg_0flag_o      : out    std_logic;
      reg_1flag_o      : out    std_logic;
      reg_6flag_o      : out    std_logic;
      reg_7flag_o      : out    std_logic
   );

-- Declarations

end ALU ;

-- Jens-D. Gutschmidt     Project:  R6502_TC  
-- scantara2003@yahoo.de                      
-- COPYRIGHT (C) 2008 by Jens Gutschmidt and OPENCORES.ORG                                                                                     
--                                                                                                                                             
-- This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by   
-- the Free Software Foundation, either version 3 of the License, or any later version.                                                        
--                                                                                                                                             
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of              
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.                                  
--                                                                                                                                             
-- You should have received a copy of the GNU General Public License along with this program.  If not, see <http://www.gnu.org/licenses/>.     
--                                                                                                                                             
-- CVS Revisins History                                                                                                                        
--                                                                                                                                             
-- $Log: alu.vhd,v $
-- Revision 1.2  2008/04/17 18:39:34  fpga_is_funny
-- Bugfixes for all relationchips with interrupts BRK, IRQ and NMI.
-- The control for the stack pointer within fsm*s of BRK, IRQ and NMI was incorrect. The stack was allways growing up instead of growing down.
-- The "B" status flag was never set within BRK.
-- The relationchip between addresses and data while writing onto the stack was badly misalligned.
--                                                                                                                                       
-- Title:  ALU  
-- Path:  R6502_TC/ALU/struct  
-- Edited:  by eda on 17 Apr 2008  
--
-- VHDL Architecture R6502_TC.ALU.struct
--
-- Created:
--          by - eda.UNKNOWN (ENTWICKL4-XP-PR)
--          at - 19:48:46 17.04.2008
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2007.1a (Build 13)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

library R6502_TC;

architecture struct of ALU is

   -- Architecture declarations

   -- Internal signal declarations
   signal din      : std_logic;
   signal din0     : std_logic;
   signal din1     : std_logic;
   signal din2     : std_logic;
   signal din3     : std_logic;
   signal dout     : std_logic;
   signal q_a      : std_logic_vector(7 downto 0);
   signal q_and    : std_logic_vector(7 downto 0);
   signal q_aneg   : std_logic_vector(7 downto 0);
   signal q_bneg   : std_logic_vector(7 downto 0);
   signal q_or     : std_logic_vector(7 downto 0);
   signal q_xor    : std_logic_vector(7 downto 0);
   signal sel      : std_logic_vector(1 downto 0);
   signal val_one  : std_logic_vector(7 downto 0);
   signal val_two  : std_logic_vector(7 downto 0);
   signal val_zero : std_logic_vector(7 downto 0);

   -- Implicit buffer signal declarations
   signal d_alu_o_internal : std_logic_vector (7 downto 0);


   -- Component Declarations
   component ADD_SUB
   port (
      ch_a_i           : in     std_logic_vector ( 7 downto 0 ) := X"00";
      ch_b_i           : in     std_logic_vector ( 7 downto 0 ) := X"00";
      reg_0flag_i      : in     std_logic                       := '0';
      reg_7flag_core_i : in     std_logic                       := '0';
      sel              : in     std_logic_vector ( 1 downto 0 ) := "00";
      q_a_o            : out    std_logic_vector ( 7 downto 0 ) := X"00";
      reg_0flag_o      : out    std_logic                       := '0';
      reg_6flag_o      : out    std_logic                       := '0';
      zw_alu           : inout  std_logic_vector ( 8 downto 0 ) := '0' & X"00";
      zw_alu1          : inout  std_logic_vector ( 8 downto 0 ) := '0' & X"00";
      zw_alu2          : inout  std_logic_vector ( 8 downto 0 ) := '0' & X"00";
      zw_alu3          : inout  std_logic_vector ( 8 downto 0 ) := '0' & X"00";
      zw_alu4          : inout  std_logic_vector ( 8 downto 0 ) := '0' & X"00";
      zw_alu5          : inout  std_logic_vector ( 8 downto 0 ) := '0' & X"00";
      zw_alu6          : inout  std_logic_vector ( 8 downto 0 ) := '0' & X"00"
   );
   end component;

   -- Optional embedded configurations
   -- pragma synthesis_off
   for all : ADD_SUB use entity R6502_TC.ADD_SUB;
   -- pragma synthesis_on


begin
   -- Architecture concurrent statements
   -- HDL Embedded Text Block 3 eb3
   -- eb1 1
   val_zero (7 downto 0) <= X"00";
   val_one (7 downto 0) <= X"01";
   val_two (7 downto 0) <= X"02";
   sel(0) <= reg_3flag_core_i AND sel_alu_out_i(0);
   sel(1) <= sel_alu_as_i;


   -- ModuleWare code(v1.9) for instance 'U_3' of 'inv'
   q_aneg <= not(ch_a_i);

   -- ModuleWare code(v1.9) for instance 'U_4' of 'inv'
   q_bneg <= not(ch_b_i);

   -- ModuleWare code(v1.9) for instance 'U_8' of 'inv'
   reg_1flag_o <= not(din);

   -- ModuleWare code(v1.9) for instance 'U_9' of 'inv'
   reg_7flag_o <= not(din1);

   -- ModuleWare code(v1.9) for instance 'U_10' of 'inv'
   din1 <= not(d_alu_o_internal(7));

   -- ModuleWare code(v1.9) for instance 'U_14' of 'inv'
   din3 <= not(sel_alu_out_i(0));

   -- ModuleWare code(v1.9) for instance 'U_5' of 'mux'
   u_5combo_proc: process(q_and, q_or, q_xor, q_aneg, q_bneg, q_a, 
                          val_zero, sel_alu_out_i)
   begin
      case sel_alu_out_i is
      when "000" => d_alu_o_internal <= q_and;
      when "001" => d_alu_o_internal <= q_or;
      when "010" => d_alu_o_internal <= q_xor;
      when "011" => d_alu_o_internal <= q_aneg;
      when "100" => d_alu_o_internal <= q_bneg;
      when "101" => d_alu_o_internal <= q_a;
      when "110" => d_alu_o_internal <= q_a;
      when "111" => d_alu_o_internal <= val_zero;
      when others => d_alu_o_internal <= (others => 'X');
      end case;
   end process u_5combo_proc;

   -- ModuleWare code(v1.9) for instance 'U_7' of 'por'
   din <= d_alu_o_internal(0) or  d_alu_o_internal(1) or  d_alu_o_internal(2) or  d_alu_o_internal(3) or  d_alu_o_internal(4) or  d_alu_o_internal(5) or  d_alu_o_internal(6) or  d_alu_o_internal(7);

   -- ModuleWare code(v1.9) for instance 'U_0' of 'sand'
   q_and <= ch_a_i and ch_b_i;

   -- ModuleWare code(v1.9) for instance 'U_11' of 'sand'
   din0 <= sel_alu_out_i(0) and reg_0flag_core_i;

   -- ModuleWare code(v1.9) for instance 'U_13' of 'sand'
   din2 <= din3 and sel_alu_as_i;

   -- ModuleWare code(v1.9) for instance 'U_1' of 'sor'
   q_or <= ch_a_i or ch_b_i;

   -- ModuleWare code(v1.9) for instance 'U_12' of 'sor'
   dout <= din0 or din2;

   -- ModuleWare code(v1.9) for instance 'U_2' of 'sxor'
   q_xor <= ch_a_i xor ch_b_i;

   -- Instance port mappings.
   U_6 : ADD_SUB
      port map (
         ch_a_i           => ch_a_i,
         ch_b_i           => ch_b_i,
         reg_0flag_i      => dout,
         reg_7flag_core_i => reg_7flag_core_i,
         sel              => sel,
         q_a_o            => q_a,
         reg_0flag_o      => reg_0flag_o,
         reg_6flag_o      => reg_6flag_o,
         zw_alu           => open,
         zw_alu1          => open,
         zw_alu2          => open,
         zw_alu3          => open,
         zw_alu4          => open,
         zw_alu5          => open,
         zw_alu6          => open
      );

   -- Implicit buffered output assignments
   d_alu_o <= d_alu_o_internal;

end struct;
