-- VHDL Entity R6502_TC.fsm_core_V2_0.symbol
--
-- Created:
--          by - eda.UNKNOWN (ENTWICKL4-XP-PR)
--          at - 19:48:46 17.04.2008
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2007.1a (Build 13)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

entity fsm_core_V2_0 is
   port( 
      adr_nxt_pc_i    : in     std_logic_vector (15 downto 0);
      adr_nxt_sp_i    : in     std_logic_vector (15 downto 0);
      adr_pc_i        : in     std_logic_vector (15 downto 0);
      adr_sp_i        : in     std_logic_vector (15 downto 0);
      clk_clk_i       : in     std_logic;
      cout_pc_i       : in     std_logic;
      d_alu_i         : in     std_logic_vector ( 7 downto 0 );
      d_i             : in     std_logic_vector ( 7 downto 0 );
      d_regs_out_i    : in     std_logic_vector ( 7 downto 0 );
      irq_n_i         : in     std_logic;
      nmi_i           : in     std_logic;
      q_a_i           : in     std_logic_vector ( 7 downto 0 );
      q_x_i           : in     std_logic_vector ( 7 downto 0 );
      q_y_i           : in     std_logic_vector ( 7 downto 0 );
      rdy_i           : in     std_logic;
      reg_0flag_i     : in     std_logic;
      reg_1flag_i     : in     std_logic;
      reg_6flag_i     : in     std_logic;
      reg_7flag_i     : in     std_logic;
      rst_rst_n_i     : in     std_logic;
      so_n_i          : in     std_logic;
      a_o             : out    std_logic_vector (15 downto 0);
      adr_o           : out    std_logic_vector (15 downto 0);
      ch_a_o          : out    std_logic_vector ( 7 downto 0 );
      ch_b_o          : out    std_logic_vector ( 7 downto 0 );
      d_o             : out    std_logic_vector ( 7 downto 0 );
      d_regs_in_o     : out    std_logic_vector ( 7 downto 0 );
      fetch_o         : out    std_logic;
      ld_o            : out    std_logic_vector ( 1 downto 0 );
      ld_pc_o         : out    std_logic;
      ld_sp_o         : out    std_logic;
      load_regs_o     : out    std_logic;
      offset_o        : out    std_logic_vector ( 15 downto 0 );
      rd_o            : out    std_logic;
      reg_0flag_o     : out    std_logic;
      reg_1flag_o     : out    std_logic;
      reg_3flag_o     : out    std_logic;
      reg_7flag_o     : out    std_logic;
      sync_o          : out    std_logic;
      wr_n_o          : out    std_logic;
      wr_o            : out    std_logic;
      sel_alu_as_o_i  : inout  std_logic;
      sel_alu_out_o_i : inout  std_logic_vector ( 2 downto 0 );
      sel_pc_as_o_i   : inout  std_logic;
      sel_pc_in_o_i   : inout  std_logic_vector ( 1 downto 0 );
      sel_pc_val_o_i  : inout  std_logic_vector ( 1 downto 0 );
      sel_rb_in_o_i   : inout  std_logic_vector ( 2 downto 0 );
      sel_rb_out_o_i  : inout  std_logic_vector ( 2 downto 0 );
      sel_reg_o_i     : inout  std_logic_vector ( 1 downto 0 );
      sel_sp_as_o_i   : inout  std_logic;
      sel_sp_in_o_i   : inout  std_logic_vector ( 1 downto 0 );
      sel_sp_val_o_i  : inout  std_logic_vector ( 1 downto 0 )
   );

-- Declarations

end fsm_core_V2_0 ;

-- Jens-D. Gutschmidt     Project:  R6502_TC  

-- scantara2003@yahoo.de                      

-- COPYRIGHT (C) 2008 by Jens Gutschmidt and OPENCORES.ORG                                                                                     

--                                                                                                                                             

-- This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by   

-- the Free Software Foundation, either version 3 of the License, or any later version.                                                        

--                                                                                                                                             

-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of              

-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.                                  

--                                                                                                                                             

-- You should have received a copy of the GNU General Public License along with this program.  If not, see <http://www.gnu.org/licenses/>.     

--                                                                                                                                             

-- CVS Revisins History                                                                                                                        

--                                                                                                                                             

-- $Log: fsm_core_v2_0.vhd,v $
-- Revision 1.2  2008/04/17 18:39:34  fpga_is_funny
-- Bugfixes for all relationchips with interrupts BRK, IRQ and NMI.
-- The control for the stack pointer within fsm*s of BRK, IRQ and NMI was incorrect. The stack was allways growing up instead of growing down.
-- The "B" status flag was never set within BRK.
-- The relationchip between addresses and data while writing onto the stack was badly misalligned.
--                                                                                                                                       

-- Title:  FSM for all op codes  

-- Path:  R6502_TC/fsm_core_V2_0/fsm  

-- Edited:  by eda on 17 Apr 2008  

--
-- VHDL Architecture R6502_TC.fsm_core_V2_0.fsm
--
-- Created:
--          by - eda.UNKNOWN (ENTWICKL4-XP-PR)
--          at - 19:48:48 17.04.2008
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2007.1a (Build 13)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
 
architecture fsm of fsm_core_V2_0 is

   -- Architecture Declarations
   signal reg_F : std_logic_vector( 7 DOWNTO 0 );  
   signal reg_PC : std_logic_vector(15 DOWNTO 0);  
   signal reg_PC1 : std_logic_vector( 15 DOWNTO 0 );  
   signal sig_D_OUT : std_logic_vector( 7 DOWNTO 0 );  
   signal sig_PC : std_logic_vector(15 DOWNTO 0);  
   signal sig_RD : std_logic;  
   signal sig_RWn : std_logic;  
   signal sig_SYNC : std_logic;  
   signal sig_WR : std_logic;  
   signal zw_ALU : std_logic_vector( 8 DOWNTO 0 );  
   signal zw_ALU1 : std_logic_vector( 8 DOWNTO 0 );  
   signal zw_ALU2 : std_logic_vector( 8 DOWNTO 0 );  
   signal zw_ALU3 : std_logic_vector( 8 DOWNTO 0 );  
   signal zw_ALU4 : std_logic_vector( 8 DOWNTO 0 );  
   signal zw_ALU5 : std_logic_vector( 8 DOWNTO 0 );  
   signal zw_ALU6 : std_logic_vector( 8 DOWNTO 0 );  
   signal zw_PC : std_logic_vector( 15 DOWNTO 0 );  
   signal zw_REG_ALU : std_logic_vector( 8 DOWNTO 0 );  
   signal zw_REG_NMI : std_logic;  
   signal zw_REG_OP : std_logic_vector( 7 DOWNTO 0 );  
   signal zw_REG_sig_PC : std_logic_vector(15 DOWNTO 0);  
   signal zw_b1 : std_logic_vector( 7 DOWNTO 0 );  
   signal zw_b2 : std_logic_vector( 7 DOWNTO 0 );  
   signal zw_b3 : std_logic_vector( 7 DOWNTO 0 );  
   signal zw_b4 : std_logic_vector( 7 DOWNTO 0 );  
   signal zw_w1 : std_logic_vector( 15 DOWNTO 0 );  
   signal zw_w2 : std_logic_vector( 15 DOWNTO 0 );  
   signal zw_w3 : std_logic_vector( 15 DOWNTO 0 );  

   subtype state_type is 
      std_logic_vector(7 downto 0);
 
   -- State vector declaration
   attribute state_vector : string;
   attribute state_vector of fsm : architecture is "current_state";

   -- Hard encoding
   constant FETCH : state_type := "00000000";
   constant s1 : state_type := "00000001";
   constant s2 : state_type := "00000011";
   constant s5 : state_type := "00000010";
   constant s3 : state_type := "00000110";
   constant s4 : state_type := "00000111";
   constant s12 : state_type := "00000101";
   constant s16 : state_type := "00000100";
   constant s17 : state_type := "00001100";
   constant s24 : state_type := "00001101";
   constant s25 : state_type := "00001111";
   constant s271 : state_type := "00001110";
   constant s273 : state_type := "00001010";
   constant s304 : state_type := "00001011";
   constant s307 : state_type := "00001001";
   constant s177 : state_type := "00001000";
   constant s180 : state_type := "00011000";
   constant s181 : state_type := "00011001";
   constant s182 : state_type := "00011011";
   constant s183 : state_type := "00011010";
   constant s184 : state_type := "00011110";
   constant s185 : state_type := "00011111";
   constant s186 : state_type := "00011101";
   constant s187 : state_type := "00011100";
   constant s188 : state_type := "00010100";
   constant s189 : state_type := "00010101";
   constant s190 : state_type := "00010111";
   constant s191 : state_type := "00010110";
   constant s192 : state_type := "00010010";
   constant s193 : state_type := "00010011";
   constant s377 : state_type := "00010001";
   constant s381 : state_type := "00010000";
   constant s378 : state_type := "00110000";
   constant s382 : state_type := "00110001";
   constant s379 : state_type := "00110011";
   constant s383 : state_type := "00110010";
   constant s384 : state_type := "00110110";
   constant s380 : state_type := "00110111";
   constant s385 : state_type := "00110101";
   constant s386 : state_type := "00110100";
   constant s387 : state_type := "00111100";
   constant s388 : state_type := "00111101";
   constant s389 : state_type := "00111111";
   constant s391 : state_type := "00111110";
   constant s392 : state_type := "00111010";
   constant s390 : state_type := "00111011";
   constant s393 : state_type := "00111001";
   constant s394 : state_type := "00111000";
   constant s395 : state_type := "00101000";
   constant s396 : state_type := "00101001";
   constant s397 : state_type := "00101011";
   constant s398 : state_type := "00101010";
   constant s399 : state_type := "00101110";
   constant s400 : state_type := "00101111";
   constant s401 : state_type := "00101101";
   constant s526 : state_type := "00101100";
   constant s527 : state_type := "00100100";
   constant s528 : state_type := "00100101";
   constant s529 : state_type := "00100111";
   constant s530 : state_type := "00100110";
   constant s531 : state_type := "00100010";
   constant s544 : state_type := "00100011";
   constant s545 : state_type := "00100001";
   constant s546 : state_type := "00100000";
   constant s547 : state_type := "01100000";
   constant s549 : state_type := "01100001";
   constant s550 : state_type := "01100011";
   constant s404 : state_type := "01100010";
   constant s556 : state_type := "01100110";
   constant s557 : state_type := "01100111";
   constant s579 : state_type := "01100101";
   constant s201 : state_type := "01100100";
   constant s202 : state_type := "01101100";
   constant s210 : state_type := "01101101";
   constant s211 : state_type := "01101111";
   constant s215 : state_type := "01101110";
   constant s217 : state_type := "01101010";
   constant s218 : state_type := "01101011";
   constant s222 : state_type := "01101001";
   constant s223 : state_type := "01101000";
   constant s224 : state_type := "01111000";
   constant s225 : state_type := "01111001";
   constant s226 : state_type := "01111011";
   constant s243 : state_type := "01111010";
   constant s244 : state_type := "01111110";
   constant s247 : state_type := "01111111";
   constant s344 : state_type := "01111101";
   constant s343 : state_type := "01111100";
   constant s250 : state_type := "01110100";
   constant s251 : state_type := "01110101";
   constant s351 : state_type := "01110111";
   constant s361 : state_type := "01110110";
   constant s360 : state_type := "01110010";
   constant s403 : state_type := "01110011";
   constant s406 : state_type := "01110001";
   constant s407 : state_type := "01110000";
   constant s409 : state_type := "01010000";
   constant s412 : state_type := "01010001";
   constant s413 : state_type := "01010011";
   constant s416 : state_type := "01010010";
   constant s418 : state_type := "01010110";
   constant s510 : state_type := "01010111";
   constant s553 : state_type := "01010101";
   constant s555 : state_type := "01010100";
   constant s558 : state_type := "01011100";
   constant s560 : state_type := "01011101";
   constant s561 : state_type := "01011111";
   constant s563 : state_type := "01011110";
   constant s564 : state_type := "01011010";
   constant s565 : state_type := "01011011";
   constant s566 : state_type := "01011001";
   constant s266 : state_type := "01011000";
   constant s301 : state_type := "01001000";
   constant s302 : state_type := "01001001";
   constant RES : state_type := "01001011";
   constant s511 : state_type := "01001010";
   constant s559 : state_type := "01001110";
   constant s562 : state_type := "01001111";
   constant s567 : state_type := "01001101";
   constant s568 : state_type := "01001100";
   constant s569 : state_type := "01000100";
   constant s570 : state_type := "01000101";
   constant s571 : state_type := "01000111";
   constant s572 : state_type := "01000110";
   constant s573 : state_type := "01000010";
   constant s574 : state_type := "01000011";
   constant s548 : state_type := "01000001";
   constant s551 : state_type := "01000000";
   constant s552 : state_type := "11000000";
   constant s575 : state_type := "11000001";
   constant s576 : state_type := "11000011";
   constant s577 : state_type := "11000010";
   constant s532 : state_type := "11000110";
   constant s533 : state_type := "11000111";
   constant s534 : state_type := "11000101";
   constant s535 : state_type := "11000100";
   constant s536 : state_type := "11001100";
   constant s537 : state_type := "11001101";

   -- Declare current and next state signals
   signal current_state : state_type;
   signal next_state : state_type;

   -- Declare any pre-registered internal signals
   signal d_o_cld : std_logic_vector ( 7 downto 0 );
   signal rd_o_cld : std_logic ;
   signal sync_o_cld : std_logic ;
   signal wr_n_o_cld : std_logic ;
   signal wr_o_cld : std_logic ;
   signal sel_alu_as_o_i_cld : std_logic ;
   signal sel_alu_out_o_i_cld : std_logic_vector ( 2 downto 0 );
   signal sel_pc_as_o_i_cld : std_logic ;
   signal sel_pc_in_o_i_cld : std_logic_vector ( 1 downto 0 );
   signal sel_pc_val_o_i_cld : std_logic_vector ( 1 downto 0 );
   signal sel_rb_in_o_i_cld : std_logic_vector ( 2 downto 0 );
   signal sel_rb_out_o_i_cld : std_logic_vector ( 2 downto 0 );
   signal sel_reg_o_i_cld : std_logic_vector ( 1 downto 0 );
   signal sel_sp_as_o_i_cld : std_logic ;
   signal sel_sp_in_o_i_cld : std_logic_vector ( 1 downto 0 );
   signal sel_sp_val_o_i_cld : std_logic_vector ( 1 downto 0 );

begin

   -----------------------------------------------------------------
   clocked_proc : process ( 
      clk_clk_i,
      rst_rst_n_i
   )
   -----------------------------------------------------------------
   begin
      if (rst_rst_n_i = '0') then
         current_state <= RES;
         -- Default Reset Values
         d_o_cld <= X"00";
         rd_o_cld <= '0';
         sync_o_cld <= '0';
         wr_n_o_cld <= '1';
         wr_o_cld <= '0';
         sel_alu_as_o_i_cld <= '0';
         sel_alu_out_o_i_cld <= "000";
         sel_pc_as_o_i_cld <= '0';
         sel_pc_in_o_i_cld <= "00";
         sel_pc_val_o_i_cld <= "00";
         sel_rb_in_o_i_cld <= "000";
         sel_rb_out_o_i_cld <= "000";
         sel_reg_o_i_cld <= "00";
         sel_sp_as_o_i_cld <= '0';
         sel_sp_in_o_i_cld <= "00";
         sel_sp_val_o_i_cld <= "00";
         reg_F <= "00000100";
         reg_PC <= X"0000";
         reg_PC1 <= X"0000";
         sig_PC <= X"0000";
         zw_PC <= X"0000";
         zw_REG_ALU <= '0' & X"00";
         zw_REG_NMI <= '0';
         zw_REG_OP <= X"00";
         zw_REG_sig_PC <= X"0000";
         zw_b1 <= X"00";
         zw_b2 <= X"00";
         zw_b3 <= X"00";
         zw_b4 <= X"00";
         zw_w1 <= X"0000";
         zw_w2 <= X"0000";
         zw_w3 <= X"0000";
      elsif (clk_clk_i'event and clk_clk_i = '1') then
         current_state <= next_state;
         -- Default Assignment To Internals
         reg_F <= reg_F or ('0' & (not so_n_i) & "000000");
         reg_PC <= reg_PC;
         reg_PC1 <= reg_PC1;
         sig_PC <= sig_PC;
         zw_PC <= zw_PC;
         zw_REG_ALU <= zw_REG_ALU;
         zw_REG_NMI <= zw_REG_NMI or nmi_i;
         zw_REG_OP <= zw_REG_OP;
         zw_REG_sig_PC <= zw_REG_sig_PC;
         zw_b1 <= zw_b1;
         zw_b2 <= zw_b2;
         zw_b3 <= zw_b3;
         zw_b4 <= zw_b4;
         zw_w1 <= zw_w1;
         zw_w2 <= zw_w2;
         zw_w3 <= zw_w3;
         d_o_cld <= sig_D_OUT;
         rd_o_cld <= sig_RD;
         sync_o_cld <= sig_SYNC;
         wr_n_o_cld <= sig_RWn;
         wr_o_cld <= sig_WR;
         sel_alu_as_o_i_cld <= sel_alu_as_o_i;
         sel_alu_out_o_i_cld <= sel_alu_out_o_i;
         sel_pc_as_o_i_cld <= sel_pc_as_o_i;
         sel_pc_in_o_i_cld <= sel_pc_in_o_i;
         sel_pc_val_o_i_cld <= sel_pc_val_o_i;
         sel_rb_in_o_i_cld <= sel_rb_in_o_i;
         sel_rb_out_o_i_cld <= sel_rb_out_o_i;
         sel_reg_o_i_cld <= sel_reg_o_i;
         sel_sp_as_o_i_cld <= sel_sp_as_o_i;
         sel_sp_in_o_i_cld <= sel_sp_in_o_i;
         sel_sp_val_o_i_cld <= sel_sp_val_o_i;

         -- Combined Actions
         case current_state is
            when FETCH => 
               zw_REG_OP <= d_i;
               if ((nmi_i = '1') and (rdy_i = '1')) then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_REG_NMI <= '0';
               elsif ((irq_n_i = '0' and
                      reg_F(2) = '0') and (rdy_i = '1')) then 
                  sig_PC <= adr_nxt_pc_i;
               elsif ((d_i = X"69" or
                      d_i = X"65" or
                      d_i = X"75" or
                      d_i = X"6D" or
                      d_i = X"7D" or
                      d_i = X"79" or
                      d_i = X"61" or
                      d_i = X"71") and (rdy_i = '1')) then 
                  sig_PC <= adr_nxt_pc_i;
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
                  sel_reg_o_i_cld <= "00";
                  sel_rb_in_o_i_cld <= "011";
                  zw_b1(0) <= reg_F(7);
               elsif ((d_i = X"06" or
                      d_i = X"16" or
                      d_i = X"0E" or
                      d_i = X"1E") and (rdy_i = '1')) then 
                  sig_PC <= adr_nxt_pc_i;
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
               elsif ((d_i = X"90" or
                      d_i = X"B0" or
                      d_i = X"F0" or
                      d_i = X"30" or
                      d_i = X"D0" or
                      d_i = X"10" or
                      d_i = X"50" or
                      d_i = X"70") and (rdy_i = '1')) then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b3 <= adr_nxt_pc_i (15 downto 8);
               elsif ((d_i = X"24" or
                      d_i = X"2C") and (rdy_i = '1')) then 
                  sig_PC <= adr_nxt_pc_i;
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
               elsif ((d_i = X"00") and (rdy_i = '1')) then 
                  sig_PC <= adr_nxt_pc_i;
               elsif ((d_i = X"18") and (rdy_i = '1')) then 
               elsif ((d_i = X"D8") and (rdy_i = '1')) then 
               elsif ((d_i = X"58") and (rdy_i = '1')) then 
               elsif ((d_i = X"B8") and (rdy_i = '1')) then 
               elsif ((d_i = X"E0" or
                      d_i = X"E4" or
                      d_i = X"EC") and (rdy_i = '1')) then 
                  sel_rb_out_o_i_cld <= "001";
                  sig_PC <= adr_nxt_pc_i;
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
               elsif ((d_i = X"C0" or
                      d_i = X"C4" or
                      d_i = X"CC") and (rdy_i = '1')) then 
                  sel_rb_out_o_i_cld <= "010";
                  sig_PC <= adr_nxt_pc_i;
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
               elsif ((d_i = X"C6" or
                      d_i = X"D6" or
                      d_i = X"CE" or
                      d_i = X"DE") and (rdy_i = '1')) then 
                  zw_b4 <= X"FF";
                  sig_PC <= adr_nxt_pc_i;
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
               elsif ((d_i = X"CA") and (rdy_i = '1')) then 
                  sel_rb_out_o_i_cld <= "001";
                  sel_reg_o_i_cld <= "01";
                  sel_rb_in_o_i_cld <= "011";
                  zw_b4 <= X"FF";
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
               elsif ((d_i = X"88") and (rdy_i = '1')) then 
                  sel_rb_out_o_i_cld <= "010";
                  sel_reg_o_i_cld <= "10";
                  sel_rb_in_o_i_cld <= "011";
                  zw_b4 <= X"FF";
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
               elsif ((d_i = X"49" or
                      d_i = X"45" or
                      d_i = X"55" or
                      d_i = X"4D" or
                      d_i = X"5D" or
                      d_i = X"59" or
                      d_i = X"41" or
                      d_i = X"51" or
                      d_i = X"09" or
                      d_i = X"05" or
                      d_i = X"15" or
                      d_i = X"0D" or
                      d_i = X"1D" or
                      d_i = X"19" or
                      d_i = X"01" or
                      d_i = X"11" or
                      d_i = X"29" or
                      d_i = X"25" or
                      d_i = X"35" or
                      d_i = X"2D" or
                      d_i = X"3D" or
                      d_i = X"39" or
                      d_i = X"21" or
                      d_i = X"31" or
                      d_i = X"C9" or
                      d_i = X"C5" or
                      d_i = X"D5" or
                      d_i = X"CD" or
                      d_i = X"DD" or
                      d_i = X"D9" or
                      d_i = X"C1" or
                      d_i = X"D1") and (rdy_i = '1')) then 
                  sel_rb_out_o_i_cld <= "000";
                  sel_reg_o_i_cld <= "00";
                  sel_rb_in_o_i_cld <= "011";
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
                  sig_PC <= adr_nxt_pc_i;
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
               elsif ((d_i = X"E6" or
                      d_i = X"F6" or
                      d_i = X"EE" or
                      d_i = X"FE") and (rdy_i = '1')) then 
                  zw_b4 <= X"01";
                  sig_PC <= adr_nxt_pc_i;
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
               elsif ((d_i = X"E8") and (rdy_i = '1')) then 
                  sel_rb_out_o_i_cld <= "001";
                  sel_reg_o_i_cld <= "01";
                  sel_rb_in_o_i_cld <= "011";
                  zw_b4 <= X"01";
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
               elsif ((d_i = X"C8") and (rdy_i = '1')) then 
                  sel_rb_out_o_i_cld <= "010";
                  sel_reg_o_i_cld <= "10";
                  sel_rb_in_o_i_cld <= "011";
                  zw_b4 <= X"01";
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
               elsif ((d_i = X"4C" or
                      d_i = X"6C") and (rdy_i = '1')) then 
                  sig_PC <= adr_nxt_pc_i;
               elsif ((d_i = X"20") and (rdy_i = '1')) then 
                  sig_PC <= adr_nxt_pc_i;
               elsif ((d_i = X"A9" or
                      d_i = X"A5" or
                      d_i = X"B5" or
                      d_i = X"AD" or
                      d_i = X"BD" or
                      d_i = X"B9" or
                      d_i = X"A1" or
                      d_i = X"B1") and (rdy_i = '1')) then 
                  sel_reg_o_i_cld <= "00";
                  sel_rb_in_o_i_cld <= "011";
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
                  sig_PC <= adr_nxt_pc_i;
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
               elsif ((d_i = X"A2" or
                      d_i = X"A6" or
                      d_i = X"B6" or
                      d_i = X"AE" or
                      d_i = X"BE") and (rdy_i = '1')) then 
                  sel_reg_o_i_cld <= "01";
                  sel_rb_in_o_i_cld <= "011";
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
                  sig_PC <= adr_nxt_pc_i;
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
               elsif ((d_i = X"A0" or
                      d_i = X"A4" or
                      d_i = X"B4" or
                      d_i = X"AC" or
                      d_i = X"BC") and (rdy_i = '1')) then 
                  sel_reg_o_i_cld <= "10";
                  sel_rb_in_o_i_cld <= "011";
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
                  sig_PC <= adr_nxt_pc_i;
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
               elsif ((d_i = X"46" or
                      d_i = X"56" or
                      d_i = X"4E" or
                      d_i = X"5E") and (rdy_i = '1')) then 
                  sig_PC <= adr_nxt_pc_i;
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
               elsif ((d_i = X"EA") and (rdy_i = '1')) then 
               elsif ((d_i = X"48") and (rdy_i = '1')) then 
                  sig_PC <= adr_nxt_pc_i;
               elsif ((d_i = X"08") and (rdy_i = '1')) then 
                  sig_PC <= adr_nxt_pc_i;
               elsif ((d_i = X"68") and (rdy_i = '1')) then 
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '0';
                  sel_sp_val_o_i_cld <= "00";
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
                  sel_reg_o_i_cld <= "00";
                  sel_rb_in_o_i_cld <= "011";
               elsif ((d_i = X"28") and (rdy_i = '1')) then 
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '0';
                  sel_sp_val_o_i_cld <= "00";
               elsif ((d_i = X"26" or
                      d_i = X"36" or
                      d_i = X"2E" or
                      d_i = X"3E") and (rdy_i = '1')) then 
                  sig_PC <= adr_nxt_pc_i;
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
               elsif ((d_i = X"66" or
                      d_i = X"76" or
                      d_i = X"6E" or
                      d_i = X"7E") and (rdy_i = '1')) then 
                  sig_PC <= adr_nxt_pc_i;
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
               elsif ((d_i = X"40") and (rdy_i = '1')) then 
                  sig_PC <= adr_nxt_pc_i;
               elsif ((d_i = X"60") and (rdy_i = '1')) then 
                  sig_PC <= adr_nxt_pc_i;
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '0';
                  sel_sp_val_o_i_cld <= "00";
               elsif ((d_i = X"E9" or
                      d_i = X"E5" or
                      d_i = X"F5" or
                      d_i = X"ED" or
                      d_i = X"FD" or
                      d_i = X"F9" or
                      d_i = X"E1" or
                      d_i = X"F1") and (rdy_i = '1')) then 
                  sig_PC <= adr_nxt_pc_i;
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
                  sel_reg_o_i_cld <= "00";
                  sel_rb_in_o_i_cld <= "011";
                  zw_b1(0) <= reg_F(7);
               elsif ((d_i = X"38") and (rdy_i = '1')) then 
               elsif ((d_i = X"F8") and (rdy_i = '1')) then 
               elsif ((d_i = X"78") and (rdy_i = '1')) then 
               elsif ((d_i = X"85" or
                      d_i = X"95" or
                      d_i = X"8D" or
                      d_i = X"9D" or
                      d_i = X"99" or
                      d_i = X"81" or
                      d_i = X"91" or
                      d_i = X"11") and (rdy_i = '1')) then 
                  sel_rb_out_o_i_cld <= "000";
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
                  sig_PC <= adr_nxt_pc_i;
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
               elsif ((d_i = X"86" or
                      d_i = X"96" or
                      d_i = X"8E") and (rdy_i = '1')) then 
                  sel_rb_out_o_i_cld <= "001";
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
                  sig_PC <= adr_nxt_pc_i;
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
               elsif ((d_i = X"84" or
                      d_i = X"94" or
                      d_i = X"8C") and (rdy_i = '1')) then 
                  sel_rb_out_o_i_cld <= "010";
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
                  sig_PC <= adr_nxt_pc_i;
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
               elsif ((d_i = X"AA") and (rdy_i = '1')) then 
                  sel_rb_out_o_i_cld <= "000";
                  sel_reg_o_i_cld <= "01";
                  sel_rb_in_o_i_cld <= "000";
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
                  sel_sp_in_o_i_cld <= "01";
                  sel_sp_as_o_i_cld <= '0';
                  sel_sp_val_o_i_cld <= "00";
               elsif ((d_i = X"0A") and (rdy_i = '1')) then 
                  sel_rb_out_o_i_cld <= "000";
                  sel_reg_o_i_cld <= "00";
                  sel_rb_in_o_i_cld <= "011";
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
               elsif ((d_i = X"4A") and (rdy_i = '1')) then 
                  sel_rb_out_o_i_cld <= "000";
                  sel_reg_o_i_cld <= "00";
                  sel_rb_in_o_i_cld <= "011";
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
               elsif ((d_i = X"2A") and (rdy_i = '1')) then 
                  sel_rb_out_o_i_cld <= "000";
                  sel_reg_o_i_cld <= "00";
                  sel_rb_in_o_i_cld <= "011";
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
               elsif ((d_i = X"6A") and (rdy_i = '1')) then 
                  sel_rb_out_o_i_cld <= "000";
                  sel_reg_o_i_cld <= "00";
                  sel_rb_in_o_i_cld <= "011";
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
               elsif ((d_i = X"A8") and (rdy_i = '1')) then 
                  sel_rb_out_o_i_cld <= "000";
                  sel_reg_o_i_cld <= "10";
                  sel_rb_in_o_i_cld <= "000";
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
                  sel_sp_in_o_i_cld <= "01";
                  sel_sp_as_o_i_cld <= '0';
                  sel_sp_val_o_i_cld <= "00";
               elsif ((d_i = X"98") and (rdy_i = '1')) then 
                  sel_rb_out_o_i_cld <= "010";
                  sel_reg_o_i_cld <= "00";
                  sel_rb_in_o_i_cld <= "001";
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
                  sel_sp_in_o_i_cld <= "01";
                  sel_sp_as_o_i_cld <= '0';
                  sel_sp_val_o_i_cld <= "00";
               elsif ((d_i = X"BA") and (rdy_i = '1')) then 
                  sel_rb_out_o_i_cld <= "001";
                  sel_reg_o_i_cld <= "01";
                  sel_rb_in_o_i_cld <= "011";
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
                  sel_sp_in_o_i_cld <= "01";
                  sel_sp_as_o_i_cld <= '0';
                  sel_sp_val_o_i_cld <= "00";
               elsif ((d_i = X"8A") and (rdy_i = '1')) then 
                  sel_rb_out_o_i_cld <= "001";
                  sel_reg_o_i_cld <= "00";
                  sel_rb_in_o_i_cld <= "010";
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
                  sel_sp_in_o_i_cld <= "01";
                  sel_sp_as_o_i_cld <= '0';
                  sel_sp_val_o_i_cld <= "00";
               elsif ((d_i = X"9A") and (rdy_i = '1')) then 
                  sel_rb_out_o_i_cld <= "001";
                  sel_reg_o_i_cld <= "11";
                  sel_rb_in_o_i_cld <= "111";
                  sel_alu_out_o_i_cld <= "110";
                  sel_alu_as_o_i_cld <= '0';
                  sel_sp_in_o_i_cld <= "01";
                  sel_sp_as_o_i_cld <= '0';
                  sel_sp_val_o_i_cld <= "00";
               end if;
            when s1 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               end if;
            when s2 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_F(0) <= '1';
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               end if;
            when s5 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_F(3) <= '1';
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               end if;
            when s3 => 
               sig_PC <= adr_pc_i;
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_F(2) <= '1';
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               end if;
            when s4 => 
               if (rdy_i = '1' and
                   zw_REG_OP = X"9A") then 
                  sig_PC <= adr_pc_i;
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"BA") then 
                  sig_PC <= adr_pc_i;
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               elsif (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               end if;
            when s12 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_F(0) <= '0';
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               end if;
            when s16 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_F(3) <= '0';
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               end if;
            when s17 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_F(2) <= '0';
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               end if;
            when s24 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_F(6) <= '0';
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               end if;
            when s25 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               end if;
            when s271 => 
               if (rdy_i = '1' and
                   zw_REG_OP = X"4C") then 
                  sig_PC <= adr_nxt_pc_i;
                  sel_pc_in_o_i_cld <= "01";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "11";
                  zw_b1 <= d_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"6C") then 
                  sig_PC <= adr_nxt_pc_i;
                  sel_pc_in_o_i_cld <= "01";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  zw_b1 <= d_i;
               end if;
            when s273 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
               end if;
            when s304 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  sel_pc_in_o_i_cld <= "01";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "11";
                  zw_b1 <= d_i;
               end if;
            when s307 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               end if;
            when s177 => 
               if (rdy_i = '1' and
                   (zw_REG_OP = X"85" OR
                   zw_REG_OP = X"86" OR
                   zw_REG_OP = X"84")) then 
                  sig_PC <= X"00" & d_i;
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"95" OR
                      zw_REG_OP = X"94")) then 
                  sig_PC <= X"00" & d_i;
                  zw_b1 <= d_alu_i;
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"8D" OR
                      zw_REG_OP = X"8E" OR
                      zw_REG_OP = X"8C")) then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b1 <= d_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"9D") then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b1 <= d_alu_i;
                  zw_b2(0) <= reg_0flag_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"99") then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b1 <= d_alu_i;
                  zw_b2(0) <= reg_0flag_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"91") then 
                  sig_PC <= X"00" & d_i;
                  zw_b1 <= d_alu_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"81") then 
                  sig_PC <= X"00" & d_i;
                  zw_b1 <= d_alu_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"96") then 
                  sig_PC <= X"00" & d_i;
                  zw_b1 <= d_alu_i;
               end if;
            when s180 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
                  zw_b3 <= d_alu_i;
               end if;
            when s181 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & zw_b1;
                  zw_b1 <= d_alu_i;
                  zw_b2(0) <= reg_0flag_i;
               end if;
            when s182 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
                  zw_b3 <= d_alu_i;
               end if;
            when s183 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
               end if;
            when s184 => 
               sig_PC <= adr_pc_i;
               sel_pc_in_o_i_cld <= "00";
               sel_pc_as_o_i_cld <= '0';
               sel_pc_val_o_i_cld <= "00";
               sel_sp_in_o_i_cld <= "00";
               sel_sp_as_o_i_cld <= '1';
               sel_sp_val_o_i_cld <= "00";
            when s185 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & zw_b1;
               end if;
            when s186 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & zw_b1;
               end if;
            when s187 => 
               sig_PC <= adr_pc_i;
               sel_pc_in_o_i_cld <= "00";
               sel_pc_as_o_i_cld <= '0';
               sel_pc_val_o_i_cld <= "00";
               sel_sp_in_o_i_cld <= "00";
               sel_sp_as_o_i_cld <= '1';
               sel_sp_val_o_i_cld <= "00";
            when s188 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & d_alu_i;
                  zw_b1 <= d_i;
               end if;
            when s189 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
                  zw_b3 <= d_alu_i;
               end if;
            when s190 => 
               sig_PC <= adr_pc_i;
               sel_pc_in_o_i_cld <= "00";
               sel_pc_as_o_i_cld <= '0';
               sel_pc_val_o_i_cld <= "00";
               sel_sp_in_o_i_cld <= "00";
               sel_sp_as_o_i_cld <= '1';
               sel_sp_val_o_i_cld <= "00";
            when s191 => 
               sig_PC <= zw_b3 & zw_b1;
            when s192 => 
               sig_PC <= d_i & zw_b1;
            when s193 => 
               sig_PC <= adr_pc_i;
               sel_pc_in_o_i_cld <= "00";
               sel_pc_as_o_i_cld <= '0';
               sel_pc_val_o_i_cld <= "00";
               sel_sp_in_o_i_cld <= "00";
               sel_sp_as_o_i_cld <= '1';
               sel_sp_val_o_i_cld <= "00";
            when s377 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_sp_i;
               end if;
            when s381 => 
               sig_PC <= adr_pc_i;
               sel_pc_in_o_i_cld <= "00";
               sel_pc_as_o_i_cld <= '0';
               sel_pc_val_o_i_cld <= "00";
               sel_sp_in_o_i_cld <= "00";
               sel_sp_as_o_i_cld <= '1';
               sel_sp_val_o_i_cld <= "00";
            when s378 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_sp_i;
               end if;
            when s382 => 
               sig_PC <= adr_pc_i;
               sel_pc_in_o_i_cld <= "00";
               sel_pc_as_o_i_cld <= '0';
               sel_pc_val_o_i_cld <= "00";
               sel_sp_in_o_i_cld <= "00";
               sel_sp_as_o_i_cld <= '1';
               sel_sp_val_o_i_cld <= "00";
            when s383 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_sp_i;
               end if;
            when s384 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               end if;
            when s385 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_sp_i;
               end if;
            when s386 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_F <= d_i;
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               end if;
            when s387 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_sp_i;
               end if;
            when s388 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_sp_i;
               end if;
            when s389 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_sp_i;
                  reg_F <= d_i;
                  sel_pc_in_o_i_cld <= "01";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "11";
               end if;
            when s391 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_sp_i;
                  zw_b1 <= d_i;
               end if;
            when s392 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               end if;
            when s390 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_sp_i;
               end if;
            when s393 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_sp_i;
               end if;
            when s394 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_sp_i;
                  zw_b1 <= d_i;
                  sel_pc_in_o_i_cld <= "01";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
               end if;
            when s395 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
               end if;
            when s396 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               end if;
            when s397 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_sp_i;
                  zw_b1 <= d_i;
               end if;
            when s399 => 
               sig_PC <= adr_sp_i;
            when s400 => 
               sig_PC <= adr_pc_i;
               sel_pc_in_o_i_cld <= "01";
               sel_pc_as_o_i_cld <= '0';
               sel_pc_val_o_i_cld <= "11";
            when s401 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1 (7 downto 0);
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               end if;
            when s526 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_sp_i;
               end if;
            when s527 => 
               sig_PC <= adr_sp_i;
            when s528 => 
               sig_PC <= adr_sp_i;
            when s529 => 
               sig_PC <= X"FFFE";
            when s530 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
                  reg_F(2) <= '1';
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               end if;
            when s531 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"FFFF";
                  sel_pc_in_o_i_cld <= "01";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "11";
                  zw_b1 <= d_i;
               end if;
            when s544 => 
               sig_PC <= adr_sp_i;
            when s545 => 
               sig_PC <= adr_sp_i;
               sel_pc_in_o_i_cld <= "00";
               sel_pc_as_o_i_cld <= '0';
               sel_pc_val_o_i_cld <= "00";
            when s546 => 
               sig_PC <= adr_pc_i;
            when s547 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  zw_w1 (7 downto 0) <= d_i;
                  sel_pc_in_o_i_cld <= "01";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "11";
               end if;
            when s549 => 
               if (rdy_i = '1') then 
                  sig_PC  <= d_i & zw_w1 (7 downto 0);
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               end if;
            when s550 => 
               sig_PC <= adr_sp_i;
               sel_pc_in_o_i_cld <= "01";
               sel_pc_as_o_i_cld <= '0';
               sel_pc_val_o_i_cld <= "00";
            when s404 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_F(0) <= q_a_i(7);
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               end if;
            when s556 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_F(0) <= q_a_i(0);
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               end if;
            when s557 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_F(0) <= q_a_i(7);
                  reg_F(0) <= q_a_i(7);
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               end if;
            when s579 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_F(0) <= q_a_i(0);
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               end if;
            when s201 => 
               if (rdy_i = '1' and
                   (zw_REG_OP = X"A5" OR zw_REG_OP = X"A6" OR
                   zw_REG_OP = X"A4" OR zw_REG_OP = X"45" OR
                   zw_REG_OP = X"05" OR zw_REG_OP = X"25" OR
                   zw_REG_OP = X"C5" OR zw_REG_OP = X"E4" OR zw_REG_OP = X"C4")) then 
                  sig_PC <= X"00" & d_i;
               elsif ((rdy_i = '1' and
                      (zw_REG_OP = X"A9" OR zw_REG_OP = X"A2" OR zw_REG_OP = X"A0" OR zw_REG_OP = X"E0" OR zw_REG_OP = X"C0" OR
                      zw_REG_OP = X"49" or zw_REG_OP = X"09" or zw_REG_OP = X"29" or zw_REG_OP = X"C9")) and (zw_REG_OP = X"09" or zw_REG_OP = X"05" or
                      zw_REG_OP = X"15" or zw_REG_OP = X"0D" or
                      zw_REG_OP = X"1D" or zw_REG_OP = X"19" or 
                      zw_REG_OP = X"01" or zw_REG_OP = X"11")) then 
                  sig_PC <= adr_nxt_pc_i;
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               elsif ((rdy_i = '1' and
                      (zw_REG_OP = X"A9" OR zw_REG_OP = X"A2" OR zw_REG_OP = X"A0" OR zw_REG_OP = X"E0" OR zw_REG_OP = X"C0" OR
                      zw_REG_OP = X"49" or zw_REG_OP = X"09" or zw_REG_OP = X"29" or zw_REG_OP = X"C9")) and (zw_REG_OP = X"49" or zw_REG_OP = X"45" or
                      zw_REG_OP = X"55" or zw_REG_OP = X"4D" or
                      zw_REG_OP = X"5D" or zw_REG_OP = X"59" or
                      zw_REG_OP = X"41" or zw_REG_OP = X"51")) then 
                  sig_PC <= adr_nxt_pc_i;
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               elsif ((rdy_i = '1' and
                      (zw_REG_OP = X"A9" OR zw_REG_OP = X"A2" OR zw_REG_OP = X"A0" OR zw_REG_OP = X"E0" OR zw_REG_OP = X"C0" OR
                      zw_REG_OP = X"49" or zw_REG_OP = X"09" or zw_REG_OP = X"29" or zw_REG_OP = X"C9")) and (zw_REG_OP = X"29" or zw_REG_OP = X"25" or
                      zw_REG_OP = X"35" or zw_REG_OP = X"2D" or
                      zw_REG_OP = X"3D" or zw_REG_OP = X"39" or
                       zw_REG_OP = X"21" or zw_REG_OP = X"31")) then 
                  sig_PC <= adr_nxt_pc_i;
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               elsif ((rdy_i = '1' and
                      (zw_REG_OP = X"A9" OR zw_REG_OP = X"A2" OR zw_REG_OP = X"A0" OR zw_REG_OP = X"E0" OR zw_REG_OP = X"C0" OR
                      zw_REG_OP = X"49" or zw_REG_OP = X"09" or zw_REG_OP = X"29" or zw_REG_OP = X"C9")) and (zw_REG_OP = X"C9" or zw_REG_OP = X"C5" or
                      zw_REG_OP = X"D5" or zw_REG_OP = X"CD" or
                      zw_REG_OP = X"DD" or zw_REG_OP = X"D9" or
                      zw_REG_OP = X"C1" or zw_REG_OP = X"D1" or
                       zw_REG_OP = X"C0" or zw_REG_OP = X"E0" or
                       zw_REG_OP = X"C4" or zw_REG_OP = X"E4" or
                       zw_REG_OP = X"CC" or zw_REG_OP = X"EC")) then 
                  sig_PC <= adr_nxt_pc_i;
                  reg_F(7) <= zw_ALU(7);
                  reg_F(0) <= zw_ALU(8);
                  reg_F(1) <= NOT ((zw_ALU(7)) OR (zw_ALU(6)) OR (zw_ALU(5)) OR 
                  (zw_ALU(4)) OR (zw_ALU(3)) OR (zw_ALU(2)) OR (zw_ALU(1)) OR 
                  (zw_ALU(0)));
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"A9" OR zw_REG_OP = X"A2" OR zw_REG_OP = X"A0" OR zw_REG_OP = X"E0" OR zw_REG_OP = X"C0" OR
                      zw_REG_OP = X"49" or zw_REG_OP = X"09" or zw_REG_OP = X"29" or zw_REG_OP = X"C9")) then 
                  sig_PC <= adr_nxt_pc_i;
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"B5" OR
                      zw_REG_OP = X"B4" OR
                      zw_REG_OP = X"55" OR zw_REG_OP = X"15" OR
                      zw_REG_OP = X"35" OR
                      zw_REG_OP = X"D5")) then 
                  sig_PC <= X"00" & d_i;
                  zw_b1 <= d_alu_i;
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"AD" OR
                      zw_REG_OP = X"AE" OR
                      zw_REG_OP = X"AC" OR
                      zw_REG_OP = X"4D" OR
                      zw_REG_OP = X"0D" OR
                      zw_REG_OP = X"2D" OR
                      zw_REG_OP = X"CD" OR
                      zw_REG_OP = X"EC" OR
                      zw_REG_OP = X"CC")) then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b1 <= d_i;
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"BD" OR
                      zw_REG_OP = X"BC" OR
                      zw_REG_OP = X"5D" OR
                      zw_REG_OP = X"1D" OR
                      zw_REG_OP = X"3D" OR
                      zw_REG_OP = X"DD")) then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b1 <= d_alu_i;
                  zw_b2(0) <= reg_0flag_i;
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"B9" OR
                      zw_REG_OP = X"BE" OR
                      zw_REG_OP = X"59" OR
                      zw_REG_OP = X"19" OR
                      zw_REG_OP = X"39" OR
                      zw_REG_OP = X"D9")) then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b1 <= d_alu_i;
                  zw_b2(0) <= reg_0flag_i;
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"B1" OR
                      zw_REG_OP = X"51" OR
                      zw_REG_OP = X"11" OR
                      zw_REG_OP = X"31" OR
                      zw_REG_OP = X"D1")) then 
                  sig_PC <= X"00" & d_i;
                  zw_b1 <= d_alu_i;
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"A1" OR
                      zw_REG_OP = X"41" OR
                      zw_REG_OP = X"01" OR
                      zw_REG_OP = X"21" OR
                      zw_REG_OP = X"C1")) then 
                  sig_PC <= X"00" & d_i;
                  zw_b1 <= d_alu_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"B6") then 
                  sig_PC <= X"00" & d_i;
                  zw_b1 <= d_alu_i;
               end if;
            when s202 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
               end if;
            when s210 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
                  zw_b3 <= d_alu_i;
               end if;
            when s211 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
                  zw_b3 <= d_alu_i;
               end if;
            when s215 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & zw_b1;
                  zw_b1 <= d_alu_i;
                  zw_b2(0) <= reg_0flag_i;
               end if;
            when s217 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & zw_b1;
               end if;
            when s218 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & zw_b1;
               end if;
            when s222 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & d_alu_i;
                  zw_b1 <= d_i;
               end if;
            when s223 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
                  zw_b3 <= d_alu_i;
               end if;
            when s224 => 
               if ((rdy_i = '1') and (zw_REG_OP = X"09" or zw_REG_OP = X"05" or
                   zw_REG_OP = X"15" or zw_REG_OP = X"0D" or
                   zw_REG_OP = X"1D" or zw_REG_OP = X"19" or 
                   zw_REG_OP = X"01" or zw_REG_OP = X"11")) then 
                  sig_PC <= adr_pc_i;
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               elsif ((rdy_i = '1') and (zw_REG_OP = X"49" or zw_REG_OP = X"45" or
                      zw_REG_OP = X"55" or zw_REG_OP = X"4D" or
                      zw_REG_OP = X"5D" or zw_REG_OP = X"59" or
                      zw_REG_OP = X"41" or zw_REG_OP = X"51")) then 
                  sig_PC <= adr_pc_i;
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               elsif ((rdy_i = '1') and (zw_REG_OP = X"29" or zw_REG_OP = X"25" or
                      zw_REG_OP = X"35" or zw_REG_OP = X"2D" or
                      zw_REG_OP = X"3D" or zw_REG_OP = X"39" or
                       zw_REG_OP = X"21" or zw_REG_OP = X"31")) then 
                  sig_PC <= adr_pc_i;
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               elsif ((rdy_i = '1') and (zw_REG_OP = X"C9" or zw_REG_OP = X"C5" or
                      zw_REG_OP = X"D5" or zw_REG_OP = X"CD" or
                      zw_REG_OP = X"DD" or zw_REG_OP = X"D9" or
                      zw_REG_OP = X"C1" or zw_REG_OP = X"D1" or
                       zw_REG_OP = X"C0" or zw_REG_OP = X"E0" or
                       zw_REG_OP = X"C4" or zw_REG_OP = X"E4" or
                       zw_REG_OP = X"CC" or zw_REG_OP = X"EC")) then 
                  sig_PC <= adr_pc_i;
                  reg_F(7) <= zw_ALU(7);
                  reg_F(0) <= zw_ALU(8);
                  reg_F(1) <= NOT ((zw_ALU(7)) OR (zw_ALU(6)) OR (zw_ALU(5)) OR 
                  (zw_ALU(4)) OR (zw_ALU(3)) OR (zw_ALU(2)) OR (zw_ALU(1)) OR 
                  (zw_ALU(0)));
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               elsif (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               end if;
            when s225 => 
               if ((rdy_i = '1' AND
                   zw_b2(0) = '0') and (zw_REG_OP = X"09" or zw_REG_OP = X"05" or
                   zw_REG_OP = X"15" or zw_REG_OP = X"0D" or
                   zw_REG_OP = X"1D" or zw_REG_OP = X"19" or 
                   zw_REG_OP = X"01" or zw_REG_OP = X"11")) then 
                  sig_PC <= adr_pc_i;
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               elsif ((rdy_i = '1' AND
                      zw_b2(0) = '0') and (zw_REG_OP = X"49" or zw_REG_OP = X"45" or
                      zw_REG_OP = X"55" or zw_REG_OP = X"4D" or
                      zw_REG_OP = X"5D" or zw_REG_OP = X"59" or
                      zw_REG_OP = X"41" or zw_REG_OP = X"51")) then 
                  sig_PC <= adr_pc_i;
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               elsif ((rdy_i = '1' AND
                      zw_b2(0) = '0') and (zw_REG_OP = X"29" or zw_REG_OP = X"25" or
                      zw_REG_OP = X"35" or zw_REG_OP = X"2D" or
                      zw_REG_OP = X"3D" or zw_REG_OP = X"39" or
                       zw_REG_OP = X"21" or zw_REG_OP = X"31")) then 
                  sig_PC <= adr_pc_i;
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               elsif ((rdy_i = '1' AND
                      zw_b2(0) = '0') and (zw_REG_OP = X"C9" or zw_REG_OP = X"C5" or
                      zw_REG_OP = X"D5" or zw_REG_OP = X"CD" or
                      zw_REG_OP = X"DD" or zw_REG_OP = X"D9" or
                      zw_REG_OP = X"C1" or zw_REG_OP = X"D1" or
                       zw_REG_OP = X"C0" or zw_REG_OP = X"E0" or
                       zw_REG_OP = X"C4" or zw_REG_OP = X"E4" or
                       zw_REG_OP = X"CC" or zw_REG_OP = X"EC")) then 
                  sig_PC <= adr_pc_i;
                  reg_F(7) <= zw_ALU(7);
                  reg_F(0) <= zw_ALU(8);
                  reg_F(1) <= NOT ((zw_ALU(7)) OR (zw_ALU(6)) OR (zw_ALU(5)) OR 
                  (zw_ALU(4)) OR (zw_ALU(3)) OR (zw_ALU(2)) OR (zw_ALU(1)) OR 
                  (zw_ALU(0)));
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               elsif (rdy_i = '1' AND
                      zw_b2(0) = '0') then 
                  sig_PC <= adr_pc_i;
                  reg_F(7) <= reg_7flag_i;
                  reg_F(1) <= reg_1flag_i;
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               elsif (rdy_i = '1') then 
                  sig_PC <= zw_b3 & zw_b1;
               end if;
            when s226 => 
               if (rdy_i = '1' and
                   (zw_REG_OP = X"C6" OR
                   zw_REG_OP = X"E6")) then 
                  sig_PC <= X"00" & d_i;
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"D6" OR
                      zw_REG_OP = X"F6")) then 
                  sig_PC <= X"00" & d_i;
                  zw_b1 <= d_alu_i;
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"CE" OR
                      zw_REG_OP = X"EE")) then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b1 <= d_i;
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"DE" OR
                      zw_REG_OP = X"FE")) then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b1 <= d_alu_i;
                  zw_b2(0) <= reg_0flag_i;
               end if;
            when s243 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
               end if;
            when s244 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
                  zw_b3 <= d_alu_i;
               end if;
            when s247 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & zw_b1;
               end if;
            when s344 => 
               if (rdy_i = '1') then 
                  sig_PC <= zw_b3 & zw_b1;
               end if;
            when s343 => 
               if (rdy_i = '1') then 
                  zw_b1 <= d_alu_i;
               end if;
            when s251 => 
               sig_PC <= adr_pc_i;
               reg_F(7) <= reg_7flag_i;
               reg_F(1) <= reg_1flag_i;
               sel_pc_in_o_i_cld <= "00";
               sel_pc_as_o_i_cld <= '0';
               sel_pc_val_o_i_cld <= "00";
               sel_sp_in_o_i_cld <= "00";
               sel_sp_as_o_i_cld <= '1';
               sel_sp_val_o_i_cld <= "00";
            when s351 => 
               if (rdy_i = '1' and
                   zw_REG_OP = X"24") then 
                  sig_PC <= X"00" & d_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"2C") then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b1 <= d_i;
               end if;
            when s361 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  reg_F(7) <= d_i(7);
                  reg_F(6) <= d_i(6);
                  reg_F(1) <= reg_1flag_i;
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               end if;
            when s360 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
               end if;
            when s403 => 
               if (rdy_i = '1' and
                   (zw_REG_OP = X"1E" or
                   zw_REG_OP = X"7E" or
                   zw_REG_OP = X"3E" or
                   zw_REG_OP = X"5E")) then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b1 <= d_alu_i;
                  zw_b2(0) <= reg_0flag_i;
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"06" or
                      zw_REG_OP = X"66" or
                      zw_REG_OP = X"26" or
                      zw_REG_OP = X"46")) then 
                  sig_PC <= X"00" & d_i;
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"16" or
                      zw_REG_OP = X"76" or
                      zw_REG_OP = X"36" or
                      zw_REG_OP = X"56")) then 
                  sig_PC <= X"00" & d_i;
                  zw_b1 <= d_alu_i;
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"0E" or
                      zw_REG_OP = X"6E" or
                      zw_REG_OP = X"2E" or
                      zw_REG_OP = X"4E")) then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b1 <= d_i;
               end if;
            when s406 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
               end if;
            when s407 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
                  zw_b3 <= d_alu_i;
               end if;
            when s409 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & zw_b1;
               end if;
            when s412 => 
               if (rdy_i = '1') then 
                  sig_PC <= zw_b3 & zw_b1;
               end if;
            when s416 => 
               if (rdy_i = '1' and
                   (zw_REG_OP = X"06" or
                   zw_REG_OP = X"16" or
                   zw_REG_OP = X"0E" or
                   zw_REG_OP = X"1E")) then 
                  zw_b1 <= d_i(6 downto 0) & '0';
                  zw_b2(0) <= d_i(7);
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"46" or
                      zw_REG_OP = X"56" or
                      zw_REG_OP = X"4E" or
                      zw_REG_OP = X"5E")) then 
                  zw_b1 <= '0' & d_i(7 downto 1);
                  zw_b2(0) <= d_i(0);
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"26" or
                      zw_REG_OP = X"36" or
                      zw_REG_OP = X"2E" or
                      zw_REG_OP = X"3E")) then 
                  zw_b1 <= d_i(6 downto 0) & reg_F(0);
                  zw_b2(0) <= d_i(7);
               elsif (rdy_i = '1' and
                      (zw_REG_OP = X"66" or
                      zw_REG_OP = X"76" or
                      zw_REG_OP = X"6E" or
                      zw_REG_OP = X"7E")) then 
                  zw_b1 <= reg_F(0) & d_i(7 downto 1);
                  zw_b2(0) <= d_i(0);
               end if;
            when s418 => 
               sig_PC <= adr_pc_i;
               reg_F(0) <= zw_b2(0);
               reg_F(7) <= reg_7flag_i;
               reg_F(1) <= reg_1flag_i;
               sel_pc_in_o_i_cld <= "00";
               sel_pc_as_o_i_cld <= '0';
               sel_pc_val_o_i_cld <= "00";
               sel_sp_in_o_i_cld <= "00";
               sel_sp_as_o_i_cld <= '1';
               sel_sp_val_o_i_cld <= "00";
            when s510 => 
               if (rdy_i = '1' and
                   zw_REG_OP = X"65") then 
                  sig_PC <= X"00" & d_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"69" and
                      reg_F(3) = '0') then 
                  sig_PC <= adr_nxt_pc_i;
                  
                  reg_F(7) <= zw_ALU(7);
                  reg_F(6) <= zw_b1(0) XOR zw_ALU(7);
                  reg_F(1) <= NOT ((zw_ALU(7)) OR (zw_ALU(6)) OR (zw_ALU(5)) OR 
                  (zw_ALU(4)) OR (zw_ALU(3)) OR (zw_ALU(2)) OR (zw_ALU(1)) OR 
                  (zw_ALU(0)));
                  reg_F(0) <= zw_ALU(8);
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"75") then 
                  sig_PC <= X"00" & d_i;
                  zw_b1 <= d_alu_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"6D") then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b1 <= d_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"7D") then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b1 <= d_alu_i;
                  zw_b2(0) <= reg_0flag_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"79") then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b1 <= d_alu_i;
                  zw_b2(0) <= reg_0flag_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"71") then 
                  sig_PC <= X"00" & d_i;
                  zw_b1 <= d_alu_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"61") then 
                  sig_PC <= X"00" & d_i;
                  zw_b1 <= d_alu_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"69" and
                      reg_F(3) = '1') then 
                  sig_PC <= adr_nxt_pc_i;
                  
                  reg_F(7) <= zw_ALU(7);
                  reg_F(6) <= zw_b1(0) XOR zw_ALU(7);
                  reg_F(1) <= NOT ((zw_ALU(7)) OR (zw_ALU(6)) OR (zw_ALU(5)) OR 
                  (zw_ALU(4)) OR (zw_ALU(3)) OR (zw_ALU(2)) OR (zw_ALU(1)) OR 
                  (zw_ALU(0)));
                  reg_F(0) <= zw_ALU4(4);
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               end if;
            when s553 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
               end if;
            when s555 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
                  zw_b3 <= d_alu_i;
               end if;
            when s558 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & zw_b1;
                  zw_b1 <= d_alu_i;
                  zw_b2(0) <= reg_0flag_i;
               end if;
            when s560 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & zw_b1;
               end if;
            when s561 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & zw_b1;
               end if;
            when s563 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & d_alu_i;
                  zw_b1 <= d_i;
               end if;
            when s564 => 
               if (rdy_i = '1' AND
                   zw_b2(0) = '0' and
                   reg_F(3) = '0') then 
                  sig_PC <= adr_pc_i;
                  
                  reg_F(7) <= zw_ALU(7);
                  reg_F(6) <= zw_b1(0) XOR zw_ALU(7);
                  reg_F(1) <= NOT ((zw_ALU(7)) OR (zw_ALU(6)) OR (zw_ALU(5)) OR 
                  (zw_ALU(4)) OR (zw_ALU(3)) OR (zw_ALU(2)) OR (zw_ALU(1)) OR 
                  (zw_ALU(0)));
                  reg_F(0) <= zw_ALU(8);
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               elsif (rdy_i = '1' AND
                      zw_b2(0) = '0' and
                      reg_F(3) = '1') then 
                  sig_PC <= adr_pc_i;
                  
                  reg_F(7) <= zw_ALU(7);
                  reg_F(6) <= zw_b1(0) XOR zw_ALU(7);
                  reg_F(1) <= NOT ((zw_ALU(7)) OR (zw_ALU(6)) OR (zw_ALU(5)) OR 
                  (zw_ALU(4)) OR (zw_ALU(3)) OR (zw_ALU(2)) OR (zw_ALU(1)) OR 
                  (zw_ALU(0)));
                  reg_F(0) <= zw_ALU4(4);
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               elsif (rdy_i = '1') then 
                  sig_PC <= zw_b3 & zw_b1;
               end if;
            when s565 => 
               if (rdy_i = '1' and
                   reg_F(3) = '0') then 
                  sig_PC <= adr_pc_i;
                  
                  reg_F(7) <= zw_ALU(7);
                  reg_F(6) <= zw_b1(0) XOR zw_ALU(7);
                  reg_F(1) <= NOT ((zw_ALU(7)) OR (zw_ALU(6)) OR (zw_ALU(5)) OR 
                  (zw_ALU(4)) OR (zw_ALU(3)) OR (zw_ALU(2)) OR (zw_ALU(1)) OR 
                  (zw_ALU(0)));
                  reg_F(0) <= zw_ALU(8);
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               elsif (rdy_i = '1' and
                      reg_F(3) = '1') then 
                  sig_PC <= adr_pc_i;
                  
                  reg_F(7) <= zw_ALU(7);
                  reg_F(6) <= zw_b1(0) XOR zw_ALU(7);
                  reg_F(1) <= NOT ((zw_ALU(7)) OR (zw_ALU(6)) OR (zw_ALU(5)) OR 
                  (zw_ALU(4)) OR (zw_ALU(3)) OR (zw_ALU(2)) OR (zw_ALU(1)) OR 
                  (zw_ALU(0)));
                  reg_F(0) <= zw_ALU4(4);
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               end if;
            when s566 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
                  zw_b3 <= d_alu_i;
               end if;
            when s266 => 
               if (rdy_i = '1' and (
                   (reg_F(0) = '1' and zw_REG_OP = X"90") or
                   (reg_F(0) = '0' and zw_REG_OP = X"B0") or
                   (reg_F(1) = '0' and zw_REG_OP = X"F0") or
                   (reg_F(7) = '0' and zw_REG_OP = X"30") or
                   (reg_F(1) = '1' and zw_REG_OP = X"D0") or
                   (reg_F(7) = '1' and zw_REG_OP = X"10") or
                   (reg_F(6) = '1' and zw_REG_OP = X"50") or
                   (reg_F(6) = '0' and zw_REG_OP = X"70"))) then 
                  sig_PC <= adr_nxt_pc_i;
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               elsif (rdy_i = '1') then 
                  sig_PC <= adr_nxt_pc_i;
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "10";
                  zw_b2 <= d_i;
               end if;
            when s301 => 
               if (rdy_i = '1' and
                   zw_b3 = adr_nxt_pc_i (15 downto 8)) then 
                  sig_PC <= adr_nxt_pc_i;
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               elsif (rdy_i = '1') then 
                  sig_PC <= zw_b3 & adr_nxt_pc_i (7 downto 0);
               end if;
            when s302 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_pc_i;
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               end if;
            when RES => 
               sel_pc_in_o_i_cld <= "00";
               sel_pc_val_o_i_cld <= "00";
               sel_pc_as_o_i_cld <= '0';
               sig_PC <= adr_nxt_pc_i;
               sel_pc_in_o_i_cld <= "00";
               sel_pc_as_o_i_cld <= '0';
               sel_pc_val_o_i_cld <= "00";
               sel_sp_in_o_i_cld <= "00";
               sel_sp_as_o_i_cld <= '1';
               sel_sp_val_o_i_cld <= "00";
            when s511 => 
               if (rdy_i = '1' and
                   zw_REG_OP = X"E5") then 
                  sig_PC <= X"00" & d_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"E9" and
                      reg_F(3) = '0') then 
                  sig_PC <= adr_nxt_pc_i;
                  
                  reg_F(7) <= zw_ALU(7);
                  reg_F(6) <= zw_b1(0) XOR zw_ALU(7);
                  reg_F(1) <= NOT ((zw_ALU(7)) OR (zw_ALU(6)) OR (zw_ALU(5)) OR 
                  (zw_ALU(4)) OR (zw_ALU(3)) OR (zw_ALU(2)) OR (zw_ALU(1)) OR 
                  (zw_ALU(0)));
                  reg_F(0) <= zw_ALU(8);
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"F5") then 
                  sig_PC <= X"00" & d_i;
                  zw_b1 <= d_alu_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"ED") then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b1 <= d_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"FD") then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b1 <= d_alu_i;
                  zw_b2(0) <= reg_0flag_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"F9") then 
                  sig_PC <= adr_nxt_pc_i;
                  zw_b1 <= d_alu_i;
                  zw_b2(0) <= reg_0flag_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"F1") then 
                  sig_PC <= X"00" & d_i;
                  zw_b1 <= d_alu_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"E1") then 
                  sig_PC <= X"00" & d_i;
                  zw_b1 <= d_alu_i;
               elsif (rdy_i = '1' and
                      zw_REG_OP = X"E9" and
                      reg_F(3) = '1') then 
                  sig_PC <= adr_nxt_pc_i;
                  
                  reg_F(7) <= zw_ALU(7);
                  reg_F(6) <= zw_b1(0) XOR zw_ALU(7);
                  reg_F(1) <= NOT ((zw_ALU(7)) OR (zw_ALU(6)) OR (zw_ALU(5)) OR 
                  (zw_ALU(4)) OR (zw_ALU(3)) OR (zw_ALU(2)) OR (zw_ALU(1)) OR 
                  (zw_ALU(0)));
                  reg_F(0) <= zw_ALU2(4);
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               end if;
            when s559 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
               end if;
            when s562 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
                  zw_b3 <= d_alu_i;
               end if;
            when s567 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
                  zw_b3 <= d_alu_i;
               end if;
            when s568 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & zw_b1;
                  zw_b1 <= d_alu_i;
                  zw_b2(0) <= reg_0flag_i;
               end if;
            when s569 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & zw_b1;
               end if;
            when s570 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & zw_b1;
               end if;
            when s571 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
                  zw_b3 <= d_alu_i;
               end if;
            when s572 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"00" & d_alu_i;
                  zw_b1 <= d_i;
               end if;
            when s573 => 
               if (rdy_i = '1' AND
                   zw_b2(0) = '0' and
                   reg_F(3) = '0') then 
                  sig_PC <= adr_pc_i;
                  
                  reg_F(7) <= zw_ALU(7);
                  reg_F(6) <= zw_b1(0) XOR zw_ALU(7);
                  reg_F(1) <= NOT ((zw_ALU(7)) OR (zw_ALU(6)) OR (zw_ALU(5)) OR 
                  (zw_ALU(4)) OR (zw_ALU(3)) OR (zw_ALU(2)) OR (zw_ALU(1)) OR 
                  (zw_ALU(0)));
                  reg_F(0) <= zw_ALU(8);
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               elsif (rdy_i = '1' AND
                      zw_b2(0) = '0' and
                      reg_F(3) = '1') then 
                  sig_PC <= adr_pc_i;
                  
                  reg_F(7) <= zw_ALU(7);
                  reg_F(6) <= zw_b1(0) XOR zw_ALU(7);
                  reg_F(1) <= NOT ((zw_ALU(7)) OR (zw_ALU(6)) OR (zw_ALU(5)) OR 
                  (zw_ALU(4)) OR (zw_ALU(3)) OR (zw_ALU(2)) OR (zw_ALU(1)) OR 
                  (zw_ALU(0)));
                  reg_F(0) <= zw_ALU2(4);
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               elsif (rdy_i = '1') then 
                  sig_PC <= zw_b3 & zw_b1;
               end if;
            when s574 => 
               if (rdy_i = '1' and
                   reg_F(3) = '0') then 
                  sig_PC <= adr_pc_i;
                  
                  reg_F(7) <= zw_ALU(7);
                  reg_F(6) <= zw_b1(0) XOR zw_ALU(7);
                  reg_F(1) <= NOT ((zw_ALU(7)) OR (zw_ALU(6)) OR (zw_ALU(5)) OR 
                  (zw_ALU(4)) OR (zw_ALU(3)) OR (zw_ALU(2)) OR (zw_ALU(1)) OR 
                  (zw_ALU(0)));
                  reg_F(0) <= zw_ALU(8);
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               elsif (rdy_i = '1' and
                      reg_F(3) = '1') then 
                  sig_PC <= adr_pc_i;
                  
                  reg_F(7) <= zw_ALU(7);
                  reg_F(6) <= zw_b1(0) XOR zw_ALU(7);
                  reg_F(1) <= NOT ((zw_ALU(7)) OR (zw_ALU(6)) OR (zw_ALU(5)) OR 
                  (zw_ALU(4)) OR (zw_ALU(3)) OR (zw_ALU(2)) OR (zw_ALU(1)) OR 
                  (zw_ALU(0)));
                  reg_F(0) <= zw_ALU2(4);
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               end if;
            when s548 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_sp_i;
               end if;
            when s551 => 
               sig_PC <= adr_sp_i;
            when s552 => 
               sig_PC <= adr_sp_i;
            when s575 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"FFFF";
                  zw_b1 <= d_i;
               end if;
            when s576 => 
               sig_PC <= X"FFFE";
            when s577 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
                  reg_F(2) <= '1';
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               end if;
            when s532 => 
               if (rdy_i = '1') then 
                  sig_PC <= adr_sp_i;
               end if;
            when s533 => 
               sig_PC <= adr_sp_i;
            when s534 => 
               sig_PC <= adr_sp_i;
            when s535 => 
               if (rdy_i = '1') then 
                  sig_PC <= X"FFFB";
                  sel_pc_in_o_i_cld <= "01";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "11";
                  zw_b1 <= d_i;
               end if;
            when s536 => 
               sig_PC <= X"FFFA";
            when s537 => 
               if (rdy_i = '1') then 
                  sig_PC <= d_i & zw_b1;
                  sel_pc_in_o_i_cld <= "00";
                  sel_pc_as_o_i_cld <= '0';
                  sel_pc_val_o_i_cld <= "00";
                  sel_sp_in_o_i_cld <= "00";
                  sel_sp_as_o_i_cld <= '1';
                  sel_sp_val_o_i_cld <= "00";
               end if;
            when others =>
               null;
         end case;
      end if;
   end process clocked_proc;
 
   -----------------------------------------------------------------
   nextstate_proc : process ( 
      adr_nxt_pc_i,
      current_state,
      d_i,
      irq_n_i,
      nmi_i,
      rdy_i,
      reg_F,
      zw_REG_OP,
      zw_b2,
      zw_b3
   )
   -----------------------------------------------------------------
   begin
      case current_state is
         when FETCH => 
            if ((nmi_i = '1') and (rdy_i = '1')) then 
               next_state <= s532;
            elsif ((irq_n_i = '0' and
                   reg_F(2) = '0') and (rdy_i = '1')) then 
               next_state <= s548;
            elsif ((d_i = X"69" or
                   d_i = X"65" or
                   d_i = X"75" or
                   d_i = X"6D" or
                   d_i = X"7D" or
                   d_i = X"79" or
                   d_i = X"61" or
                   d_i = X"71") and (rdy_i = '1')) then 
               next_state <= s510;
            elsif ((d_i = X"06" or
                   d_i = X"16" or
                   d_i = X"0E" or
                   d_i = X"1E") and (rdy_i = '1')) then 
               next_state <= s403;
            elsif ((d_i = X"90" or
                   d_i = X"B0" or
                   d_i = X"F0" or
                   d_i = X"30" or
                   d_i = X"D0" or
                   d_i = X"10" or
                   d_i = X"50" or
                   d_i = X"70") and (rdy_i = '1')) then 
               next_state <= s266;
            elsif ((d_i = X"24" or
                   d_i = X"2C") and (rdy_i = '1')) then 
               next_state <= s351;
            elsif ((d_i = X"00") and (rdy_i = '1')) then 
               next_state <= s526;
            elsif ((d_i = X"18") and (rdy_i = '1')) then 
               next_state <= s12;
            elsif ((d_i = X"D8") and (rdy_i = '1')) then 
               next_state <= s16;
            elsif ((d_i = X"58") and (rdy_i = '1')) then 
               next_state <= s17;
            elsif ((d_i = X"B8") and (rdy_i = '1')) then 
               next_state <= s24;
            elsif ((d_i = X"E0" or
                   d_i = X"E4" or
                   d_i = X"EC") and (rdy_i = '1')) then 
               next_state <= s201;
            elsif ((d_i = X"C0" or
                   d_i = X"C4" or
                   d_i = X"CC") and (rdy_i = '1')) then 
               next_state <= s201;
            elsif ((d_i = X"C6" or
                   d_i = X"D6" or
                   d_i = X"CE" or
                   d_i = X"DE") and (rdy_i = '1')) then 
               next_state <= s226;
            elsif ((d_i = X"CA") and (rdy_i = '1')) then 
               next_state <= s25;
            elsif ((d_i = X"88") and (rdy_i = '1')) then 
               next_state <= s25;
            elsif ((d_i = X"49" or
                   d_i = X"45" or
                   d_i = X"55" or
                   d_i = X"4D" or
                   d_i = X"5D" or
                   d_i = X"59" or
                   d_i = X"41" or
                   d_i = X"51" or
                   d_i = X"09" or
                   d_i = X"05" or
                   d_i = X"15" or
                   d_i = X"0D" or
                   d_i = X"1D" or
                   d_i = X"19" or
                   d_i = X"01" or
                   d_i = X"11" or
                   d_i = X"29" or
                   d_i = X"25" or
                   d_i = X"35" or
                   d_i = X"2D" or
                   d_i = X"3D" or
                   d_i = X"39" or
                   d_i = X"21" or
                   d_i = X"31" or
                   d_i = X"C9" or
                   d_i = X"C5" or
                   d_i = X"D5" or
                   d_i = X"CD" or
                   d_i = X"DD" or
                   d_i = X"D9" or
                   d_i = X"C1" or
                   d_i = X"D1") and (rdy_i = '1')) then 
               next_state <= s201;
            elsif ((d_i = X"E6" or
                   d_i = X"F6" or
                   d_i = X"EE" or
                   d_i = X"FE") and (rdy_i = '1')) then 
               next_state <= s226;
            elsif ((d_i = X"E8") and (rdy_i = '1')) then 
               next_state <= s25;
            elsif ((d_i = X"C8") and (rdy_i = '1')) then 
               next_state <= s25;
            elsif ((d_i = X"4C" or
                   d_i = X"6C") and (rdy_i = '1')) then 
               next_state <= s271;
            elsif ((d_i = X"20") and (rdy_i = '1')) then 
               next_state <= s397;
            elsif ((d_i = X"A9" or
                   d_i = X"A5" or
                   d_i = X"B5" or
                   d_i = X"AD" or
                   d_i = X"BD" or
                   d_i = X"B9" or
                   d_i = X"A1" or
                   d_i = X"B1") and (rdy_i = '1')) then 
               next_state <= s201;
            elsif ((d_i = X"A2" or
                   d_i = X"A6" or
                   d_i = X"B6" or
                   d_i = X"AE" or
                   d_i = X"BE") and (rdy_i = '1')) then 
               next_state <= s201;
            elsif ((d_i = X"A0" or
                   d_i = X"A4" or
                   d_i = X"B4" or
                   d_i = X"AC" or
                   d_i = X"BC") and (rdy_i = '1')) then 
               next_state <= s201;
            elsif ((d_i = X"46" or
                   d_i = X"56" or
                   d_i = X"4E" or
                   d_i = X"5E") and (rdy_i = '1')) then 
               next_state <= s403;
            elsif ((d_i = X"EA") and (rdy_i = '1')) then 
               next_state <= s1;
            elsif ((d_i = X"48") and (rdy_i = '1')) then 
               next_state <= s377;
            elsif ((d_i = X"08") and (rdy_i = '1')) then 
               next_state <= s378;
            elsif ((d_i = X"68") and (rdy_i = '1')) then 
               next_state <= s379;
            elsif ((d_i = X"28") and (rdy_i = '1')) then 
               next_state <= s380;
            elsif ((d_i = X"26" or
                   d_i = X"36" or
                   d_i = X"2E" or
                   d_i = X"3E") and (rdy_i = '1')) then 
               next_state <= s403;
            elsif ((d_i = X"66" or
                   d_i = X"76" or
                   d_i = X"6E" or
                   d_i = X"7E") and (rdy_i = '1')) then 
               next_state <= s403;
            elsif ((d_i = X"40") and (rdy_i = '1')) then 
               next_state <= s387;
            elsif ((d_i = X"60") and (rdy_i = '1')) then 
               next_state <= s390;
            elsif ((d_i = X"E9" or
                   d_i = X"E5" or
                   d_i = X"F5" or
                   d_i = X"ED" or
                   d_i = X"FD" or
                   d_i = X"F9" or
                   d_i = X"E1" or
                   d_i = X"F1") and (rdy_i = '1')) then 
               next_state <= s511;
            elsif ((d_i = X"38") and (rdy_i = '1')) then 
               next_state <= s2;
            elsif ((d_i = X"F8") and (rdy_i = '1')) then 
               next_state <= s5;
            elsif ((d_i = X"78") and (rdy_i = '1')) then 
               next_state <= s3;
            elsif ((d_i = X"85" or
                   d_i = X"95" or
                   d_i = X"8D" or
                   d_i = X"9D" or
                   d_i = X"99" or
                   d_i = X"81" or
                   d_i = X"91" or
                   d_i = X"11") and (rdy_i = '1')) then 
               next_state <= s177;
            elsif ((d_i = X"86" or
                   d_i = X"96" or
                   d_i = X"8E") and (rdy_i = '1')) then 
               next_state <= s177;
            elsif ((d_i = X"84" or
                   d_i = X"94" or
                   d_i = X"8C") and (rdy_i = '1')) then 
               next_state <= s177;
            elsif ((d_i = X"AA") and (rdy_i = '1')) then 
               next_state <= s4;
            elsif ((d_i = X"0A") and (rdy_i = '1')) then 
               next_state <= s404;
            elsif ((d_i = X"4A") and (rdy_i = '1')) then 
               next_state <= s556;
            elsif ((d_i = X"2A") and (rdy_i = '1')) then 
               next_state <= s557;
            elsif ((d_i = X"6A") and (rdy_i = '1')) then 
               next_state <= s579;
            elsif ((d_i = X"A8") and (rdy_i = '1')) then 
               next_state <= s4;
            elsif ((d_i = X"98") and (rdy_i = '1')) then 
               next_state <= s4;
            elsif ((d_i = X"BA") and (rdy_i = '1')) then 
               next_state <= s4;
            elsif ((d_i = X"8A") and (rdy_i = '1')) then 
               next_state <= s4;
            elsif ((d_i = X"9A") and (rdy_i = '1')) then 
               next_state <= s4;
            elsif (rdy_i = '1') then 
               next_state <= s1;
            else
               next_state <= FETCH;
            end if;
         when s1 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= s1;
            end if;
         when s2 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= s2;
            end if;
         when s5 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= s5;
            end if;
         when s3 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= s3;
            end if;
         when s4 => 
            if (rdy_i = '1' and
                zw_REG_OP = X"9A") then 
               next_state <= FETCH;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"BA") then 
               next_state <= FETCH;
            elsif (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= s4;
            end if;
         when s12 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= s12;
            end if;
         when s16 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= s16;
            end if;
         when s17 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= s17;
            end if;
         when s24 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= s24;
            end if;
         when s25 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= s25;
            end if;
         when s271 => 
            if (rdy_i = '1' and
                zw_REG_OP = X"4C") then 
               next_state <= s307;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"6C") then 
               next_state <= s273;
            else
               next_state <= s271;
            end if;
         when s273 => 
            if (rdy_i = '1') then 
               next_state <= s304;
            else
               next_state <= s273;
            end if;
         when s304 => 
            if (rdy_i = '1') then 
               next_state <= s307;
            else
               next_state <= s304;
            end if;
         when s307 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= s307;
            end if;
         when s177 => 
            if (rdy_i = '1' and
                (zw_REG_OP = X"85" OR
                zw_REG_OP = X"86" OR
                zw_REG_OP = X"84")) then 
               next_state <= s184;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"95" OR
                   zw_REG_OP = X"94")) then 
               next_state <= s185;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"8D" OR
                   zw_REG_OP = X"8E" OR
                   zw_REG_OP = X"8C")) then 
               next_state <= s183;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"9D") then 
               next_state <= s182;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"99") then 
               next_state <= s180;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"91") then 
               next_state <= s181;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"81") then 
               next_state <= s186;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"96") then 
               next_state <= s185;
            else
               next_state <= s177;
            end if;
         when s180 => 
            if (rdy_i = '1') then 
               next_state <= s191;
            else
               next_state <= s180;
            end if;
         when s181 => 
            if (rdy_i = '1') then 
               next_state <= s189;
            else
               next_state <= s181;
            end if;
         when s182 => 
            if (rdy_i = '1') then 
               next_state <= s191;
            else
               next_state <= s182;
            end if;
         when s183 => 
            if (rdy_i = '1') then 
               next_state <= s187;
            else
               next_state <= s183;
            end if;
         when s184 => 
            next_state <= FETCH;
         when s185 => 
            if (rdy_i = '1') then 
               next_state <= s190;
            else
               next_state <= s185;
            end if;
         when s186 => 
            if (rdy_i = '1') then 
               next_state <= s188;
            else
               next_state <= s186;
            end if;
         when s187 => 
            next_state <= FETCH;
         when s188 => 
            if (rdy_i = '1') then 
               next_state <= s192;
            else
               next_state <= s188;
            end if;
         when s189 => 
            if (rdy_i = '1') then 
               next_state <= s191;
            else
               next_state <= s189;
            end if;
         when s190 => 
            next_state <= FETCH;
         when s191 => 
            next_state <= s193;
         when s192 => 
            next_state <= s193;
         when s193 => 
            next_state <= FETCH;
         when s377 => 
            if (rdy_i = '1') then 
               next_state <= s381;
            else
               next_state <= s377;
            end if;
         when s381 => 
            next_state <= FETCH;
         when s378 => 
            if (rdy_i = '1') then 
               next_state <= s382;
            else
               next_state <= s378;
            end if;
         when s382 => 
            next_state <= FETCH;
         when s379 => 
            if (rdy_i = '1') then 
               next_state <= s383;
            else
               next_state <= s379;
            end if;
         when s383 => 
            if (rdy_i = '1') then 
               next_state <= s384;
            else
               next_state <= s383;
            end if;
         when s384 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= s384;
            end if;
         when s380 => 
            if (rdy_i = '1') then 
               next_state <= s385;
            else
               next_state <= s380;
            end if;
         when s385 => 
            if (rdy_i = '1') then 
               next_state <= s386;
            else
               next_state <= s385;
            end if;
         when s386 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= s386;
            end if;
         when s387 => 
            if (rdy_i = '1') then 
               next_state <= s388;
            else
               next_state <= s387;
            end if;
         when s388 => 
            if (rdy_i = '1') then 
               next_state <= s389;
            else
               next_state <= s388;
            end if;
         when s389 => 
            if (rdy_i = '1') then 
               next_state <= s391;
            else
               next_state <= s389;
            end if;
         when s391 => 
            if (rdy_i = '1') then 
               next_state <= s392;
            else
               next_state <= s391;
            end if;
         when s392 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= s392;
            end if;
         when s390 => 
            if (rdy_i = '1') then 
               next_state <= s393;
            else
               next_state <= s390;
            end if;
         when s393 => 
            if (rdy_i = '1') then 
               next_state <= s394;
            else
               next_state <= s393;
            end if;
         when s394 => 
            if (rdy_i = '1') then 
               next_state <= s395;
            else
               next_state <= s394;
            end if;
         when s395 => 
            if (rdy_i = '1') then 
               next_state <= s396;
            else
               next_state <= s395;
            end if;
         when s396 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= s396;
            end if;
         when s397 => 
            if (rdy_i = '1') then 
               next_state <= s398;
            else
               next_state <= s397;
            end if;
         when s398 => 
            if (rdy_i = '1') then 
               next_state <= s399;
            else
               next_state <= s398;
            end if;
         when s399 => 
            next_state <= s400;
         when s400 => 
            next_state <= s401;
         when s401 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= s401;
            end if;
         when s526 => 
            if (rdy_i = '1') then 
               next_state <= s527;
            else
               next_state <= s526;
            end if;
         when s527 => 
            next_state <= s528;
         when s528 => 
            next_state <= s529;
         when s529 => 
            next_state <= s531;
         when s530 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= s530;
            end if;
         when s531 => 
            if (rdy_i = '1') then 
               next_state <= s530;
            else
               next_state <= s531;
            end if;
         when s544 => 
            next_state <= s550;
         when s545 => 
            next_state <= s546;
         when s546 => 
            next_state <= s547;
         when s547 => 
            if (rdy_i = '1') then 
               next_state <= s549;
            else
               next_state <= s547;
            end if;
         when s549 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= s549;
            end if;
         when s550 => 
            next_state <= s545;
         when s404 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= s404;
            end if;
         when s556 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= s556;
            end if;
         when s557 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= s557;
            end if;
         when s579 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= s579;
            end if;
         when s201 => 
            if (rdy_i = '1' and
                (zw_REG_OP = X"A5" OR zw_REG_OP = X"A6" OR
                zw_REG_OP = X"A4" OR zw_REG_OP = X"45" OR
                zw_REG_OP = X"05" OR zw_REG_OP = X"25" OR
                zw_REG_OP = X"C5" OR zw_REG_OP = X"E4" OR zw_REG_OP = X"C4")) then 
               next_state <= s224;
            elsif ((rdy_i = '1' and
                   (zw_REG_OP = X"A9" OR zw_REG_OP = X"A2" OR zw_REG_OP = X"A0" OR zw_REG_OP = X"E0" OR zw_REG_OP = X"C0" OR
                   zw_REG_OP = X"49" or zw_REG_OP = X"09" or zw_REG_OP = X"29" or zw_REG_OP = X"C9")) and (zw_REG_OP = X"09" or zw_REG_OP = X"05" or
                   zw_REG_OP = X"15" or zw_REG_OP = X"0D" or
                   zw_REG_OP = X"1D" or zw_REG_OP = X"19" or 
                   zw_REG_OP = X"01" or zw_REG_OP = X"11")) then 
               next_state <= FETCH;
            elsif ((rdy_i = '1' and
                   (zw_REG_OP = X"A9" OR zw_REG_OP = X"A2" OR zw_REG_OP = X"A0" OR zw_REG_OP = X"E0" OR zw_REG_OP = X"C0" OR
                   zw_REG_OP = X"49" or zw_REG_OP = X"09" or zw_REG_OP = X"29" or zw_REG_OP = X"C9")) and (zw_REG_OP = X"49" or zw_REG_OP = X"45" or
                   zw_REG_OP = X"55" or zw_REG_OP = X"4D" or
                   zw_REG_OP = X"5D" or zw_REG_OP = X"59" or
                   zw_REG_OP = X"41" or zw_REG_OP = X"51")) then 
               next_state <= FETCH;
            elsif ((rdy_i = '1' and
                   (zw_REG_OP = X"A9" OR zw_REG_OP = X"A2" OR zw_REG_OP = X"A0" OR zw_REG_OP = X"E0" OR zw_REG_OP = X"C0" OR
                   zw_REG_OP = X"49" or zw_REG_OP = X"09" or zw_REG_OP = X"29" or zw_REG_OP = X"C9")) and (zw_REG_OP = X"29" or zw_REG_OP = X"25" or
                   zw_REG_OP = X"35" or zw_REG_OP = X"2D" or
                   zw_REG_OP = X"3D" or zw_REG_OP = X"39" or
                    zw_REG_OP = X"21" or zw_REG_OP = X"31")) then 
               next_state <= FETCH;
            elsif ((rdy_i = '1' and
                   (zw_REG_OP = X"A9" OR zw_REG_OP = X"A2" OR zw_REG_OP = X"A0" OR zw_REG_OP = X"E0" OR zw_REG_OP = X"C0" OR
                   zw_REG_OP = X"49" or zw_REG_OP = X"09" or zw_REG_OP = X"29" or zw_REG_OP = X"C9")) and (zw_REG_OP = X"C9" or zw_REG_OP = X"C5" or
                   zw_REG_OP = X"D5" or zw_REG_OP = X"CD" or
                   zw_REG_OP = X"DD" or zw_REG_OP = X"D9" or
                   zw_REG_OP = X"C1" or zw_REG_OP = X"D1" or
                    zw_REG_OP = X"C0" or zw_REG_OP = X"E0" or
                    zw_REG_OP = X"C4" or zw_REG_OP = X"E4" or
                    zw_REG_OP = X"CC" or zw_REG_OP = X"EC")) then 
               next_state <= FETCH;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"A9" OR zw_REG_OP = X"A2" OR zw_REG_OP = X"A0" OR zw_REG_OP = X"E0" OR zw_REG_OP = X"C0" OR
                   zw_REG_OP = X"49" or zw_REG_OP = X"09" or zw_REG_OP = X"29" or zw_REG_OP = X"C9")) then 
               next_state <= FETCH;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"B5" OR
                   zw_REG_OP = X"B4" OR
                   zw_REG_OP = X"55" OR zw_REG_OP = X"15" OR
                   zw_REG_OP = X"35" OR
                   zw_REG_OP = X"D5")) then 
               next_state <= s217;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"AD" OR
                   zw_REG_OP = X"AE" OR
                   zw_REG_OP = X"AC" OR
                   zw_REG_OP = X"4D" OR
                   zw_REG_OP = X"0D" OR
                   zw_REG_OP = X"2D" OR
                   zw_REG_OP = X"CD" OR
                   zw_REG_OP = X"EC" OR
                   zw_REG_OP = X"CC")) then 
               next_state <= s202;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"BD" OR
                   zw_REG_OP = X"BC" OR
                   zw_REG_OP = X"5D" OR
                   zw_REG_OP = X"1D" OR
                   zw_REG_OP = X"3D" OR
                   zw_REG_OP = X"DD")) then 
               next_state <= s210;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"B9" OR
                   zw_REG_OP = X"BE" OR
                   zw_REG_OP = X"59" OR
                   zw_REG_OP = X"19" OR
                   zw_REG_OP = X"39" OR
                   zw_REG_OP = X"D9")) then 
               next_state <= s211;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"B1" OR
                   zw_REG_OP = X"51" OR
                   zw_REG_OP = X"11" OR
                   zw_REG_OP = X"31" OR
                   zw_REG_OP = X"D1")) then 
               next_state <= s215;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"A1" OR
                   zw_REG_OP = X"41" OR
                   zw_REG_OP = X"01" OR
                   zw_REG_OP = X"21" OR
                   zw_REG_OP = X"C1")) then 
               next_state <= s218;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"B6") then 
               next_state <= s217;
            else
               next_state <= s201;
            end if;
         when s202 => 
            if (rdy_i = '1') then 
               next_state <= s224;
            else
               next_state <= s202;
            end if;
         when s210 => 
            if (rdy_i = '1') then 
               next_state <= s225;
            else
               next_state <= s210;
            end if;
         when s211 => 
            if (rdy_i = '1') then 
               next_state <= s225;
            else
               next_state <= s211;
            end if;
         when s215 => 
            if (rdy_i = '1') then 
               next_state <= s223;
            else
               next_state <= s215;
            end if;
         when s217 => 
            if (rdy_i = '1') then 
               next_state <= s224;
            else
               next_state <= s217;
            end if;
         when s218 => 
            if (rdy_i = '1') then 
               next_state <= s222;
            else
               next_state <= s218;
            end if;
         when s222 => 
            if (rdy_i = '1') then 
               next_state <= s202;
            else
               next_state <= s222;
            end if;
         when s223 => 
            if (rdy_i = '1') then 
               next_state <= s225;
            else
               next_state <= s223;
            end if;
         when s224 => 
            if ((rdy_i = '1') and (zw_REG_OP = X"09" or zw_REG_OP = X"05" or
                zw_REG_OP = X"15" or zw_REG_OP = X"0D" or
                zw_REG_OP = X"1D" or zw_REG_OP = X"19" or 
                zw_REG_OP = X"01" or zw_REG_OP = X"11")) then 
               next_state <= FETCH;
            elsif ((rdy_i = '1') and (zw_REG_OP = X"49" or zw_REG_OP = X"45" or
                   zw_REG_OP = X"55" or zw_REG_OP = X"4D" or
                   zw_REG_OP = X"5D" or zw_REG_OP = X"59" or
                   zw_REG_OP = X"41" or zw_REG_OP = X"51")) then 
               next_state <= FETCH;
            elsif ((rdy_i = '1') and (zw_REG_OP = X"29" or zw_REG_OP = X"25" or
                   zw_REG_OP = X"35" or zw_REG_OP = X"2D" or
                   zw_REG_OP = X"3D" or zw_REG_OP = X"39" or
                    zw_REG_OP = X"21" or zw_REG_OP = X"31")) then 
               next_state <= FETCH;
            elsif ((rdy_i = '1') and (zw_REG_OP = X"C9" or zw_REG_OP = X"C5" or
                   zw_REG_OP = X"D5" or zw_REG_OP = X"CD" or
                   zw_REG_OP = X"DD" or zw_REG_OP = X"D9" or
                   zw_REG_OP = X"C1" or zw_REG_OP = X"D1" or
                    zw_REG_OP = X"C0" or zw_REG_OP = X"E0" or
                    zw_REG_OP = X"C4" or zw_REG_OP = X"E4" or
                    zw_REG_OP = X"CC" or zw_REG_OP = X"EC")) then 
               next_state <= FETCH;
            elsif (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= s224;
            end if;
         when s225 => 
            if ((rdy_i = '1' AND
                zw_b2(0) = '0') and (zw_REG_OP = X"09" or zw_REG_OP = X"05" or
                zw_REG_OP = X"15" or zw_REG_OP = X"0D" or
                zw_REG_OP = X"1D" or zw_REG_OP = X"19" or 
                zw_REG_OP = X"01" or zw_REG_OP = X"11")) then 
               next_state <= FETCH;
            elsif ((rdy_i = '1' AND
                   zw_b2(0) = '0') and (zw_REG_OP = X"49" or zw_REG_OP = X"45" or
                   zw_REG_OP = X"55" or zw_REG_OP = X"4D" or
                   zw_REG_OP = X"5D" or zw_REG_OP = X"59" or
                   zw_REG_OP = X"41" or zw_REG_OP = X"51")) then 
               next_state <= FETCH;
            elsif ((rdy_i = '1' AND
                   zw_b2(0) = '0') and (zw_REG_OP = X"29" or zw_REG_OP = X"25" or
                   zw_REG_OP = X"35" or zw_REG_OP = X"2D" or
                   zw_REG_OP = X"3D" or zw_REG_OP = X"39" or
                    zw_REG_OP = X"21" or zw_REG_OP = X"31")) then 
               next_state <= FETCH;
            elsif ((rdy_i = '1' AND
                   zw_b2(0) = '0') and (zw_REG_OP = X"C9" or zw_REG_OP = X"C5" or
                   zw_REG_OP = X"D5" or zw_REG_OP = X"CD" or
                   zw_REG_OP = X"DD" or zw_REG_OP = X"D9" or
                   zw_REG_OP = X"C1" or zw_REG_OP = X"D1" or
                    zw_REG_OP = X"C0" or zw_REG_OP = X"E0" or
                    zw_REG_OP = X"C4" or zw_REG_OP = X"E4" or
                    zw_REG_OP = X"CC" or zw_REG_OP = X"EC")) then 
               next_state <= FETCH;
            elsif (rdy_i = '1' AND
                   zw_b2(0) = '0') then 
               next_state <= FETCH;
            elsif (rdy_i = '1') then 
               next_state <= s224;
            else
               next_state <= s225;
            end if;
         when s226 => 
            if (rdy_i = '1' and
                (zw_REG_OP = X"C6" OR
                zw_REG_OP = X"E6")) then 
               next_state <= s343;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"D6" OR
                   zw_REG_OP = X"F6")) then 
               next_state <= s247;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"CE" OR
                   zw_REG_OP = X"EE")) then 
               next_state <= s243;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"DE" OR
                   zw_REG_OP = X"FE")) then 
               next_state <= s244;
            else
               next_state <= s226;
            end if;
         when s243 => 
            if (rdy_i = '1') then 
               next_state <= s343;
            else
               next_state <= s243;
            end if;
         when s244 => 
            if (rdy_i = '1') then 
               next_state <= s344;
            else
               next_state <= s244;
            end if;
         when s247 => 
            if (rdy_i = '1') then 
               next_state <= s343;
            else
               next_state <= s247;
            end if;
         when s344 => 
            if (rdy_i = '1') then 
               next_state <= s343;
            else
               next_state <= s344;
            end if;
         when s343 => 
            if (rdy_i = '1') then 
               next_state <= s250;
            else
               next_state <= s343;
            end if;
         when s250 => 
            if (rdy_i = '1') then 
               next_state <= s251;
            else
               next_state <= s250;
            end if;
         when s251 => 
            next_state <= FETCH;
         when s351 => 
            if (rdy_i = '1' and
                zw_REG_OP = X"24") then 
               next_state <= s361;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"2C") then 
               next_state <= s360;
            else
               next_state <= s351;
            end if;
         when s361 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= s361;
            end if;
         when s360 => 
            if (rdy_i = '1') then 
               next_state <= s361;
            else
               next_state <= s360;
            end if;
         when s403 => 
            if (rdy_i = '1' and
                (zw_REG_OP = X"1E" or
                zw_REG_OP = X"7E" or
                zw_REG_OP = X"3E" or
                zw_REG_OP = X"5E")) then 
               next_state <= s407;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"06" or
                   zw_REG_OP = X"66" or
                   zw_REG_OP = X"26" or
                   zw_REG_OP = X"46")) then 
               next_state <= s413;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"16" or
                   zw_REG_OP = X"76" or
                   zw_REG_OP = X"36" or
                   zw_REG_OP = X"56")) then 
               next_state <= s409;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"0E" or
                   zw_REG_OP = X"6E" or
                   zw_REG_OP = X"2E" or
                   zw_REG_OP = X"4E")) then 
               next_state <= s406;
            else
               next_state <= s403;
            end if;
         when s406 => 
            if (rdy_i = '1') then 
               next_state <= s413;
            else
               next_state <= s406;
            end if;
         when s407 => 
            if (rdy_i = '1') then 
               next_state <= s412;
            else
               next_state <= s407;
            end if;
         when s409 => 
            if (rdy_i = '1') then 
               next_state <= s413;
            else
               next_state <= s409;
            end if;
         when s412 => 
            if (rdy_i = '1') then 
               next_state <= s413;
            else
               next_state <= s412;
            end if;
         when s413 => 
            if (rdy_i = '1') then 
               next_state <= s416;
            else
               next_state <= s413;
            end if;
         when s416 => 
            if (rdy_i = '1' and
                (zw_REG_OP = X"06" or
                zw_REG_OP = X"16" or
                zw_REG_OP = X"0E" or
                zw_REG_OP = X"1E")) then 
               next_state <= s418;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"46" or
                   zw_REG_OP = X"56" or
                   zw_REG_OP = X"4E" or
                   zw_REG_OP = X"5E")) then 
               next_state <= s418;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"26" or
                   zw_REG_OP = X"36" or
                   zw_REG_OP = X"2E" or
                   zw_REG_OP = X"3E")) then 
               next_state <= s418;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"66" or
                   zw_REG_OP = X"76" or
                   zw_REG_OP = X"6E" or
                   zw_REG_OP = X"7E")) then 
               next_state <= s418;
            else
               next_state <= s416;
            end if;
         when s418 => 
            next_state <= FETCH;
         when s510 => 
            if (rdy_i = '1' and
                zw_REG_OP = X"65") then 
               next_state <= s565;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"69" and
                   reg_F(3) = '0') then 
               next_state <= FETCH;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"75") then 
               next_state <= s560;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"6D") then 
               next_state <= s553;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"7D") then 
               next_state <= s555;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"79") then 
               next_state <= s555;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"71") then 
               next_state <= s558;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"61") then 
               next_state <= s561;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"69" and
                   reg_F(3) = '1') then 
               next_state <= FETCH;
            else
               next_state <= s510;
            end if;
         when s553 => 
            if (rdy_i = '1') then 
               next_state <= s565;
            else
               next_state <= s553;
            end if;
         when s555 => 
            if (rdy_i = '1') then 
               next_state <= s564;
            else
               next_state <= s555;
            end if;
         when s558 => 
            if (rdy_i = '1') then 
               next_state <= s566;
            else
               next_state <= s558;
            end if;
         when s560 => 
            if (rdy_i = '1') then 
               next_state <= s565;
            else
               next_state <= s560;
            end if;
         when s561 => 
            if (rdy_i = '1') then 
               next_state <= s563;
            else
               next_state <= s561;
            end if;
         when s563 => 
            if (rdy_i = '1') then 
               next_state <= s553;
            else
               next_state <= s563;
            end if;
         when s564 => 
            if (rdy_i = '1' AND
                zw_b2(0) = '0' and
                reg_F(3) = '0') then 
               next_state <= FETCH;
            elsif (rdy_i = '1' AND
                   zw_b2(0) = '0' and
                   reg_F(3) = '1') then 
               next_state <= FETCH;
            elsif (rdy_i = '1') then 
               next_state <= s565;
            else
               next_state <= s564;
            end if;
         when s565 => 
            if (rdy_i = '1' and
                reg_F(3) = '0') then 
               next_state <= FETCH;
            elsif (rdy_i = '1' and
                   reg_F(3) = '1') then 
               next_state <= FETCH;
            else
               next_state <= s565;
            end if;
         when s566 => 
            if (rdy_i = '1') then 
               next_state <= s564;
            else
               next_state <= s566;
            end if;
         when s266 => 
            if (rdy_i = '1' and (
                (reg_F(0) = '1' and zw_REG_OP = X"90") or
                (reg_F(0) = '0' and zw_REG_OP = X"B0") or
                (reg_F(1) = '0' and zw_REG_OP = X"F0") or
                (reg_F(7) = '0' and zw_REG_OP = X"30") or
                (reg_F(1) = '1' and zw_REG_OP = X"D0") or
                (reg_F(7) = '1' and zw_REG_OP = X"10") or
                (reg_F(6) = '1' and zw_REG_OP = X"50") or
                (reg_F(6) = '0' and zw_REG_OP = X"70"))) then 
               next_state <= FETCH;
            elsif (rdy_i = '1') then 
               next_state <= s301;
            else
               next_state <= s266;
            end if;
         when s301 => 
            if (rdy_i = '1' and
                zw_b3 = adr_nxt_pc_i (15 downto 8)) then 
               next_state <= FETCH;
            elsif (rdy_i = '1') then 
               next_state <= s302;
            else
               next_state <= s301;
            end if;
         when s302 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= s302;
            end if;
         when RES => 
            next_state <= s544;
         when s511 => 
            if (rdy_i = '1' and
                zw_REG_OP = X"E5") then 
               next_state <= s574;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"E9" and
                   reg_F(3) = '0') then 
               next_state <= FETCH;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"F5") then 
               next_state <= s569;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"ED") then 
               next_state <= s559;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"FD") then 
               next_state <= s562;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"F9") then 
               next_state <= s567;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"F1") then 
               next_state <= s568;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"E1") then 
               next_state <= s570;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"E9" and
                   reg_F(3) = '1') then 
               next_state <= FETCH;
            else
               next_state <= s511;
            end if;
         when s559 => 
            if (rdy_i = '1') then 
               next_state <= s574;
            else
               next_state <= s559;
            end if;
         when s562 => 
            if (rdy_i = '1') then 
               next_state <= s573;
            else
               next_state <= s562;
            end if;
         when s567 => 
            if (rdy_i = '1') then 
               next_state <= s573;
            else
               next_state <= s567;
            end if;
         when s568 => 
            if (rdy_i = '1') then 
               next_state <= s571;
            else
               next_state <= s568;
            end if;
         when s569 => 
            if (rdy_i = '1') then 
               next_state <= s574;
            else
               next_state <= s569;
            end if;
         when s570 => 
            if (rdy_i = '1') then 
               next_state <= s572;
            else
               next_state <= s570;
            end if;
         when s571 => 
            if (rdy_i = '1') then 
               next_state <= s573;
            else
               next_state <= s571;
            end if;
         when s572 => 
            if (rdy_i = '1') then 
               next_state <= s559;
            else
               next_state <= s572;
            end if;
         when s573 => 
            if (rdy_i = '1' AND
                zw_b2(0) = '0' and
                reg_F(3) = '0') then 
               next_state <= FETCH;
            elsif (rdy_i = '1' AND
                   zw_b2(0) = '0' and
                   reg_F(3) = '1') then 
               next_state <= FETCH;
            elsif (rdy_i = '1') then 
               next_state <= s574;
            else
               next_state <= s573;
            end if;
         when s574 => 
            if (rdy_i = '1' and
                reg_F(3) = '0') then 
               next_state <= FETCH;
            elsif (rdy_i = '1' and
                   reg_F(3) = '1') then 
               next_state <= FETCH;
            else
               next_state <= s574;
            end if;
         when s548 => 
            if (rdy_i = '1') then 
               next_state <= s551;
            else
               next_state <= s548;
            end if;
         when s551 => 
            next_state <= s552;
         when s552 => 
            next_state <= s576;
         when s575 => 
            if (rdy_i = '1') then 
               next_state <= s577;
            else
               next_state <= s575;
            end if;
         when s576 => 
            next_state <= s575;
         when s577 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= s577;
            end if;
         when s532 => 
            if (rdy_i = '1') then 
               next_state <= s533;
            else
               next_state <= s532;
            end if;
         when s533 => 
            next_state <= s534;
         when s534 => 
            next_state <= s536;
         when s535 => 
            if (rdy_i = '1') then 
               next_state <= s537;
            else
               next_state <= s535;
            end if;
         when s536 => 
            next_state <= s535;
         when s537 => 
            if (rdy_i = '1') then 
               next_state <= FETCH;
            else
               next_state <= s537;
            end if;
         when others =>
            next_state <= RES;
      end case;
   end process nextstate_proc;
 
   -----------------------------------------------------------------
   output_proc : process ( 
      adr_nxt_pc_i,
      adr_pc_i,
      adr_sp_i,
      current_state,
      d_alu_i,
      d_i,
      d_regs_out_i,
      irq_n_i,
      nmi_i,
      q_a_i,
      q_x_i,
      q_y_i,
      rdy_i,
      reg_F,
      sig_PC,
      zw_ALU,
      zw_ALU1,
      zw_ALU2,
      zw_ALU3,
      zw_ALU4,
      zw_ALU5,
      zw_ALU6,
      zw_REG_OP,
      zw_b1,
      zw_b2,
      zw_b3,
      zw_b4,
      zw_w1
   )
   -----------------------------------------------------------------
   begin
      -- Default Assignment
      a_o <= sig_PC;
      adr_o <= X"0000";
      ch_a_o <= X"00";
      ch_b_o <= X"00";
      d_regs_in_o <= X"00";
      fetch_o <= '0';
      ld_o <= "00";
      ld_pc_o <= '0';
      ld_sp_o <= '0';
      load_regs_o <= '0';
      offset_o <= X"0000";
      reg_0flag_o <= reg_F(0);
      reg_1flag_o <= reg_F(1);
      reg_3flag_o <= reg_F(3);
      reg_7flag_o <= reg_F(7);
      -- Default Assignment To Internals
      sig_D_OUT <= X"00";
      sig_RD <= '0';
      sig_RWn <= '1';
      sig_SYNC <= '0';
      sig_WR <= '0';
      zw_ALU <= '0' & X"00";
      zw_ALU1 <= '0' & X"00";
      zw_ALU2 <= '0' & X"00";
      zw_ALU3 <= '0' & X"00";
      zw_ALU4 <= '0' & X"00";
      zw_ALU5 <= '0' & X"00";
      zw_ALU6 <= '0' & X"00";

      -- Combined Actions
      case current_state is
         when FETCH => 
            sig_RWn <= '1';
            sig_RD <= '1';
            sig_SYNC <= NOT (rdy_i);
            if ((nmi_i = '1') and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((irq_n_i = '0' and
                   reg_F(2) = '0') and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"69" or
                   d_i = X"65" or
                   d_i = X"75" or
                   d_i = X"6D" or
                   d_i = X"7D" or
                   d_i = X"79" or
                   d_i = X"61" or
                   d_i = X"71") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"06" or
                   d_i = X"16" or
                   d_i = X"0E" or
                   d_i = X"1E") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"90" or
                   d_i = X"B0" or
                   d_i = X"F0" or
                   d_i = X"30" or
                   d_i = X"D0" or
                   d_i = X"10" or
                   d_i = X"50" or
                   d_i = X"70") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"24" or
                   d_i = X"2C") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"00") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"18") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"D8") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"58") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"B8") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"E0" or
                   d_i = X"E4" or
                   d_i = X"EC") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"C0" or
                   d_i = X"C4" or
                   d_i = X"CC") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"C6" or
                   d_i = X"D6" or
                   d_i = X"CE" or
                   d_i = X"DE") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"CA") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"88") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"49" or
                   d_i = X"45" or
                   d_i = X"55" or
                   d_i = X"4D" or
                   d_i = X"5D" or
                   d_i = X"59" or
                   d_i = X"41" or
                   d_i = X"51" or
                   d_i = X"09" or
                   d_i = X"05" or
                   d_i = X"15" or
                   d_i = X"0D" or
                   d_i = X"1D" or
                   d_i = X"19" or
                   d_i = X"01" or
                   d_i = X"11" or
                   d_i = X"29" or
                   d_i = X"25" or
                   d_i = X"35" or
                   d_i = X"2D" or
                   d_i = X"3D" or
                   d_i = X"39" or
                   d_i = X"21" or
                   d_i = X"31" or
                   d_i = X"C9" or
                   d_i = X"C5" or
                   d_i = X"D5" or
                   d_i = X"CD" or
                   d_i = X"DD" or
                   d_i = X"D9" or
                   d_i = X"C1" or
                   d_i = X"D1") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"E6" or
                   d_i = X"F6" or
                   d_i = X"EE" or
                   d_i = X"FE") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"E8") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"C8") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"4C" or
                   d_i = X"6C") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"20") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"A9" or
                   d_i = X"A5" or
                   d_i = X"B5" or
                   d_i = X"AD" or
                   d_i = X"BD" or
                   d_i = X"B9" or
                   d_i = X"A1" or
                   d_i = X"B1") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"A2" or
                   d_i = X"A6" or
                   d_i = X"B6" or
                   d_i = X"AE" or
                   d_i = X"BE") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"A0" or
                   d_i = X"A4" or
                   d_i = X"B4" or
                   d_i = X"AC" or
                   d_i = X"BC") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"46" or
                   d_i = X"56" or
                   d_i = X"4E" or
                   d_i = X"5E") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"EA") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"48") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"08") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"68") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"28") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"26" or
                   d_i = X"36" or
                   d_i = X"2E" or
                   d_i = X"3E") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"66" or
                   d_i = X"76" or
                   d_i = X"6E" or
                   d_i = X"7E") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"40") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"60") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"E9" or
                   d_i = X"E5" or
                   d_i = X"F5" or
                   d_i = X"ED" or
                   d_i = X"FD" or
                   d_i = X"F9" or
                   d_i = X"E1" or
                   d_i = X"F1") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"38") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"F8") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"78") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"85" or
                   d_i = X"95" or
                   d_i = X"8D" or
                   d_i = X"9D" or
                   d_i = X"99" or
                   d_i = X"81" or
                   d_i = X"91" or
                   d_i = X"11") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"86" or
                   d_i = X"96" or
                   d_i = X"8E") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"84" or
                   d_i = X"94" or
                   d_i = X"8C") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"AA") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"0A") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"4A") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"2A") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"6A") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"A8") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"98") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"BA") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"8A") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((d_i = X"9A") and (rdy_i = '1')) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif (rdy_i = '1') then 
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when s1 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when s2 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when s5 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when s3 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when s4 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1' and
                zw_REG_OP = X"9A") then 
               adr_o <= X"01" & d_regs_out_i;
               ld_o <= "11";
               ld_sp_o <= '1';
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"BA") then 
               d_regs_in_o <= adr_sp_i (7 downto 0);
               ch_a_o <= adr_sp_i (7 downto 0);
               ch_b_o <= X"00";
               load_regs_o <= '1';
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif (rdy_i = '1') then 
               ch_a_o <= d_regs_out_i;
               ch_b_o <= X"00";
               load_regs_o <= '1';
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when s12 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when s16 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when s17 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when s24 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when s25 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               d_regs_in_o <= d_alu_i;
               ch_a_o <= d_regs_out_i;
               ch_b_o <= zw_b4;
               load_regs_o <= '1';
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when s271 => 
            sig_RWn <= '1';
            sig_RD <= '1';
         when s273 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               adr_o <= d_i & zw_b1;
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when s304 => 
            sig_RWn <= '1';
            sig_RD <= '1';
         when s307 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               adr_o <= d_i & zw_b1;
               ld_o <= "11";
               ld_pc_o <= '1';
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when s177 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1' and
                (zw_REG_OP = X"85" OR
                zw_REG_OP = X"86" OR
                zw_REG_OP = X"84")) then 
               sig_RWn <= '0';
               sig_RD <= '0';
               sig_WR <= '1';
               sig_D_OUT <= d_regs_out_i;
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"95" OR
                   zw_REG_OP = X"94")) then 
               ch_a_o <=  d_i;
               ch_b_o <= q_x_i;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"8D" OR
                   zw_REG_OP = X"8E" OR
                   zw_REG_OP = X"8C")) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"9D") then 
               ld_o <= "11";
               ld_pc_o <= '1';
               ch_a_o <= d_i;
               ch_b_o <= q_x_i;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"99") then 
               ld_o <= "11";
               ld_pc_o <= '1';
               ch_a_o <= d_i;
               ch_b_o <= q_y_i;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"91") then 
               ch_a_o <= d_i;
               ch_b_o <= X"01";
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"81") then 
               ch_a_o <=  d_i;
               ch_b_o <= q_x_i;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"96") then 
               ch_a_o <=  d_i;
               ch_b_o <= q_y_i;
            end if;
         when s180 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ch_a_o <= d_i;
               ch_b_o <= "0000000" & zw_b2(0);
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when s181 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ch_a_o <= d_i;
               ch_b_o <= q_y_i;
            end if;
         when s182 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ch_a_o <= d_i;
               ch_b_o <= "0000000" & zw_b2(0);
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when s183 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               sig_RWn <= '0';
               sig_RD <= '0';
               sig_WR <= '1';
               sig_D_OUT <= d_regs_out_i;
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when s184 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            sig_SYNC <= '1';
            fetch_o <= '1';
         when s185 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               sig_RWn <= '0';
               sig_RD <= '0';
               sig_WR <= '1';
               sig_D_OUT <= d_regs_out_i;
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when s186 => 
            sig_RWn <= '1';
            sig_RD <= '1';
         when s187 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            sig_SYNC <= '1';
            fetch_o <= '1';
         when s188 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ch_a_o <=  zw_b1;
               ch_b_o <= X"01";
            end if;
         when s189 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ch_a_o <= d_i;
               ch_b_o <= "0000000" & zw_b2(0);
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when s190 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            sig_SYNC <= '1';
            fetch_o <= '1';
         when s191 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            sig_RWn <= '0';
            sig_RD <= '0';
            sig_WR <= '1';
            sig_D_OUT <= d_regs_out_i;
         when s192 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            sig_RWn <= '0';
            sig_RD <= '0';
            sig_WR <= '1';
            sig_D_OUT <= d_regs_out_i;
            ld_o <= "11";
            ld_pc_o <= '1';
         when s193 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            sig_SYNC <= '1';
            fetch_o <= '1';
         when s377 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               sig_RWn <= '0';
               sig_RD <= '0';
               sig_WR <= '1';
               sig_D_OUT <= q_a_i;
               ld_o <= "11";
               ld_sp_o <= '1';
            end if;
         when s381 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            sig_SYNC <= '1';
            fetch_o <= '1';
         when s378 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               sig_RWn <= '0';
               sig_RD <= '0';
               sig_WR <= '1';
               sig_D_OUT <= reg_F;
               ld_o <= "11";
               ld_sp_o <= '1';
            end if;
         when s382 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            sig_SYNC <= '1';
            fetch_o <= '1';
         when s379 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_sp_o <= '1';
            end if;
         when s383 => 
            sig_RWn <= '1';
            sig_RD <= '1';
         when s384 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               d_regs_in_o <= d_i;
               load_regs_o <= '1';
               ch_a_o <= d_i;
               ch_b_o <= X"00";
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when s380 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_sp_o <= '1';
            end if;
         when s385 => 
            sig_RWn <= '1';
            sig_RD <= '1';
         when s386 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when s387 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_sp_o <= '1';
            end if;
         when s388 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_sp_o <= '1';
            end if;
         when s389 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_sp_o <= '1';
            end if;
         when s391 => 
            sig_RWn <= '1';
            sig_RD <= '1';
         when s392 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               adr_o <= d_i & zw_b1;
               ld_o <= "11";
               ld_pc_o <= '1';
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when s390 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_sp_o <= '1';
            end if;
         when s393 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_sp_o <= '1';
            end if;
         when s394 => 
            sig_RWn <= '1';
            sig_RD <= '1';
         when s395 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               adr_o <= d_i & zw_b1;
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when s396 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when s397 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_sp_o <= '1';
               ld_pc_o <= '1';
            end if;
         when s398 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               sig_RWn <= '0';
               sig_RD <= '0';
               sig_WR <= '1';
               sig_D_OUT <= adr_pc_i (15 downto 8);
            end if;
         when s399 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            ld_o <= "11";
            ld_sp_o <= '1';
            sig_RWn <= '0';
            sig_RD <= '0';
            sig_WR <= '1';
            sig_D_OUT <= adr_pc_i (7 downto 0);
         when s400 => 
            sig_RWn <= '1';
            sig_RD <= '1';
         when s401 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               adr_o <= d_i & zw_b1;
               ld_o <= "11";
               ld_pc_o <= '1';
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when s526 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_sp_o <= '1';
               ld_pc_o <= '1';
               sig_RWn <= '0';
               sig_RD <= '0';
               sig_WR <= '1';
               sig_D_OUT <= adr_pc_i (15 downto 8);
            end if;
         when s527 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            ld_o <= "11";
            ld_sp_o <= '1';
            sig_RWn <= '0';
            sig_RD <= '0';
            sig_WR <= '1';
            sig_D_OUT <= adr_pc_i (7 downto 0);
         when s528 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            ld_o <= "11";
            ld_sp_o <= '1';
            sig_RWn <= '0';
            sig_RD <= '0';
            sig_WR <= '1';
            sig_D_OUT <= reg_F OR X"10";
         when s529 => 
            sig_RWn <= '1';
            sig_RD <= '1';
         when s530 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               adr_o <= d_i & zw_b1;
               ld_o <= "11";
               ld_pc_o <= '1';
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when s531 => 
            sig_RWn <= '1';
            sig_RD <= '1';
         when s544 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            ld_o <= "11";
            ld_sp_o <= '1';
         when s545 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            adr_o <= X"FFFB";
            ld_o <= "11";
            ld_pc_o <= '1';
         when s546 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            ld_o <= "11";
            ld_pc_o <= '1';
         when s547 => 
            sig_RWn <= '1';
            sig_RD <= '1';
         when s549 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               adr_o <= d_i & zw_w1 (7 downto 0);
               ld_o <= "11";
               ld_pc_o <= '1';
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when s550 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            ld_o <= "11";
            ld_sp_o <= '1';
         when s404 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ch_a_o <= q_a_i (6 downto 0) & '0';
               ch_b_o <= X"00";
               d_regs_in_o <= q_a_i (6 downto 0) & '0';
               load_regs_o <= '1';
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when s556 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ch_a_o <= '0' & q_a_i (7 downto 1);
               ch_b_o <= X"00";
               d_regs_in_o <= '0' & q_a_i (7 downto 1);
               load_regs_o <= '1';
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when s557 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ch_a_o <= q_a_i (6 downto 0) & reg_F(0);
               ch_b_o <= X"00";
               d_regs_in_o <= q_a_i (6 downto 0) & reg_F(0);
               load_regs_o <= '1';
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when s579 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ch_a_o <= reg_F(0) & q_a_i (7 downto 1);
               ch_b_o <= X"00";
               d_regs_in_o <= reg_F(0) & q_a_i (7 downto 1);
               load_regs_o <= '1';
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when s201 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1' and
                (zw_REG_OP = X"A5" OR zw_REG_OP = X"A6" OR
                zw_REG_OP = X"A4" OR zw_REG_OP = X"45" OR
                zw_REG_OP = X"05" OR zw_REG_OP = X"25" OR
                zw_REG_OP = X"C5" OR zw_REG_OP = X"E4" OR zw_REG_OP = X"C4")) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif ((rdy_i = '1' and
                   (zw_REG_OP = X"A9" OR zw_REG_OP = X"A2" OR zw_REG_OP = X"A0" OR zw_REG_OP = X"E0" OR zw_REG_OP = X"C0" OR
                   zw_REG_OP = X"49" or zw_REG_OP = X"09" or zw_REG_OP = X"29" or zw_REG_OP = X"C9")) and (zw_REG_OP = X"09" or zw_REG_OP = X"05" or
                   zw_REG_OP = X"15" or zw_REG_OP = X"0D" or
                   zw_REG_OP = X"1D" or zw_REG_OP = X"19" or 
                   zw_REG_OP = X"01" or zw_REG_OP = X"11")) then 
               ld_o <= "11";
               ld_pc_o <= '1';
               d_regs_in_o <= d_i OR q_a_i;
               load_regs_o <= '1';
               ch_a_o <= d_i OR q_a_i;
               ch_b_o <= X"00";
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif ((rdy_i = '1' and
                   (zw_REG_OP = X"A9" OR zw_REG_OP = X"A2" OR zw_REG_OP = X"A0" OR zw_REG_OP = X"E0" OR zw_REG_OP = X"C0" OR
                   zw_REG_OP = X"49" or zw_REG_OP = X"09" or zw_REG_OP = X"29" or zw_REG_OP = X"C9")) and (zw_REG_OP = X"49" or zw_REG_OP = X"45" or
                   zw_REG_OP = X"55" or zw_REG_OP = X"4D" or
                   zw_REG_OP = X"5D" or zw_REG_OP = X"59" or
                   zw_REG_OP = X"41" or zw_REG_OP = X"51")) then 
               ld_o <= "11";
               ld_pc_o <= '1';
               d_regs_in_o <= d_i XOR q_a_i;
               load_regs_o <= '1';
               ch_a_o <= d_i XOR q_a_i;
               ch_b_o <= X"00";
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif ((rdy_i = '1' and
                   (zw_REG_OP = X"A9" OR zw_REG_OP = X"A2" OR zw_REG_OP = X"A0" OR zw_REG_OP = X"E0" OR zw_REG_OP = X"C0" OR
                   zw_REG_OP = X"49" or zw_REG_OP = X"09" or zw_REG_OP = X"29" or zw_REG_OP = X"C9")) and (zw_REG_OP = X"29" or zw_REG_OP = X"25" or
                   zw_REG_OP = X"35" or zw_REG_OP = X"2D" or
                   zw_REG_OP = X"3D" or zw_REG_OP = X"39" or
                    zw_REG_OP = X"21" or zw_REG_OP = X"31")) then 
               ld_o <= "11";
               ld_pc_o <= '1';
               d_regs_in_o <= d_i AND q_a_i;
               load_regs_o <= '1';
               ch_a_o <= d_i AND q_a_i;
               ch_b_o <= X"00";
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif ((rdy_i = '1' and
                   (zw_REG_OP = X"A9" OR zw_REG_OP = X"A2" OR zw_REG_OP = X"A0" OR zw_REG_OP = X"E0" OR zw_REG_OP = X"C0" OR
                   zw_REG_OP = X"49" or zw_REG_OP = X"09" or zw_REG_OP = X"29" or zw_REG_OP = X"C9")) and (zw_REG_OP = X"C9" or zw_REG_OP = X"C5" or
                   zw_REG_OP = X"D5" or zw_REG_OP = X"CD" or
                   zw_REG_OP = X"DD" or zw_REG_OP = X"D9" or
                   zw_REG_OP = X"C1" or zw_REG_OP = X"D1" or
                    zw_REG_OP = X"C0" or zw_REG_OP = X"E0" or
                    zw_REG_OP = X"C4" or zw_REG_OP = X"E4" or
                    zw_REG_OP = X"CC" or zw_REG_OP = X"EC")) then 
               ld_o <= "11";
               ld_pc_o <= '1';
               zw_ALU <= unsigned ('0' & d_regs_out_i) + unsigned ('0' & NOT (d_i)) + 1;
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"A9" OR zw_REG_OP = X"A2" OR zw_REG_OP = X"A0" OR zw_REG_OP = X"E0" OR zw_REG_OP = X"C0" OR
                   zw_REG_OP = X"49" or zw_REG_OP = X"09" or zw_REG_OP = X"29" or zw_REG_OP = X"C9")) then 
               ld_o <= "11";
               ld_pc_o <= '1';
               d_regs_in_o <= d_i;
               load_regs_o <= '1';
               ch_a_o <= d_i;
               ch_b_o <= X"00";
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"B5" OR
                   zw_REG_OP = X"B4" OR
                   zw_REG_OP = X"55" OR zw_REG_OP = X"15" OR
                   zw_REG_OP = X"35" OR
                   zw_REG_OP = X"D5")) then 
               ch_a_o <=  d_i;
               ch_b_o <= q_x_i;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"AD" OR
                   zw_REG_OP = X"AE" OR
                   zw_REG_OP = X"AC" OR
                   zw_REG_OP = X"4D" OR
                   zw_REG_OP = X"0D" OR
                   zw_REG_OP = X"2D" OR
                   zw_REG_OP = X"CD" OR
                   zw_REG_OP = X"EC" OR
                   zw_REG_OP = X"CC")) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"BD" OR
                   zw_REG_OP = X"BC" OR
                   zw_REG_OP = X"5D" OR
                   zw_REG_OP = X"1D" OR
                   zw_REG_OP = X"3D" OR
                   zw_REG_OP = X"DD")) then 
               ld_o <= "11";
               ld_pc_o <= '1';
               ch_a_o <= d_i;
               ch_b_o <= q_x_i;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"B9" OR
                   zw_REG_OP = X"BE" OR
                   zw_REG_OP = X"59" OR
                   zw_REG_OP = X"19" OR
                   zw_REG_OP = X"39" OR
                   zw_REG_OP = X"D9")) then 
               ld_o <= "11";
               ld_pc_o <= '1';
               ch_a_o <= d_i;
               ch_b_o <= q_y_i;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"B1" OR
                   zw_REG_OP = X"51" OR
                   zw_REG_OP = X"11" OR
                   zw_REG_OP = X"31" OR
                   zw_REG_OP = X"D1")) then 
               ch_a_o <= d_i;
               ch_b_o <= X"01";
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"A1" OR
                   zw_REG_OP = X"41" OR
                   zw_REG_OP = X"01" OR
                   zw_REG_OP = X"21" OR
                   zw_REG_OP = X"C1")) then 
               ch_a_o <=  d_i;
               ch_b_o <= q_x_i;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"B6") then 
               ch_a_o <=  d_i;
               ch_b_o <= q_y_i;
            end if;
         when s202 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when s210 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ch_a_o <= d_i;
               ch_b_o <= "0000000" & zw_b2(0);
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when s211 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ch_a_o <= d_i;
               ch_b_o <= "0000000" & zw_b2(0);
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when s215 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ch_a_o <= d_i;
               ch_b_o <= q_y_i;
            end if;
         when s217 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when s218 => 
            sig_RWn <= '1';
            sig_RD <= '1';
         when s222 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ch_a_o <=  zw_b1;
               ch_b_o <= X"01";
            end if;
         when s223 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ch_a_o <= d_i;
               ch_b_o <= "0000000" & zw_b2(0);
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when s224 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if ((rdy_i = '1') and (zw_REG_OP = X"09" or zw_REG_OP = X"05" or
                zw_REG_OP = X"15" or zw_REG_OP = X"0D" or
                zw_REG_OP = X"1D" or zw_REG_OP = X"19" or 
                zw_REG_OP = X"01" or zw_REG_OP = X"11")) then 
               d_regs_in_o <= d_i OR q_a_i;
               load_regs_o <= '1';
               ch_a_o <= d_i OR q_a_i;
               ch_b_o <= X"00";
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif ((rdy_i = '1') and (zw_REG_OP = X"49" or zw_REG_OP = X"45" or
                   zw_REG_OP = X"55" or zw_REG_OP = X"4D" or
                   zw_REG_OP = X"5D" or zw_REG_OP = X"59" or
                   zw_REG_OP = X"41" or zw_REG_OP = X"51")) then 
               d_regs_in_o <= d_i XOR q_a_i;
               load_regs_o <= '1';
               ch_a_o <= d_i XOR q_a_i;
               ch_b_o <= X"00";
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif ((rdy_i = '1') and (zw_REG_OP = X"29" or zw_REG_OP = X"25" or
                   zw_REG_OP = X"35" or zw_REG_OP = X"2D" or
                   zw_REG_OP = X"3D" or zw_REG_OP = X"39" or
                    zw_REG_OP = X"21" or zw_REG_OP = X"31")) then 
               d_regs_in_o <= d_i AND q_a_i;
               load_regs_o <= '1';
               ch_a_o <= d_i AND q_a_i;
               ch_b_o <= X"00";
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif ((rdy_i = '1') and (zw_REG_OP = X"C9" or zw_REG_OP = X"C5" or
                   zw_REG_OP = X"D5" or zw_REG_OP = X"CD" or
                   zw_REG_OP = X"DD" or zw_REG_OP = X"D9" or
                   zw_REG_OP = X"C1" or zw_REG_OP = X"D1" or
                    zw_REG_OP = X"C0" or zw_REG_OP = X"E0" or
                    zw_REG_OP = X"C4" or zw_REG_OP = X"E4" or
                    zw_REG_OP = X"CC" or zw_REG_OP = X"EC")) then 
               zw_ALU <= unsigned ('0' & d_regs_out_i) + unsigned ('0' & NOT (d_i)) + 1;
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif (rdy_i = '1') then 
               d_regs_in_o <= d_i;
               load_regs_o <= '1';
               ch_a_o <= d_i;
               ch_b_o <= X"00";
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when s225 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if ((rdy_i = '1' AND
                zw_b2(0) = '0') and (zw_REG_OP = X"09" or zw_REG_OP = X"05" or
                zw_REG_OP = X"15" or zw_REG_OP = X"0D" or
                zw_REG_OP = X"1D" or zw_REG_OP = X"19" or 
                zw_REG_OP = X"01" or zw_REG_OP = X"11")) then 
               d_regs_in_o <= d_i OR q_a_i;
               load_regs_o <= '1';
               ch_a_o <= d_i OR q_a_i;
               ch_b_o <= X"00";
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif ((rdy_i = '1' AND
                   zw_b2(0) = '0') and (zw_REG_OP = X"49" or zw_REG_OP = X"45" or
                   zw_REG_OP = X"55" or zw_REG_OP = X"4D" or
                   zw_REG_OP = X"5D" or zw_REG_OP = X"59" or
                   zw_REG_OP = X"41" or zw_REG_OP = X"51")) then 
               d_regs_in_o <= d_i XOR q_a_i;
               load_regs_o <= '1';
               ch_a_o <= d_i XOR q_a_i;
               ch_b_o <= X"00";
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif ((rdy_i = '1' AND
                   zw_b2(0) = '0') and (zw_REG_OP = X"29" or zw_REG_OP = X"25" or
                   zw_REG_OP = X"35" or zw_REG_OP = X"2D" or
                   zw_REG_OP = X"3D" or zw_REG_OP = X"39" or
                    zw_REG_OP = X"21" or zw_REG_OP = X"31")) then 
               d_regs_in_o <= d_i AND q_a_i;
               load_regs_o <= '1';
               ch_a_o <= d_i AND q_a_i;
               ch_b_o <= X"00";
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif ((rdy_i = '1' AND
                   zw_b2(0) = '0') and (zw_REG_OP = X"C9" or zw_REG_OP = X"C5" or
                   zw_REG_OP = X"D5" or zw_REG_OP = X"CD" or
                   zw_REG_OP = X"DD" or zw_REG_OP = X"D9" or
                   zw_REG_OP = X"C1" or zw_REG_OP = X"D1" or
                    zw_REG_OP = X"C0" or zw_REG_OP = X"E0" or
                    zw_REG_OP = X"C4" or zw_REG_OP = X"E4" or
                    zw_REG_OP = X"CC" or zw_REG_OP = X"EC")) then 
               zw_ALU <= unsigned ('0' & d_regs_out_i) + unsigned ('0' & NOT (d_i)) + 1;
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif (rdy_i = '1' AND
                   zw_b2(0) = '0') then 
               d_regs_in_o <= d_i;
               load_regs_o <= '1';
               ch_a_o <= d_i;
               ch_b_o <= X"00";
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when s226 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1' and
                (zw_REG_OP = X"C6" OR
                zw_REG_OP = X"E6")) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"D6" OR
                   zw_REG_OP = X"F6")) then 
               ch_a_o <=  d_i;
               ch_b_o <= q_x_i;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"CE" OR
                   zw_REG_OP = X"EE")) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"DE" OR
                   zw_REG_OP = X"FE")) then 
               ld_o <= "11";
               ld_pc_o <= '1';
               ch_a_o <= d_i;
               ch_b_o <= q_x_i;
            end if;
         when s243 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when s244 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ch_a_o <= d_i;
               ch_b_o <= "0000000" & zw_b2(0);
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when s247 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when s344 => 
            sig_RWn <= '1';
            sig_RD <= '1';
         when s343 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ch_a_o <= d_i;
               ch_b_o <= zw_b4;
            end if;
         when s250 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               sig_RWn <= '0';
               sig_RD <= '0';
               sig_WR <= '1';
               sig_D_OUT <= zw_b1;
            end if;
         when s251 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            ch_a_o <= zw_b1;
            ch_b_o <= X"00";
            sig_SYNC <= '1';
            fetch_o <= '1';
         when s351 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1' and
                zw_REG_OP = X"24") then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"2C") then 
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when s361 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ch_a_o <= q_a_i AND d_i;
               ch_b_o <= X"00";
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when s360 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when s403 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1' and
                (zw_REG_OP = X"1E" or
                zw_REG_OP = X"7E" or
                zw_REG_OP = X"3E" or
                zw_REG_OP = X"5E")) then 
               ld_o <= "11";
               ld_pc_o <= '1';
               ch_a_o <= d_i;
               ch_b_o <= q_x_i;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"06" or
                   zw_REG_OP = X"66" or
                   zw_REG_OP = X"26" or
                   zw_REG_OP = X"46")) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"16" or
                   zw_REG_OP = X"76" or
                   zw_REG_OP = X"36" or
                   zw_REG_OP = X"56")) then 
               ch_a_o <=  d_i;
               ch_b_o <= q_x_i;
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"0E" or
                   zw_REG_OP = X"6E" or
                   zw_REG_OP = X"2E" or
                   zw_REG_OP = X"4E")) then 
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when s406 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when s407 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ch_a_o <= d_i;
               ch_b_o <= "0000000" & zw_b2(0);
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when s409 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when s412 => 
            sig_RWn <= '1';
            sig_RD <= '1';
         when s413 => 
            sig_RWn <= '1';
            sig_RD <= '1';
         when s416 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1' and
                (zw_REG_OP = X"06" or
                zw_REG_OP = X"16" or
                zw_REG_OP = X"0E" or
                zw_REG_OP = X"1E")) then 
               sig_D_OUT <= d_i(6 downto 0) & '0';
               sig_RWn <= '0';
               sig_RD <= '0';
               sig_WR <= '1';
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"46" or
                   zw_REG_OP = X"56" or
                   zw_REG_OP = X"4E" or
                   zw_REG_OP = X"5E")) then 
               sig_D_OUT <= '0' & d_i(7 downto 1);
               sig_RWn <= '0';
               sig_RD <= '0';
               sig_WR <= '1';
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"26" or
                   zw_REG_OP = X"36" or
                   zw_REG_OP = X"2E" or
                   zw_REG_OP = X"3E")) then 
               sig_D_OUT <= d_i(6 downto 0) & reg_F(0);
               sig_RWn <= '0';
               sig_RD <= '0';
               sig_WR <= '1';
            elsif (rdy_i = '1' and
                   (zw_REG_OP = X"66" or
                   zw_REG_OP = X"76" or
                   zw_REG_OP = X"6E" or
                   zw_REG_OP = X"7E")) then 
               sig_D_OUT <= reg_F(0) & d_i(7 downto 1);
               sig_RWn <= '0';
               sig_RD <= '0';
               sig_WR <= '1';
            end if;
         when s418 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            ch_a_o <= zw_b1;
            ch_b_o <= X"00";
            sig_SYNC <= '1';
            fetch_o <= '1';
         when s510 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1' and
                zw_REG_OP = X"65") then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"69" and
                   reg_F(3) = '0') then 
               ld_o <= "11";
               ld_pc_o <= '1';
               d_regs_in_o <= zw_ALU(7 downto 0);
               load_regs_o <= '1';
               zw_ALU <= unsigned ('0' & q_a_i) + unsigned ('0' & d_i) + reg_F(0);
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"75") then 
               ch_a_o <=  d_i;
               ch_b_o <= q_x_i;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"6D") then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"7D") then 
               ld_o <= "11";
               ld_pc_o <= '1';
               ch_a_o <= d_i;
               ch_b_o <= q_x_i;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"79") then 
               ld_o <= "11";
               ld_pc_o <= '1';
               ch_a_o <= d_i;
               ch_b_o <= q_y_i;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"71") then 
               ch_a_o <= d_i;
               ch_b_o <= X"01";
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"61") then 
               ch_a_o <=  d_i;
               ch_b_o <= q_x_i;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"69" and
                   reg_F(3) = '1') then 
               ld_o <= "11";
               ld_pc_o <= '1';
               d_regs_in_o <= zw_ALU(7 downto 0);
               load_regs_o <= '1';
               zw_ALU(7 downto 4) <= unsigned (zw_ALU2(3 downto 0)) + unsigned (zw_ALU6(7 downto 5));
               zw_ALU(3 downto 0) <= unsigned (zw_ALU1(3 downto 0)) + unsigned (zw_ALU5(7 downto 5));
               
               zw_ALU6(7 downto 5) <=  (zw_ALU2(4) OR zw_ALU4(4)) & (zw_ALU2(4) OR zw_ALU4(4)) & '0';
               zw_ALU5(7 downto 5) <=  (zw_ALU1(4) OR zw_ALU3(4)) & (zw_ALU1(4) OR zw_ALU3(4)) & '0';
               
               zw_ALU4(4 downto 0) <= unsigned ('0' & zw_ALU2(3 downto 0)) + 6;
               zw_ALU2(4 downto 0) <= unsigned ('0' & q_a_i(7 downto 4)) + unsigned 
               ('0' & d_i(7 downto 4)) + (zw_ALU1(4) OR zw_ALU3(4));
               
               zw_ALU3(4 downto 0) <= unsigned ('0' & zw_ALU1(3 downto 0)) + 6;
               zw_ALU1(4 downto 0) <= unsigned ('0' & q_a_i(3 downto 0)) + unsigned 
               ('0' & d_i(3 downto 0)) + reg_F(0);
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when s553 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when s555 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ch_a_o <= d_i;
               ch_b_o <= X"01";
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when s558 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ch_a_o <= d_i;
               ch_b_o <= q_y_i;
            end if;
         when s560 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when s561 => 
            sig_RWn <= '1';
            sig_RD <= '1';
         when s563 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ch_a_o <=  zw_b1;
               ch_b_o <= X"01";
            end if;
         when s564 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1' AND
                zw_b2(0) = '0' and
                reg_F(3) = '0') then 
               d_regs_in_o <= zw_ALU(7 downto 0);
               load_regs_o <= '1';
               zw_ALU <= unsigned ('0' & q_a_i) + unsigned ('0' & d_i) + reg_F(0);
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif (rdy_i = '1' AND
                   zw_b2(0) = '0' and
                   reg_F(3) = '1') then 
               d_regs_in_o <= zw_ALU(7 downto 0);
               load_regs_o <= '1';
               zw_ALU(7 downto 4) <= unsigned (zw_ALU2(3 downto 0)) + unsigned (zw_ALU6(7 downto 5));
               zw_ALU(3 downto 0) <= unsigned (zw_ALU1(3 downto 0)) + unsigned (zw_ALU5(7 downto 5));
               
               zw_ALU6(7 downto 5) <=  (zw_ALU2(4) OR zw_ALU4(4)) & (zw_ALU2(4) OR zw_ALU4(4)) & '0';
               zw_ALU5(7 downto 5) <=  (zw_ALU1(4) OR zw_ALU3(4)) & (zw_ALU1(4) OR zw_ALU3(4)) & '0';
               
               zw_ALU4(4 downto 0) <= unsigned ('0' & zw_ALU2(3 downto 0)) + 6;
               zw_ALU2(4 downto 0) <= unsigned ('0' & q_a_i(7 downto 4)) + unsigned 
               ('0' & d_i(7 downto 4)) + (zw_ALU1(4) OR zw_ALU3(4));
               
               zw_ALU3(4 downto 0) <= unsigned ('0' & zw_ALU1(3 downto 0)) + 6;
               zw_ALU1(4 downto 0) <= unsigned ('0' & q_a_i(3 downto 0)) + unsigned 
               ('0' & d_i(3 downto 0)) + reg_F(0);
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when s565 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1' and
                reg_F(3) = '0') then 
               d_regs_in_o <= zw_ALU(7 downto 0);
               load_regs_o <= '1';
               zw_ALU <= unsigned ('0' & q_a_i) + unsigned ('0' & d_i) + reg_F(0);
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif (rdy_i = '1' and
                   reg_F(3) = '1') then 
               d_regs_in_o <= zw_ALU(7 downto 0);
               load_regs_o <= '1';
               zw_ALU(7 downto 4) <= unsigned (zw_ALU2(3 downto 0)) + unsigned (zw_ALU6(7 downto 5));
               zw_ALU(3 downto 0) <= unsigned (zw_ALU1(3 downto 0)) + unsigned (zw_ALU5(7 downto 5));
               
               zw_ALU6(7 downto 5) <=  (zw_ALU2(4) OR zw_ALU4(4)) & (zw_ALU2(4) OR zw_ALU4(4)) & '0';
               zw_ALU5(7 downto 5) <=  (zw_ALU1(4) OR zw_ALU3(4)) & (zw_ALU1(4) OR zw_ALU3(4)) & '0';
               
               zw_ALU4(4 downto 0) <= unsigned ('0' & zw_ALU2(3 downto 0)) + 6;
               zw_ALU2(4 downto 0) <= unsigned ('0' & q_a_i(7 downto 4)) + unsigned 
               ('0' & d_i(7 downto 4)) + (zw_ALU1(4) OR zw_ALU3(4));
               
               zw_ALU3(4 downto 0) <= unsigned ('0' & zw_ALU1(3 downto 0)) + 6;
               zw_ALU1(4 downto 0) <= unsigned ('0' & q_a_i(3 downto 0)) + unsigned 
               ('0' & d_i(3 downto 0)) + reg_F(0);
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when s566 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ch_a_o <= d_i;
               ch_b_o <= X"01";
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when s266 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1' and (
                (reg_F(0) = '1' and zw_REG_OP = X"90") or
                (reg_F(0) = '0' and zw_REG_OP = X"B0") or
                (reg_F(1) = '0' and zw_REG_OP = X"F0") or
                (reg_F(7) = '0' and zw_REG_OP = X"30") or
                (reg_F(1) = '1' and zw_REG_OP = X"D0") or
                (reg_F(7) = '1' and zw_REG_OP = X"10") or
                (reg_F(6) = '1' and zw_REG_OP = X"50") or
                (reg_F(6) = '0' and zw_REG_OP = X"70"))) then 
               ld_o <= "11";
               ld_pc_o <= '1';
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif (rdy_i = '1') then 
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when s301 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1' and
                zw_b3 = adr_nxt_pc_i (15 downto 8)) then 
               offset_o <= (zw_b2(7) & zw_b2(7) & zw_b2(7) & zw_b2(7) & zw_b2(7) & 
               zw_b2(7) & zw_b2(7) & zw_b2(7) & zw_b2(7) & zw_b2(6 downto 0));
               ld_o <= "11";
               ld_pc_o <= '1';
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif (rdy_i = '1') then 
               offset_o <= (zw_b2(7) & zw_b2(7) & zw_b2(7) & zw_b2(7) & zw_b2(7) & 
               zw_b2(7) & zw_b2(7) & zw_b2(7) & zw_b2(7) & zw_b2(6 downto 0));
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when s302 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when RES => 
            sig_RWn <= '1';
            sig_RD <= '1';
            ld_o <= "11";
            ld_pc_o <= '1';
            ld_sp_o <= '1';
            sig_RWn <= '1';
            sig_RD <= '1';
         when s511 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1' and
                zw_REG_OP = X"E5") then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"E9" and
                   reg_F(3) = '0') then 
               ld_o <= "11";
               ld_pc_o <= '1';
               d_regs_in_o <= zw_ALU(7 downto 0);
               load_regs_o <= '1';
               zw_ALU <= unsigned ('0' & q_a_i) + unsigned ('0' & NOT (d_i)) + reg_F(0);
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"F5") then 
               ch_a_o <=  d_i;
               ch_b_o <= q_x_i;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"ED") then 
               ld_o <= "11";
               ld_pc_o <= '1';
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"FD") then 
               ld_o <= "11";
               ld_pc_o <= '1';
               ch_a_o <= d_i;
               ch_b_o <= q_x_i;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"F9") then 
               ld_o <= "11";
               ld_pc_o <= '1';
               ch_a_o <= d_i;
               ch_b_o <= q_y_i;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"F1") then 
               ch_a_o <= d_i;
               ch_b_o <= X"01";
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"E1") then 
               ch_a_o <=  d_i;
               ch_b_o <= q_x_i;
            elsif (rdy_i = '1' and
                   zw_REG_OP = X"E9" and
                   reg_F(3) = '1') then 
               ld_o <= "11";
               ld_pc_o <= '1';
               d_regs_in_o <= zw_ALU(7 downto 0);
               load_regs_o <= '1';
               zw_ALU(7 downto 4) <= unsigned (zw_ALU2(3 downto 0)) + 
               unsigned ((zw_ALU6(8 downto 5)));
               zw_ALU(3 downto 0) <= unsigned (zw_ALU1(3 downto 0)) + 
               unsigned ((zw_ALU5(8 downto 5)));
               
               zw_ALU6(8 downto 5) <= (zw_ALU4(4) OR NOT (zw_ALU2(4))) & '0' & 
               (zw_ALU4(4) OR NOT (zw_ALU2(4))) & '0';
               zw_ALU5(8 downto 5) <= (zw_ALU3(4) OR NOT (zw_ALU1(4))) & '0' & 
               (zw_ALU3(4) OR NOT (zw_ALU1(4))) & '0' ;
               
               zw_ALU4(4 downto 0) <= unsigned ('0' & zw_ALU2(3 downto 0)) + 6;
               zw_ALU2(4 downto 0) <= unsigned ('0' & q_a_i(7 downto 4)) + unsigned 
               ('0' & NOT (d_i(7 downto 4))) + zw_ALU1(4);
               
               zw_ALU3(4 downto 0) <= unsigned ('0' & zw_ALU1(3 downto 0)) + 6;
               zw_ALU1(4 downto 0) <= unsigned ('0' & q_a_i(3 downto 0)) + unsigned 
               ('0' & NOT (d_i(3 downto 0))) + reg_F(0);
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when s559 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when s562 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ch_a_o <= d_i;
               ch_b_o <= X"01";
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when s567 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ch_a_o <= d_i;
               ch_b_o <= X"01";
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when s568 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ch_a_o <= d_i;
               ch_b_o <= q_y_i;
            end if;
         when s569 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when s570 => 
            sig_RWn <= '1';
            sig_RD <= '1';
         when s571 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ch_a_o <= d_i;
               ch_b_o <= X"01";
               ld_o <= "11";
               ld_pc_o <= '1';
            end if;
         when s572 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ch_a_o <=  zw_b1;
               ch_b_o <= X"01";
            end if;
         when s573 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1' AND
                zw_b2(0) = '0' and
                reg_F(3) = '0') then 
               d_regs_in_o <= zw_ALU(7 downto 0);
               load_regs_o <= '1';
               zw_ALU <= unsigned ('0' & q_a_i) + unsigned ('0' & NOT (d_i)) + reg_F(0);
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif (rdy_i = '1' AND
                   zw_b2(0) = '0' and
                   reg_F(3) = '1') then 
               d_regs_in_o <= zw_ALU(7 downto 0);
               load_regs_o <= '1';
               zw_ALU(7 downto 4) <= unsigned (zw_ALU2(3 downto 0)) + 
               unsigned ((zw_ALU6(8 downto 5)));
               zw_ALU(3 downto 0) <= unsigned (zw_ALU1(3 downto 0)) + 
               unsigned ((zw_ALU5(8 downto 5)));
               
               zw_ALU6(8 downto 5) <= (zw_ALU4(4) OR NOT (zw_ALU2(4))) & '0' & 
               (zw_ALU4(4) OR NOT (zw_ALU2(4))) & '0';
               zw_ALU5(8 downto 5) <= (zw_ALU3(4) OR NOT (zw_ALU1(4))) & '0' & 
               (zw_ALU3(4) OR NOT (zw_ALU1(4))) & '0' ;
               
               zw_ALU4(4 downto 0) <= unsigned ('0' & zw_ALU2(3 downto 0)) + 6;
               zw_ALU2(4 downto 0) <= unsigned ('0' & q_a_i(7 downto 4)) + unsigned 
               ('0' & NOT (d_i(7 downto 4))) + zw_ALU1(4);
               
               zw_ALU3(4 downto 0) <= unsigned ('0' & zw_ALU1(3 downto 0)) + 6;
               zw_ALU1(4 downto 0) <= unsigned ('0' & q_a_i(3 downto 0)) + unsigned 
               ('0' & NOT (d_i(3 downto 0))) + reg_F(0);
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when s574 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1' and
                reg_F(3) = '0') then 
               d_regs_in_o <= zw_ALU(7 downto 0);
               load_regs_o <= '1';
               zw_ALU <= unsigned ('0' & q_a_i) + unsigned ('0' & NOT (d_i)) + reg_F(0);
               sig_SYNC <= '1';
               fetch_o <= '1';
            elsif (rdy_i = '1' and
                   reg_F(3) = '1') then 
               d_regs_in_o <= zw_ALU(7 downto 0);
               load_regs_o <= '1';
               zw_ALU(7 downto 4) <= unsigned (zw_ALU2(3 downto 0)) + 
               unsigned ((zw_ALU6(8 downto 5)));
               zw_ALU(3 downto 0) <= unsigned (zw_ALU1(3 downto 0)) + 
               unsigned ((zw_ALU5(8 downto 5)));
               
               zw_ALU6(8 downto 5) <= (zw_ALU4(4) OR NOT (zw_ALU2(4))) & '0' & 
               (zw_ALU4(4) OR NOT (zw_ALU2(4))) & '0';
               zw_ALU5(8 downto 5) <= (zw_ALU3(4) OR NOT (zw_ALU1(4))) & '0' & 
               (zw_ALU3(4) OR NOT (zw_ALU1(4))) & '0' ;
               
               zw_ALU4(4 downto 0) <= unsigned ('0' & zw_ALU2(3 downto 0)) + 6;
               zw_ALU2(4 downto 0) <= unsigned ('0' & q_a_i(7 downto 4)) + unsigned 
               ('0' & NOT (d_i(7 downto 4))) + zw_ALU1(4);
               
               zw_ALU3(4 downto 0) <= unsigned ('0' & zw_ALU1(3 downto 0)) + 6;
               zw_ALU1(4 downto 0) <= unsigned ('0' & q_a_i(3 downto 0)) + unsigned 
               ('0' & NOT (d_i(3 downto 0))) + reg_F(0);
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when s548 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_sp_o <= '1';
               ld_pc_o <= '1';
               sig_RWn <= '0';
               sig_RD <= '0';
               sig_WR <= '1';
               sig_D_OUT <= adr_pc_i (15 downto 8);
            end if;
         when s551 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            ld_o <= "11";
            ld_sp_o <= '1';
            sig_RWn <= '0';
            sig_RD <= '0';
            sig_WR <= '1';
            sig_D_OUT <= adr_pc_i (7 downto 0);
         when s552 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            ld_o <= "11";
            ld_sp_o <= '1';
            sig_RWn <= '0';
            sig_RD <= '0';
            sig_WR <= '1';
            sig_D_OUT <= reg_F;
         when s575 => 
            sig_RWn <= '1';
            sig_RD <= '1';
         when s576 => 
            sig_RWn <= '1';
            sig_RD <= '1';
         when s577 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when s532 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               ld_o <= "11";
               ld_sp_o <= '1';
               ld_pc_o <= '1';
               sig_RWn <= '0';
               sig_RD <= '0';
               sig_WR <= '1';
               sig_D_OUT <= adr_pc_i (15 downto 8);
            end if;
         when s533 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            ld_o <= "11";
            ld_sp_o <= '1';
            sig_RWn <= '0';
            sig_RD <= '0';
            sig_WR <= '1';
            sig_D_OUT <= adr_pc_i (7 downto 0);
         when s534 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            ld_o <= "11";
            ld_sp_o <= '1';
            sig_RWn <= '0';
            sig_RD <= '0';
            sig_WR <= '1';
            sig_D_OUT <= reg_F;
         when s535 => 
            sig_RWn <= '1';
            sig_RD <= '1';
         when s536 => 
            sig_RWn <= '1';
            sig_RD <= '1';
         when s537 => 
            sig_RWn <= '1';
            sig_RD <= '1';
            if (rdy_i = '1') then 
               adr_o <= d_i & zw_b1;
               ld_o <= "11";
               ld_pc_o <= '1';
               sig_SYNC <= '1';
               fetch_o <= '1';
            end if;
         when others =>
            null;
      end case;
   end process output_proc;
 
   -- Concurrent Statements
   -- Clocked output assignments
   d_o <= d_o_cld;
   rd_o <= rd_o_cld;
   sync_o <= sync_o_cld;
   wr_n_o <= wr_n_o_cld;
   wr_o <= wr_o_cld;
   sel_alu_as_o_i <= sel_alu_as_o_i_cld;
   sel_alu_out_o_i <= sel_alu_out_o_i_cld;
   sel_pc_as_o_i <= sel_pc_as_o_i_cld;
   sel_pc_in_o_i <= sel_pc_in_o_i_cld;
   sel_pc_val_o_i <= sel_pc_val_o_i_cld;
   sel_rb_in_o_i <= sel_rb_in_o_i_cld;
   sel_rb_out_o_i <= sel_rb_out_o_i_cld;
   sel_reg_o_i <= sel_reg_o_i_cld;
   sel_sp_as_o_i <= sel_sp_as_o_i_cld;
   sel_sp_in_o_i <= sel_sp_in_o_i_cld;
   sel_sp_val_o_i <= sel_sp_val_o_i_cld;
end fsm;
