-- VHDL Entity R6502_TC.Reg_PC.symbol
--
-- Created:
--          by - eda.UNKNOWN (ENTWICKL4-XP-PR)
--          at - 19:48:44 17.04.2008
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2007.1a (Build 13)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

entity Reg_PC is
   port( 
      adr_i        : in     std_logic_vector (15 downto 0);
      clk_clk_i    : in     std_logic;
      ld_i         : in     std_logic_vector (1 downto 0);
      ld_pc_i      : in     std_logic;
      offset_i     : in     std_logic_vector (15 downto 0);
      rst_rst_i    : in     std_logic;
      sel_pc_as_i  : in     std_logic;
      sel_pc_in_i  : in     std_logic;
      sel_pc_val_i : in     std_logic_vector (1 downto 0);
      adr_nxt_pc_o : out    std_logic_vector (15 downto 0);
      adr_pc_o     : out    std_logic_vector (15 downto 0);
      cout_pc_o    : out    std_logic
   );

-- Declarations

end Reg_PC ;

-- Jens-D. Gutschmidt     Project:  R6502_TC  
-- scantara2003@yahoo.de                      
-- COPYRIGHT (C) 2008 by Jens Gutschmidt and OPENCORES.ORG                                                                                     
--                                                                                                                                             
-- This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by   
-- the Free Software Foundation, either version 3 of the License, or any later version.                                                        
--                                                                                                                                             
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of              
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.                                  
--                                                                                                                                             
-- You should have received a copy of the GNU General Public License along with this program.  If not, see <http://www.gnu.org/licenses/>.     
--                                                                                                                                             
-- CVS Revisins History                                                                                                                        
--                                                                                                                                             
-- $Log: reg_pc.vhd,v $
-- Revision 1.2  2008/04/17 18:39:34  fpga_is_funny
-- Bugfixes for all relationchips with interrupts BRK, IRQ and NMI.
-- The control for the stack pointer within fsm*s of BRK, IRQ and NMI was incorrect. The stack was allways growing up instead of growing down.
-- The "B" status flag was never set within BRK.
-- The relationchip between addresses and data while writing onto the stack was badly misalligned.
--                                                                                                                                       
-- Title:  Program Counter Logic  
-- Path:  R6502_TC/Reg_PC/struct  
-- Edited:  by eda on 17 Apr 2008  
--
-- VHDL Architecture R6502_TC.Reg_PC.struct
--
-- Created:
--          by - eda.UNKNOWN (ENTWICKL4-XP-PR)
--          at - 19:48:44 17.04.2008
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2007.1a (Build 13)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;


architecture struct of Reg_PC is

   -- Architecture declarations

   -- Internal signal declarations
   signal d        : std_logic_vector(7 downto 0);
   signal d1       : std_logic_vector(7 downto 0);
   signal dout     : std_logic;
   signal dout1    : std_logic_vector(7 downto 0);
   signal dout3    : std_logic;
   signal dout5    : std_logic_vector(7 downto 0);
   signal dout6    : std_logic_vector(7 downto 0);
   signal load     : std_logic;
   signal load3    : std_logic;
   signal val_one  : std_logic_vector(7 downto 0);
   signal val_two  : std_logic_vector(7 downto 0);
   signal val_zero : std_logic_vector(7 downto 0);

   -- Implicit buffer signal declarations
   signal adr_pc_o_internal  : std_logic_vector (15 downto 0);
   signal cout_pc_o_internal : std_logic;


   -- ModuleWare signal declarations(v1.9) for instance 'U_0' of 'adff'
   signal mw_U_0reg_cval : std_logic_vector(7 downto 0);

   -- ModuleWare signal declarations(v1.9) for instance 'U_4' of 'adff'
   signal mw_U_4reg_cval : std_logic_vector(7 downto 0);


begin
   -- Architecture concurrent statements
   -- HDL Embedded Text Block 1 eb1
   -- eb1 1
   adr_nxt_pc_o(7 DOWNTO 0) <= d;

   -- HDL Embedded Text Block 2 eb2
   -- eb1 1
   val_zero (7 downto 0) <= X"00";
   val_one (7 downto 0) <= X"01";
   val_two (7 downto 0) <= X"02";

   -- HDL Embedded Text Block 3 eb3
   -- eb1 1
   adr_nxt_pc_o(15 DOWNTO 8) <= d1;


   -- ModuleWare code(v1.9) for instance 'U_11' of 'addsub'
   u_11combo_proc: process (dout5, dout1, dout3, val_zero(0))
   variable temp_din0 : std_logic_vector(8 downto 0);
   variable temp_din1 : std_logic_vector(8 downto 0);
   variable temp_sum : unsigned(8 downto 0);
   variable temp_carry : std_logic;
   variable temp_cout : std_logic;
   begin
      temp_din0 := '0' & dout5;
      temp_din1 := '0' & dout1;
      temp_carry := val_zero(0);
      if (dout3 = '1') then
         temp_sum := unsigned(temp_din0) + unsigned(temp_din1) + temp_carry;
         temp_cout := temp_sum(8) ;
      else
         temp_sum := unsigned(temp_din0) - unsigned(temp_din1) - temp_carry;
         temp_cout := temp_sum(8) ;
      end if;
      d <= conv_std_logic_vector(temp_sum(7 downto 0),8);
      cout_pc_o_internal <= temp_cout;
   end process u_11combo_proc;

   -- ModuleWare code(v1.9) for instance 'U_12' of 'addsub'
   u_12combo_proc: process (dout6, offset_i(15 DOWNTO 8), dout3, dout)
   variable temp_din0 : std_logic_vector(8 downto 0);
   variable temp_din1 : std_logic_vector(8 downto 0);
   variable temp_sum : unsigned(8 downto 0);
   variable temp_carry : std_logic;
   begin
      temp_din0 := '0' & dout6;
      temp_din1 := '0' & offset_i(15 DOWNTO 8);
      temp_carry := dout;
      if (dout3 = '1') then
         temp_sum := unsigned(temp_din0) + unsigned(temp_din1) + temp_carry;
      else
         temp_sum := unsigned(temp_din0) - unsigned(temp_din1) - temp_carry;
      end if;
      d1 <= conv_std_logic_vector(temp_sum(7 downto 0),8);
   end process u_12combo_proc;

   -- ModuleWare code(v1.9) for instance 'U_0' of 'adff'
   adr_pc_o_internal(7 DOWNTO 0) <= mw_U_0reg_cval;
   u_0seq_proc: process (clk_clk_i, rst_rst_i)
   begin
      if (rst_rst_i = '1') then
         mw_U_0reg_cval <= "00000000";
      elsif (clk_clk_i'event and clk_clk_i='1') then
         if (load = '1') then
            mw_U_0reg_cval <= d;
         end if;
      end if;
   end process u_0seq_proc;

   -- ModuleWare code(v1.9) for instance 'U_4' of 'adff'
   adr_pc_o_internal(15 DOWNTO 8) <= mw_U_4reg_cval;
   u_4seq_proc: process (clk_clk_i, rst_rst_i)
   begin
      if (rst_rst_i = '1') then
         mw_U_4reg_cval <= "00000000";
      elsif (clk_clk_i'event and clk_clk_i='1') then
         if (load3 = '1') then
            mw_U_4reg_cval <= d1;
         end if;
      end if;
   end process u_4seq_proc;

   -- ModuleWare code(v1.9) for instance 'U_6' of 'and'
   load <= ld_pc_i and ld_i(0);

   -- ModuleWare code(v1.9) for instance 'U_7' of 'and'
   load3 <= ld_pc_i and ld_i(1);

   -- ModuleWare code(v1.9) for instance 'U_10' of 'and'
   dout <= cout_pc_o_internal and ld_pc_i;

   -- ModuleWare code(v1.9) for instance 'U_2' of 'inv'
   dout3 <= not(sel_pc_as_i);

   -- ModuleWare code(v1.9) for instance 'U_5' of 'mux'
   u_5combo_proc: process(val_one, val_two, offset_i(7 DOWNTO 0), 
                          val_zero, sel_pc_val_i)
   begin
      case sel_pc_val_i is
      when "00" => dout1 <= val_one;
      when "01" => dout1 <= val_two;
      when "10" => dout1 <= offset_i(7 DOWNTO 0);
      when "11" => dout1 <= val_zero;
      when others => dout1 <= (others => 'X');
      end case;
   end process u_5combo_proc;

   -- ModuleWare code(v1.9) for instance 'U_8' of 'mux'
   u_8combo_proc: process(adr_pc_o_internal(7 DOWNTO 0), 
                          adr_i(7 DOWNTO 0), sel_pc_in_i)
   begin
      case sel_pc_in_i is
      when '0' => dout5 <= adr_pc_o_internal(7 DOWNTO 0);
      when '1' => dout5 <= adr_i(7 DOWNTO 0);
      when others => dout5 <= (others => 'X');
      end case;
   end process u_8combo_proc;

   -- ModuleWare code(v1.9) for instance 'U_9' of 'mux'
   u_9combo_proc: process(adr_pc_o_internal(15 DOWNTO 8), 
                          adr_i(15 DOWNTO 8), sel_pc_in_i)
   begin
      case sel_pc_in_i is
      when '0' => dout6 <= adr_pc_o_internal(15 DOWNTO 8);
      when '1' => dout6 <= adr_i(15 DOWNTO 8);
      when others => dout6 <= (others => 'X');
      end case;
   end process u_9combo_proc;

   -- Instance port mappings.

   -- Implicit buffered output assignments
   adr_pc_o  <= adr_pc_o_internal;
   cout_pc_o <= cout_pc_o_internal;

end struct;
