-- VHDL Entity R6502_TC.Reg_SP.symbol
--
-- Created:
--          by - eda.UNKNOWN (ENTWICKL4-XP-PR)
--          at - 19:48:44 17.04.2008
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2007.1a (Build 13)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

entity Reg_SP is
   port( 
      adr_i        : in     std_logic_vector (15 downto 0);
      clk_clk_i    : in     std_logic;
      ld_i         : in     std_logic_vector (1 downto 0);
      ld_sp_i      : in     std_logic;
      rst_rst_i    : in     std_logic;
      sel_sp_as_i  : in     std_logic;
      sel_sp_in_i  : in     std_logic;
      sel_sp_val_i : in     std_logic;
      adr_nxt_sp_o : out    std_logic_vector (15 downto 0);
      adr_sp_o     : out    std_logic_vector (15 downto 0)
   );

-- Declarations

end Reg_SP ;

-- Jens-D. Gutschmidt     Project:  R6502_TC  
-- scantara2003@yahoo.de                      
-- COPYRIGHT (C) 2008 by Jens Gutschmidt and OPENCORES.ORG                                                                                     
--                                                                                                                                             
-- This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by   
-- the Free Software Foundation, either version 3 of the License, or any later version.                                                        
--                                                                                                                                             
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of              
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.                                  
--                                                                                                                                             
-- You should have received a copy of the GNU General Public License along with this program.  If not, see <http://www.gnu.org/licenses/>.     
--                                                                                                                                             
-- CVS Revisins History                                                                                                                        
--                                                                                                                                             
-- $Log: reg_sp.vhd,v $
-- Revision 1.2  2008/04/17 18:39:34  fpga_is_funny
-- Bugfixes for all relationchips with interrupts BRK, IRQ and NMI.
-- The control for the stack pointer within fsm*s of BRK, IRQ and NMI was incorrect. The stack was allways growing up instead of growing down.
-- The "B" status flag was never set within BRK.
-- The relationchip between addresses and data while writing onto the stack was badly misalligned.
--                                                                                                                                      
-- Title:  Stack Pointer Logic  
-- Path:  R6502_TC/Reg_SP/struct  
-- Edited:  by eda on 17 Apr 2008  
--
-- VHDL Architecture R6502_TC.Reg_SP.struct
--
-- Created:
--          by - eda.UNKNOWN (ENTWICKL4-XP-PR)
--          at - 19:48:45 17.04.2008
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2007.1a (Build 13)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;


architecture struct of Reg_SP is

   -- Architecture declarations

   -- Internal signal declarations
   signal d        : std_logic_vector(7 downto 0);
   signal dout1    : std_logic_vector(7 downto 0);
   signal dout2    : std_logic_vector(7 downto 0);
   signal dout3    : std_logic;
   signal load     : std_logic;
   signal load3    : std_logic;
   signal val_one  : std_logic_vector(7 downto 0);
   signal val_two  : std_logic_vector(7 downto 0);
   signal val_zero : std_logic_vector(7 downto 0);

   -- Implicit buffer signal declarations
   signal adr_sp_o_internal : std_logic_vector (15 downto 0);


   -- ModuleWare signal declarations(v1.9) for instance 'U_0' of 'adff'
   signal mw_U_0reg_cval : std_logic_vector(7 downto 0);

   -- ModuleWare signal declarations(v1.9) for instance 'U_4' of 'adff'
   signal mw_U_4reg_cval : std_logic_vector(7 downto 0);


begin
   -- Architecture concurrent statements
   -- HDL Embedded Text Block 2 eb2
   -- eb1 1
   val_zero (7 downto 0) <= X"00";
   val_one (7 downto 0) <= X"01";
   val_two (7 downto 0) <= X"02";
   adr_nxt_sp_o (15 downto 8) <= X"01";

   -- HDL Embedded Text Block 3 eb3
   -- eb1 1
   adr_nxt_sp_o (7 DOWNTO 0) <= d;


   -- ModuleWare code(v1.9) for instance 'U_11' of 'addsub'
   u_11combo_proc: process (adr_sp_o_internal(7 DOWNTO 0), dout1, dout3, val_zero(0))
   variable temp_din0 : std_logic_vector(8 downto 0);
   variable temp_din1 : std_logic_vector(8 downto 0);
   variable temp_sum : unsigned(8 downto 0);
   variable temp_carry : std_logic;
   begin
      temp_din0 := '0' & adr_sp_o_internal(7 DOWNTO 0);
      temp_din1 := '0' & dout1;
      temp_carry := val_zero(0);
      if (dout3 = '1') then
         temp_sum := unsigned(temp_din0) + unsigned(temp_din1) + temp_carry;
      else
         temp_sum := unsigned(temp_din0) - unsigned(temp_din1) - temp_carry;
      end if;
      dout2 <= conv_std_logic_vector(temp_sum(7 downto 0),8);
   end process u_11combo_proc;

   -- ModuleWare code(v1.9) for instance 'U_0' of 'adff'
   adr_sp_o_internal(7 DOWNTO 0) <= mw_U_0reg_cval;
   u_0seq_proc: process (clk_clk_i, rst_rst_i)
   begin
      if (rst_rst_i = '1') then
         mw_U_0reg_cval <= "00000000";
      elsif (clk_clk_i'event and clk_clk_i='1') then
         if (load = '1') then
            mw_U_0reg_cval <= d;
         end if;
      end if;
   end process u_0seq_proc;

   -- ModuleWare code(v1.9) for instance 'U_4' of 'adff'
   adr_sp_o_internal(15 DOWNTO 8) <= mw_U_4reg_cval;
   u_4seq_proc: process (clk_clk_i, rst_rst_i)
   begin
      if (rst_rst_i = '1') then
         mw_U_4reg_cval <= "00000000";
      elsif (clk_clk_i'event and clk_clk_i='1') then
         if (load3 = '1') then
            mw_U_4reg_cval <= val_one;
         end if;
      end if;
   end process u_4seq_proc;

   -- ModuleWare code(v1.9) for instance 'U_6' of 'and'
   load <= ld_sp_i and ld_i(0);

   -- ModuleWare code(v1.9) for instance 'U_7' of 'and'
   load3 <= ld_sp_i and ld_i(1);

   -- ModuleWare code(v1.9) for instance 'U_2' of 'inv'
   dout3 <= not(sel_sp_as_i);

   -- ModuleWare code(v1.9) for instance 'U_5' of 'mux'
   u_5combo_proc: process(val_one, val_two, sel_sp_val_i)
   begin
      case sel_sp_val_i is
      when '0' => dout1 <= val_one;
      when '1' => dout1 <= val_two;
      when others => dout1 <= (others => 'X');
      end case;
   end process u_5combo_proc;

   -- ModuleWare code(v1.9) for instance 'U_8' of 'mux'
   u_8combo_proc: process(dout2, adr_i(7 DOWNTO 0), sel_sp_in_i)
   begin
      case sel_sp_in_i is
      when '0' => d <= dout2;
      when '1' => d <= adr_i(7 DOWNTO 0);
      when others => d <= (others => 'X');
      end case;
   end process u_8combo_proc;

   -- Instance port mappings.

   -- Implicit buffered output assignments
   adr_sp_o <= adr_sp_o_internal;

end struct;
