-- VHDL Entity R6502_TC.Testbench.symbol
--
-- Created:
--          by - eda.UNKNOWN (ENTWICKL4-XP-PR)
--          at - 13:06:53 08.04.2008
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2007.1a (Build 13)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

entity Testbench is
   port( 
      IRQn     : in     std_logic;
      NMIn     : in     std_logic;
      RDY      : in     std_logic;
      RSTn     : in     std_logic;
      clk      : in     std_logic;
      clk1     : in     std_logic;
      so_n_i   : in     std_logic;
      A        : out    std_logic_vector (15 downto 0);
      CPU_DOUT : out    std_logic_vector ( 7 downto 0 );
      RAM_DOUT : out    std_logic_vector (7 downto 0);
      RD       : out    std_logic;
      SYNC     : out    std_logic;
      WR       : out    std_logic
   );

-- Declarations

end Testbench ;

-- Jens-D. Gutschmidt     Project:  R6502_TC  
-- scantara2003@yahoo.de                      
-- COPYRIGHT (C) 2008 by Jens Gutschmidt and OPENCORES.ORG                                                                                     
--                                                                                                                                             
-- This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by   
-- the Free Software Foundation, either version 3 of the License, or any later version.                                                        
--                                                                                                                                             
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of              
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.                                  
--                                                                                                                                             
-- You should have received a copy of the GNU General Public License along with this program.  If not, see <http://www.gnu.org/licenses/>.     
--                                                                                                                                             
-- CVS Revisins History                                                                                                                        
--                                                                                                                                             
-- $log$                                                                                                                                       
--                                                                                                                                             
-- Title:  Testbench for the 6502 Core  
-- Path:  R6502_TC/Testbench/struct  
-- Edited:  by eda on 08 Apr 2008  
--
-- VHDL Architecture R6502_TC.Testbench.struct
--
-- Created:
--          by - eda.UNKNOWN (ENTWICKL4-XP-PR)
--          at - 13:06:54 08.04.2008
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2007.1a (Build 13)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

library R6502_TC;

architecture struct of Testbench is

   -- Architecture declarations

   -- Internal signal declarations
   signal dout  : std_logic_vector(7 downto 0);
   signal dout1 : std_logic_vector(7 downto 0);

   -- Implicit buffer signal declarations
   signal CPU_DOUT_internal : std_logic_vector ( 7 downto 0 );
   signal RAM_DOUT_internal : std_logic_vector (7 downto 0);
   signal WR_internal       : std_logic;
   signal A_internal        : std_logic_vector (15 downto 0);


   -- ModuleWare signal declarations(v1.9) for instance 'U_2' of 'ramsp'
   type MW_U_2RAM_TYPE is array (((2**16) -1) downto 0) of std_logic_vector(7 downto 0);
   signal mw_U_2ram_table : MW_U_2RAM_TYPE := (others => "00000000");
   signal mw_U_2addr_reg: std_logic_vector(15 downto 0);

   -- ModuleWare signal declarations(v1.9) for instance 'U_3' of 'rom'
   type MW_U_3ROM_TYPE is array(65535 downto 0) of std_logic_vector(7 downto 0);
   signal mw_U_3rom_table : MW_U_3ROM_TYPE;
   signal mw_U_3addr_int : INTEGER := 0 ;

   -- Component Declarations
   component R6502_TC
   port (
      clk_clk_i   : in     std_logic ;
      d_i         : in     std_logic_vector (7 downto 0);
      irq_n_i     : in     std_logic ;
      nmi_n_i     : in     std_logic ;
      rdy_i       : in     std_logic ;
      rst_rst_n_i : in     std_logic ;
      so_n_i      : in     std_logic ;
      a_o         : out    std_logic_vector (15 downto 0);
      d_o         : out    std_logic_vector (7 downto 0);
      rd_o        : out    std_logic ;
      sync_o      : out    std_logic ;
      wr_n_o      : out    std_logic ;
      wr_o        : out    std_logic 
   );
   end component;

   -- Optional embedded configurations
   -- pragma synthesis_off
   for all : R6502_TC use entity R6502_TC.R6502_TC;
   -- pragma synthesis_on


begin

   -- ModuleWare code(v1.9) for instance 'U_1' of 'mux'
   u_1combo_proc: process(dout, dout1, A_internal(15))
   begin
      case A_internal(15) is
      when '0' => RAM_DOUT_internal <= dout;
      when '1' => RAM_DOUT_internal <= dout1;
      when others => RAM_DOUT_internal <= (others => 'X');
      end case;
   end process u_1combo_proc;

   -- ModuleWare code(v1.9) for instance 'U_2' of 'ramsp'
   --attribute block_ram : boolean;
   --attribute block_ram of mem : signal is false;
   u_2ram_p_proc: process (clk1)
   begin
      if (clk1'event and clk1='1') then
         if (WR_internal = '1') then
            mw_U_2ram_table(CONV_INTEGER(unsigned(A_internal))) <= CPU_DOUT_internal;
         end if;
         mw_U_2addr_reg <= A_internal;
      end if;
   end process u_2ram_p_proc;
   dout <= mw_U_2ram_table(CONV_INTEGER(unsigned(mw_U_2addr_reg)));

   -- ModuleWare code(v1.9) for instance 'U_3' of 'rom'
   mw_U_3addr_int <= (CONV_INTEGER(unsigned(A_internal(15 DOWNTO 0))));
   u_3rom_table_proc : process ( mw_U_3addr_int )
   begin
      case mw_U_3addr_int is 
         when 32768 => mw_U_3rom_table(32768) <= "11111111";
         when 32769 => mw_U_3rom_table(32769) <= "11111111";
         when 32770 => mw_U_3rom_table(32770) <= "11111111";
         when 32771 => mw_U_3rom_table(32771) <= "11111111";
         when 32772 => mw_U_3rom_table(32772) <= "11111111";
         when 32773 => mw_U_3rom_table(32773) <= "11111111";
         when 32774 => mw_U_3rom_table(32774) <= "11111111";
         when 32775 => mw_U_3rom_table(32775) <= "11111111";
         when 32776 => mw_U_3rom_table(32776) <= "11111111";
         when 32777 => mw_U_3rom_table(32777) <= "11111111";
         when 32778 => mw_U_3rom_table(32778) <= "11111111";
         when 32779 => mw_U_3rom_table(32779) <= "11111111";
         when 32780 => mw_U_3rom_table(32780) <= "11111111";
         when 32781 => mw_U_3rom_table(32781) <= "11111111";
         when 32782 => mw_U_3rom_table(32782) <= "11111111";
         when 32783 => mw_U_3rom_table(32783) <= "11111111";
         when 32784 => mw_U_3rom_table(32784) <= "11111111";
         when 32785 => mw_U_3rom_table(32785) <= "11111111";
         when 32786 => mw_U_3rom_table(32786) <= "11111111";
         when 32787 => mw_U_3rom_table(32787) <= "11111111";
         when 32788 => mw_U_3rom_table(32788) <= "11111111";
         when 32789 => mw_U_3rom_table(32789) <= "11111111";
         when 32790 => mw_U_3rom_table(32790) <= "11111111";
         when 32791 => mw_U_3rom_table(32791) <= "11111111";
         when 32792 => mw_U_3rom_table(32792) <= "11111111";
         when 32793 => mw_U_3rom_table(32793) <= "11111111";
         when 32794 => mw_U_3rom_table(32794) <= "11111111";
         when 32795 => mw_U_3rom_table(32795) <= "11111111";
         when 32796 => mw_U_3rom_table(32796) <= "11111111";
         when 32797 => mw_U_3rom_table(32797) <= "11111111";
         when 32798 => mw_U_3rom_table(32798) <= "11111111";
         when 32799 => mw_U_3rom_table(32799) <= "00000000";
         when 57344 => mw_U_3rom_table(57344) <= "00010100";
         when 57345 => mw_U_3rom_table(57345) <= "00000000";
         when 57346 => mw_U_3rom_table(57346) <= "00001010";
         when 57347 => mw_U_3rom_table(57347) <= "00000000";
         when 57348 => mw_U_3rom_table(57348) <= "00000100";
         when 57349 => mw_U_3rom_table(57349) <= "00000000";
         when 57350 => mw_U_3rom_table(57350) <= "00000011";
         when 57351 => mw_U_3rom_table(57351) <= "00000000";
         when 57352 => mw_U_3rom_table(57352) <= "00000010";
         when 57353 => mw_U_3rom_table(57353) <= "00000000";
         when 57354 => mw_U_3rom_table(57354) <= "00000001";
         when 57355 => mw_U_3rom_table(57355) <= "00000000";
         when 57356 => mw_U_3rom_table(57356) <= "00000000";
         when 57357 => mw_U_3rom_table(57357) <= "00000100";
         when 57358 => mw_U_3rom_table(57358) <= "11010010";
         when 57359 => mw_U_3rom_table(57359) <= "00000100";
         when 57360 => mw_U_3rom_table(57360) <= "11010010";
         when 57361 => mw_U_3rom_table(57361) <= "00000010";
         when 57362 => mw_U_3rom_table(57362) <= "10011100";
         when 57363 => mw_U_3rom_table(57363) <= "00000010";
         when 57364 => mw_U_3rom_table(57364) <= "10011100";
         when 57365 => mw_U_3rom_table(57365) <= "00000000";
         when 57366 => mw_U_3rom_table(57366) <= "00101010";
         when 57367 => mw_U_3rom_table(57367) <= "00000000";
         when 57368 => mw_U_3rom_table(57368) <= "00101010";
         when 57369 => mw_U_3rom_table(57369) <= "00010010";
         when 57370 => mw_U_3rom_table(57370) <= "00110100";
         when 57371 => mw_U_3rom_table(57371) <= "00000110";
         when 57372 => mw_U_3rom_table(57372) <= "00010001";
         when 57373 => mw_U_3rom_table(57373) <= "00010010";
         when 57374 => mw_U_3rom_table(57374) <= "00110100";
         when 57375 => mw_U_3rom_table(57375) <= "00010010";
         when 57376 => mw_U_3rom_table(57376) <= "00000001";
         when 57377 => mw_U_3rom_table(57377) <= "00000000";
         when 57378 => mw_U_3rom_table(57378) <= "00000001";
         when 57379 => mw_U_3rom_table(57379) <= "00000000";
         when 57380 => mw_U_3rom_table(57380) <= "00000001";
         when 57381 => mw_U_3rom_table(57381) <= "00000000";
         when 57382 => mw_U_3rom_table(57382) <= "00000000";
         when 57383 => mw_U_3rom_table(57383) <= "00000000";
         when 57384 => mw_U_3rom_table(57384) <= "00000001";
         when 57385 => mw_U_3rom_table(57385) <= "00000000";
         when 57386 => mw_U_3rom_table(57386) <= "00000000";
         when 57387 => mw_U_3rom_table(57387) <= "00000000";
         when 57388 => mw_U_3rom_table(57388) <= "00000001";
         when 57389 => mw_U_3rom_table(57389) <= "00100011";
         when 57390 => mw_U_3rom_table(57390) <= "01000000";
         when 57391 => mw_U_3rom_table(57391) <= "00000001";
         when 57392 => mw_U_3rom_table(57392) <= "00100011";
         when 57393 => mw_U_3rom_table(57393) <= "00000000";
         when 57394 => mw_U_3rom_table(57394) <= "00000011";
         when 57395 => mw_U_3rom_table(57395) <= "11111111";
         when 57396 => mw_U_3rom_table(57396) <= "11111100";
         when 57397 => mw_U_3rom_table(57397) <= "00000000";
         when 57398 => mw_U_3rom_table(57398) <= "00001010";
         when 57399 => mw_U_3rom_table(57399) <= "00000000";
         when 57400 => mw_U_3rom_table(57400) <= "00010101";
         when 57401 => mw_U_3rom_table(57401) <= "11100000";
         when 57402 => mw_U_3rom_table(57402) <= "00100101";
         when 57403 => mw_U_3rom_table(57403) <= "11100000";
         when 57404 => mw_U_3rom_table(57404) <= "00100011";
         when 57405 => mw_U_3rom_table(57405) <= "00000000";
         when 57406 => mw_U_3rom_table(57406) <= "01100100";
         when 57407 => mw_U_3rom_table(57407) <= "00000000";
         when 57408 => mw_U_3rom_table(57408) <= "11111111";
         when 57409 => mw_U_3rom_table(57409) <= "11111111";
         when 57410 => mw_U_3rom_table(57410) <= "11111111";
         when 57411 => mw_U_3rom_table(57411) <= "11111111";
         when 57412 => mw_U_3rom_table(57412) <= "11111111";
         when 57413 => mw_U_3rom_table(57413) <= "11111111";
         when 57414 => mw_U_3rom_table(57414) <= "11111111";
         when 57415 => mw_U_3rom_table(57415) <= "11111111";
         when 57416 => mw_U_3rom_table(57416) <= "11111111";
         when 57417 => mw_U_3rom_table(57417) <= "11111111";
         when 57418 => mw_U_3rom_table(57418) <= "11111111";
         when 57419 => mw_U_3rom_table(57419) <= "11111111";
         when 57420 => mw_U_3rom_table(57420) <= "11111111";
         when 57421 => mw_U_3rom_table(57421) <= "11111111";
         when 57422 => mw_U_3rom_table(57422) <= "11111111";
         when 57423 => mw_U_3rom_table(57423) <= "11111111";
         when 57424 => mw_U_3rom_table(57424) <= "11111111";
         when 57425 => mw_U_3rom_table(57425) <= "11111111";
         when 57426 => mw_U_3rom_table(57426) <= "11111111";
         when 57427 => mw_U_3rom_table(57427) <= "11111111";
         when 57428 => mw_U_3rom_table(57428) <= "11111111";
         when 57429 => mw_U_3rom_table(57429) <= "11111111";
         when 57430 => mw_U_3rom_table(57430) <= "11111111";
         when 57431 => mw_U_3rom_table(57431) <= "11111111";
         when 57432 => mw_U_3rom_table(57432) <= "11111111";
         when 57433 => mw_U_3rom_table(57433) <= "00010010";
         when 57434 => mw_U_3rom_table(57434) <= "00110100";
         when 57435 => mw_U_3rom_table(57435) <= "00000000";
         when 57436 => mw_U_3rom_table(57436) <= "00000000";
         when 57437 => mw_U_3rom_table(57437) <= "00000000";
         when 57438 => mw_U_3rom_table(57438) <= "00000000";
         when 57439 => mw_U_3rom_table(57439) <= "00000000";
         when 61440 => mw_U_3rom_table(61440) <= "00000110";
         when 61441 => mw_U_3rom_table(61441) <= "10101101";
         when 61442 => mw_U_3rom_table(61442) <= "01011011";
         when 61443 => mw_U_3rom_table(61443) <= "10000101";
         when 61444 => mw_U_3rom_table(61444) <= "11100000";
         when 61445 => mw_U_3rom_table(61445) <= "00000101";
         when 61446 => mw_U_3rom_table(61446) <= "10101101";
         when 61447 => mw_U_3rom_table(61447) <= "01011010";
         when 61448 => mw_U_3rom_table(61448) <= "10000101";
         when 61449 => mw_U_3rom_table(61449) <= "11100000";
         when 61450 => mw_U_3rom_table(61450) <= "00000100";
         when 61451 => mw_U_3rom_table(61451) <= "10101101";
         when 61452 => mw_U_3rom_table(61452) <= "01011001";
         when 61453 => mw_U_3rom_table(61453) <= "10000101";
         when 61454 => mw_U_3rom_table(61454) <= "11100000";
         when 61455 => mw_U_3rom_table(61455) <= "00000011";
         when 61456 => mw_U_3rom_table(61456) <= "10101101";
         when 61457 => mw_U_3rom_table(61457) <= "01011000";
         when 61458 => mw_U_3rom_table(61458) <= "10000101";
         when 61459 => mw_U_3rom_table(61459) <= "11100000";
         when 61460 => mw_U_3rom_table(61460) <= "00000010";
         when 61461 => mw_U_3rom_table(61461) <= "10101101";
         when 61462 => mw_U_3rom_table(61462) <= "01010111";
         when 61463 => mw_U_3rom_table(61463) <= "10000101";
         when 61464 => mw_U_3rom_table(61464) <= "11100000";
         when 61465 => mw_U_3rom_table(61465) <= "00000001";
         when 61466 => mw_U_3rom_table(61466) <= "10101101";
         when 61467 => mw_U_3rom_table(61467) <= "01010110";
         when 61468 => mw_U_3rom_table(61468) <= "10000101";
         when 61469 => mw_U_3rom_table(61469) <= "11100000";
         when 61470 => mw_U_3rom_table(61470) <= "00000000";
         when 61471 => mw_U_3rom_table(61471) <= "10101101";
         when 61472 => mw_U_3rom_table(61472) <= "10000101";
         when 61473 => mw_U_3rom_table(61473) <= "11100000";
         when 61474 => mw_U_3rom_table(61474) <= "00001100";
         when 61475 => mw_U_3rom_table(61475) <= "10101101";
         when 61476 => mw_U_3rom_table(61476) <= "01100001";
         when 61477 => mw_U_3rom_table(61477) <= "10000101";
         when 61478 => mw_U_3rom_table(61478) <= "11100000";
         when 61479 => mw_U_3rom_table(61479) <= "00001011";
         when 61480 => mw_U_3rom_table(61480) <= "10101101";
         when 61481 => mw_U_3rom_table(61481) <= "01100000";
         when 61482 => mw_U_3rom_table(61482) <= "10000101";
         when 61483 => mw_U_3rom_table(61483) <= "11100000";
         when 61484 => mw_U_3rom_table(61484) <= "00001010";
         when 61485 => mw_U_3rom_table(61485) <= "10101101";
         when 61486 => mw_U_3rom_table(61486) <= "01011111";
         when 61487 => mw_U_3rom_table(61487) <= "10000101";
         when 61488 => mw_U_3rom_table(61488) <= "11100000";
         when 61489 => mw_U_3rom_table(61489) <= "00001001";
         when 61490 => mw_U_3rom_table(61490) <= "10101101";
         when 61491 => mw_U_3rom_table(61491) <= "01011110";
         when 61492 => mw_U_3rom_table(61492) <= "10000101";
         when 61493 => mw_U_3rom_table(61493) <= "11100000";
         when 61494 => mw_U_3rom_table(61494) <= "00001000";
         when 61495 => mw_U_3rom_table(61495) <= "10101101";
         when 61496 => mw_U_3rom_table(61496) <= "01011101";
         when 61497 => mw_U_3rom_table(61497) <= "10000101";
         when 61498 => mw_U_3rom_table(61498) <= "11100000";
         when 61499 => mw_U_3rom_table(61499) <= "00000111";
         when 61500 => mw_U_3rom_table(61500) <= "10101101";
         when 61501 => mw_U_3rom_table(61501) <= "01011100";
         when 61502 => mw_U_3rom_table(61502) <= "10000101";
         when 61503 => mw_U_3rom_table(61503) <= "11100000";
         when 61504 => mw_U_3rom_table(61504) <= "10101101";
         when 61505 => mw_U_3rom_table(61505) <= "01101000";
         when 61506 => mw_U_3rom_table(61506) <= "10000101";
         when 61507 => mw_U_3rom_table(61507) <= "11100000";
         when 61508 => mw_U_3rom_table(61508) <= "00010010";
         when 61509 => mw_U_3rom_table(61509) <= "10101101";
         when 61510 => mw_U_3rom_table(61510) <= "01100111";
         when 61511 => mw_U_3rom_table(61511) <= "10000101";
         when 61512 => mw_U_3rom_table(61512) <= "11100000";
         when 61513 => mw_U_3rom_table(61513) <= "00010001";
         when 61514 => mw_U_3rom_table(61514) <= "10101101";
         when 61515 => mw_U_3rom_table(61515) <= "01100110";
         when 61516 => mw_U_3rom_table(61516) <= "10000101";
         when 61517 => mw_U_3rom_table(61517) <= "11100000";
         when 61518 => mw_U_3rom_table(61518) <= "00010000";
         when 61519 => mw_U_3rom_table(61519) <= "10101101";
         when 61520 => mw_U_3rom_table(61520) <= "01100101";
         when 61521 => mw_U_3rom_table(61521) <= "10000101";
         when 61522 => mw_U_3rom_table(61522) <= "11100000";
         when 61523 => mw_U_3rom_table(61523) <= "00001111";
         when 61524 => mw_U_3rom_table(61524) <= "10101101";
         when 61525 => mw_U_3rom_table(61525) <= "01100100";
         when 61526 => mw_U_3rom_table(61526) <= "10000101";
         when 61527 => mw_U_3rom_table(61527) <= "11100000";
         when 61528 => mw_U_3rom_table(61528) <= "00001110";
         when 61529 => mw_U_3rom_table(61529) <= "10101101";
         when 61530 => mw_U_3rom_table(61530) <= "01100011";
         when 61531 => mw_U_3rom_table(61531) <= "10000101";
         when 61532 => mw_U_3rom_table(61532) <= "11100000";
         when 61533 => mw_U_3rom_table(61533) <= "00001101";
         when 61534 => mw_U_3rom_table(61534) <= "10101101";
         when 61535 => mw_U_3rom_table(61535) <= "01100010";
         when 61536 => mw_U_3rom_table(61536) <= "11100000";
         when 61537 => mw_U_3rom_table(61537) <= "00011001";
         when 61538 => mw_U_3rom_table(61538) <= "10101101";
         when 61539 => mw_U_3rom_table(61539) <= "01101110";
         when 61540 => mw_U_3rom_table(61540) <= "10000101";
         when 61541 => mw_U_3rom_table(61541) <= "11100000";
         when 61542 => mw_U_3rom_table(61542) <= "00011000";
         when 61543 => mw_U_3rom_table(61543) <= "10101101";
         when 61544 => mw_U_3rom_table(61544) <= "01101101";
         when 61545 => mw_U_3rom_table(61545) <= "10000101";
         when 61546 => mw_U_3rom_table(61546) <= "11100000";
         when 61547 => mw_U_3rom_table(61547) <= "00010111";
         when 61548 => mw_U_3rom_table(61548) <= "10101101";
         when 61549 => mw_U_3rom_table(61549) <= "01101100";
         when 61550 => mw_U_3rom_table(61550) <= "10000101";
         when 61551 => mw_U_3rom_table(61551) <= "11100000";
         when 61552 => mw_U_3rom_table(61552) <= "00010110";
         when 61553 => mw_U_3rom_table(61553) <= "10101101";
         when 61554 => mw_U_3rom_table(61554) <= "01101011";
         when 61555 => mw_U_3rom_table(61555) <= "10000101";
         when 61556 => mw_U_3rom_table(61556) <= "11100000";
         when 61557 => mw_U_3rom_table(61557) <= "00010101";
         when 61558 => mw_U_3rom_table(61558) <= "10101101";
         when 61559 => mw_U_3rom_table(61559) <= "01101010";
         when 61560 => mw_U_3rom_table(61560) <= "10000101";
         when 61561 => mw_U_3rom_table(61561) <= "11100000";
         when 61562 => mw_U_3rom_table(61562) <= "00010100";
         when 61563 => mw_U_3rom_table(61563) <= "10101101";
         when 61564 => mw_U_3rom_table(61564) <= "01101001";
         when 61565 => mw_U_3rom_table(61565) <= "10000101";
         when 61566 => mw_U_3rom_table(61566) <= "11100000";
         when 61567 => mw_U_3rom_table(61567) <= "00010011";
         when 61568 => mw_U_3rom_table(61568) <= "01110101";
         when 61569 => mw_U_3rom_table(61569) <= "10000101";
         when 61570 => mw_U_3rom_table(61570) <= "11100000";
         when 61571 => mw_U_3rom_table(61571) <= "00011111";
         when 61572 => mw_U_3rom_table(61572) <= "10101101";
         when 61573 => mw_U_3rom_table(61573) <= "01110100";
         when 61574 => mw_U_3rom_table(61574) <= "10000101";
         when 61575 => mw_U_3rom_table(61575) <= "11100000";
         when 61576 => mw_U_3rom_table(61576) <= "00011110";
         when 61577 => mw_U_3rom_table(61577) <= "10101101";
         when 61578 => mw_U_3rom_table(61578) <= "01110011";
         when 61579 => mw_U_3rom_table(61579) <= "10000101";
         when 61580 => mw_U_3rom_table(61580) <= "11100000";
         when 61581 => mw_U_3rom_table(61581) <= "00011101";
         when 61582 => mw_U_3rom_table(61582) <= "10101101";
         when 61583 => mw_U_3rom_table(61583) <= "01110010";
         when 61584 => mw_U_3rom_table(61584) <= "10000101";
         when 61585 => mw_U_3rom_table(61585) <= "11100000";
         when 61586 => mw_U_3rom_table(61586) <= "00011100";
         when 61587 => mw_U_3rom_table(61587) <= "10101101";
         when 61588 => mw_U_3rom_table(61588) <= "01110001";
         when 61589 => mw_U_3rom_table(61589) <= "10000101";
         when 61590 => mw_U_3rom_table(61590) <= "11100000";
         when 61591 => mw_U_3rom_table(61591) <= "00011011";
         when 61592 => mw_U_3rom_table(61592) <= "10101101";
         when 61593 => mw_U_3rom_table(61593) <= "01110000";
         when 61594 => mw_U_3rom_table(61594) <= "10000101";
         when 61595 => mw_U_3rom_table(61595) <= "11100000";
         when 61596 => mw_U_3rom_table(61596) <= "00011010";
         when 61597 => mw_U_3rom_table(61597) <= "10101101";
         when 61598 => mw_U_3rom_table(61598) <= "01101111";
         when 61599 => mw_U_3rom_table(61599) <= "10000101";
         when 61600 => mw_U_3rom_table(61600) <= "00100110";
         when 61601 => mw_U_3rom_table(61601) <= "10101101";
         when 61602 => mw_U_3rom_table(61602) <= "01111011";
         when 61603 => mw_U_3rom_table(61603) <= "10000101";
         when 61604 => mw_U_3rom_table(61604) <= "11100000";
         when 61605 => mw_U_3rom_table(61605) <= "00100101";
         when 61606 => mw_U_3rom_table(61606) <= "10101101";
         when 61607 => mw_U_3rom_table(61607) <= "01111010";
         when 61608 => mw_U_3rom_table(61608) <= "10000101";
         when 61609 => mw_U_3rom_table(61609) <= "11100000";
         when 61610 => mw_U_3rom_table(61610) <= "00100100";
         when 61611 => mw_U_3rom_table(61611) <= "10101101";
         when 61612 => mw_U_3rom_table(61612) <= "01111001";
         when 61613 => mw_U_3rom_table(61613) <= "10000101";
         when 61614 => mw_U_3rom_table(61614) <= "11100000";
         when 61615 => mw_U_3rom_table(61615) <= "00100011";
         when 61616 => mw_U_3rom_table(61616) <= "10101101";
         when 61617 => mw_U_3rom_table(61617) <= "01111000";
         when 61618 => mw_U_3rom_table(61618) <= "10000101";
         when 61619 => mw_U_3rom_table(61619) <= "11100000";
         when 61620 => mw_U_3rom_table(61620) <= "00100010";
         when 61621 => mw_U_3rom_table(61621) <= "10101101";
         when 61622 => mw_U_3rom_table(61622) <= "01110111";
         when 61623 => mw_U_3rom_table(61623) <= "10000101";
         when 61624 => mw_U_3rom_table(61624) <= "11100000";
         when 61625 => mw_U_3rom_table(61625) <= "00100001";
         when 61626 => mw_U_3rom_table(61626) <= "10101101";
         when 61627 => mw_U_3rom_table(61627) <= "01110110";
         when 61628 => mw_U_3rom_table(61628) <= "10000101";
         when 61629 => mw_U_3rom_table(61629) <= "11100000";
         when 61630 => mw_U_3rom_table(61630) <= "00100000";
         when 61631 => mw_U_3rom_table(61631) <= "10101101";
         when 61632 => mw_U_3rom_table(61632) <= "10000101";
         when 61633 => mw_U_3rom_table(61633) <= "11100000";
         when 61634 => mw_U_3rom_table(61634) <= "00101100";
         when 61635 => mw_U_3rom_table(61635) <= "10101101";
         when 61636 => mw_U_3rom_table(61636) <= "10000001";
         when 61637 => mw_U_3rom_table(61637) <= "10000101";
         when 61638 => mw_U_3rom_table(61638) <= "11100000";
         when 61639 => mw_U_3rom_table(61639) <= "00101011";
         when 61640 => mw_U_3rom_table(61640) <= "10101101";
         when 61641 => mw_U_3rom_table(61641) <= "10000000";
         when 61642 => mw_U_3rom_table(61642) <= "10000101";
         when 61643 => mw_U_3rom_table(61643) <= "11100000";
         when 61644 => mw_U_3rom_table(61644) <= "00101010";
         when 61645 => mw_U_3rom_table(61645) <= "10101101";
         when 61646 => mw_U_3rom_table(61646) <= "01111111";
         when 61647 => mw_U_3rom_table(61647) <= "10000101";
         when 61648 => mw_U_3rom_table(61648) <= "11100000";
         when 61649 => mw_U_3rom_table(61649) <= "00101001";
         when 61650 => mw_U_3rom_table(61650) <= "10101101";
         when 61651 => mw_U_3rom_table(61651) <= "01111110";
         when 61652 => mw_U_3rom_table(61652) <= "10000101";
         when 61653 => mw_U_3rom_table(61653) <= "11100000";
         when 61654 => mw_U_3rom_table(61654) <= "00101000";
         when 61655 => mw_U_3rom_table(61655) <= "10101101";
         when 61656 => mw_U_3rom_table(61656) <= "01111101";
         when 61657 => mw_U_3rom_table(61657) <= "10000101";
         when 61658 => mw_U_3rom_table(61658) <= "11100000";
         when 61659 => mw_U_3rom_table(61659) <= "00100111";
         when 61660 => mw_U_3rom_table(61660) <= "10101101";
         when 61661 => mw_U_3rom_table(61661) <= "01111100";
         when 61662 => mw_U_3rom_table(61662) <= "10000101";
         when 61663 => mw_U_3rom_table(61663) <= "11100000";
         when 61664 => mw_U_3rom_table(61664) <= "10101101";
         when 61665 => mw_U_3rom_table(61665) <= "10001000";
         when 61666 => mw_U_3rom_table(61666) <= "10000101";
         when 61667 => mw_U_3rom_table(61667) <= "11100000";
         when 61668 => mw_U_3rom_table(61668) <= "00110010";
         when 61669 => mw_U_3rom_table(61669) <= "10101101";
         when 61670 => mw_U_3rom_table(61670) <= "10000111";
         when 61671 => mw_U_3rom_table(61671) <= "10000101";
         when 61672 => mw_U_3rom_table(61672) <= "11100000";
         when 61673 => mw_U_3rom_table(61673) <= "00110001";
         when 61674 => mw_U_3rom_table(61674) <= "10101101";
         when 61675 => mw_U_3rom_table(61675) <= "10000110";
         when 61676 => mw_U_3rom_table(61676) <= "10000101";
         when 61677 => mw_U_3rom_table(61677) <= "11100000";
         when 61678 => mw_U_3rom_table(61678) <= "00110000";
         when 61679 => mw_U_3rom_table(61679) <= "10101101";
         when 61680 => mw_U_3rom_table(61680) <= "10000101";
         when 61681 => mw_U_3rom_table(61681) <= "10000101";
         when 61682 => mw_U_3rom_table(61682) <= "11100000";
         when 61683 => mw_U_3rom_table(61683) <= "00101111";
         when 61684 => mw_U_3rom_table(61684) <= "10101101";
         when 61685 => mw_U_3rom_table(61685) <= "10000100";
         when 61686 => mw_U_3rom_table(61686) <= "10000101";
         when 61687 => mw_U_3rom_table(61687) <= "11100000";
         when 61688 => mw_U_3rom_table(61688) <= "00101110";
         when 61689 => mw_U_3rom_table(61689) <= "10101101";
         when 61690 => mw_U_3rom_table(61690) <= "10000011";
         when 61691 => mw_U_3rom_table(61691) <= "10000101";
         when 61692 => mw_U_3rom_table(61692) <= "11100000";
         when 61693 => mw_U_3rom_table(61693) <= "00101101";
         when 61694 => mw_U_3rom_table(61694) <= "10101101";
         when 61695 => mw_U_3rom_table(61695) <= "10000010";
         when 61696 => mw_U_3rom_table(61696) <= "11100000";
         when 61697 => mw_U_3rom_table(61697) <= "00111001";
         when 61698 => mw_U_3rom_table(61698) <= "10101101";
         when 61699 => mw_U_3rom_table(61699) <= "10001110";
         when 61700 => mw_U_3rom_table(61700) <= "10000101";
         when 61701 => mw_U_3rom_table(61701) <= "11100000";
         when 61702 => mw_U_3rom_table(61702) <= "00111000";
         when 61703 => mw_U_3rom_table(61703) <= "10101101";
         when 61704 => mw_U_3rom_table(61704) <= "10001101";
         when 61705 => mw_U_3rom_table(61705) <= "10000101";
         when 61706 => mw_U_3rom_table(61706) <= "11100000";
         when 61707 => mw_U_3rom_table(61707) <= "00110111";
         when 61708 => mw_U_3rom_table(61708) <= "10101101";
         when 61709 => mw_U_3rom_table(61709) <= "10001100";
         when 61710 => mw_U_3rom_table(61710) <= "10000101";
         when 61711 => mw_U_3rom_table(61711) <= "11100000";
         when 61712 => mw_U_3rom_table(61712) <= "00110110";
         when 61713 => mw_U_3rom_table(61713) <= "10101101";
         when 61714 => mw_U_3rom_table(61714) <= "10001011";
         when 61715 => mw_U_3rom_table(61715) <= "10000101";
         when 61716 => mw_U_3rom_table(61716) <= "11100000";
         when 61717 => mw_U_3rom_table(61717) <= "00110101";
         when 61718 => mw_U_3rom_table(61718) <= "10101101";
         when 61719 => mw_U_3rom_table(61719) <= "10001010";
         when 61720 => mw_U_3rom_table(61720) <= "10000101";
         when 61721 => mw_U_3rom_table(61721) <= "11100000";
         when 61722 => mw_U_3rom_table(61722) <= "00110100";
         when 61723 => mw_U_3rom_table(61723) <= "10101101";
         when 61724 => mw_U_3rom_table(61724) <= "10001001";
         when 61725 => mw_U_3rom_table(61725) <= "10000101";
         when 61726 => mw_U_3rom_table(61726) <= "11100000";
         when 61727 => mw_U_3rom_table(61727) <= "00110011";
         when 61728 => mw_U_3rom_table(61728) <= "10010101";
         when 61729 => mw_U_3rom_table(61729) <= "10000101";
         when 61730 => mw_U_3rom_table(61730) <= "11100000";
         when 61731 => mw_U_3rom_table(61731) <= "00111111";
         when 61732 => mw_U_3rom_table(61732) <= "10101101";
         when 61733 => mw_U_3rom_table(61733) <= "10010100";
         when 61734 => mw_U_3rom_table(61734) <= "10000101";
         when 61735 => mw_U_3rom_table(61735) <= "11100000";
         when 61736 => mw_U_3rom_table(61736) <= "00111110";
         when 61737 => mw_U_3rom_table(61737) <= "10101101";
         when 61738 => mw_U_3rom_table(61738) <= "10010011";
         when 61739 => mw_U_3rom_table(61739) <= "10000101";
         when 61740 => mw_U_3rom_table(61740) <= "11100000";
         when 61741 => mw_U_3rom_table(61741) <= "00111101";
         when 61742 => mw_U_3rom_table(61742) <= "10101101";
         when 61743 => mw_U_3rom_table(61743) <= "10010010";
         when 61744 => mw_U_3rom_table(61744) <= "10000101";
         when 61745 => mw_U_3rom_table(61745) <= "11100000";
         when 61746 => mw_U_3rom_table(61746) <= "00111100";
         when 61747 => mw_U_3rom_table(61747) <= "10101101";
         when 61748 => mw_U_3rom_table(61748) <= "10010001";
         when 61749 => mw_U_3rom_table(61749) <= "10000101";
         when 61750 => mw_U_3rom_table(61750) <= "11100000";
         when 61751 => mw_U_3rom_table(61751) <= "00111011";
         when 61752 => mw_U_3rom_table(61752) <= "10101101";
         when 61753 => mw_U_3rom_table(61753) <= "10010000";
         when 61754 => mw_U_3rom_table(61754) <= "10000101";
         when 61755 => mw_U_3rom_table(61755) <= "11100000";
         when 61756 => mw_U_3rom_table(61756) <= "00111010";
         when 61757 => mw_U_3rom_table(61757) <= "10101101";
         when 61758 => mw_U_3rom_table(61758) <= "10001111";
         when 61759 => mw_U_3rom_table(61759) <= "10000101";
         when 61760 => mw_U_3rom_table(61760) <= "01000110";
         when 61761 => mw_U_3rom_table(61761) <= "10101101";
         when 61762 => mw_U_3rom_table(61762) <= "10011011";
         when 61763 => mw_U_3rom_table(61763) <= "10000101";
         when 61764 => mw_U_3rom_table(61764) <= "11100000";
         when 61765 => mw_U_3rom_table(61765) <= "01000101";
         when 61766 => mw_U_3rom_table(61766) <= "10101101";
         when 61767 => mw_U_3rom_table(61767) <= "10011010";
         when 61768 => mw_U_3rom_table(61768) <= "10000101";
         when 61769 => mw_U_3rom_table(61769) <= "11100000";
         when 61770 => mw_U_3rom_table(61770) <= "01000100";
         when 61771 => mw_U_3rom_table(61771) <= "10101101";
         when 61772 => mw_U_3rom_table(61772) <= "10011001";
         when 61773 => mw_U_3rom_table(61773) <= "10000101";
         when 61774 => mw_U_3rom_table(61774) <= "11100000";
         when 61775 => mw_U_3rom_table(61775) <= "01000011";
         when 61776 => mw_U_3rom_table(61776) <= "10101101";
         when 61777 => mw_U_3rom_table(61777) <= "10011000";
         when 61778 => mw_U_3rom_table(61778) <= "10000101";
         when 61779 => mw_U_3rom_table(61779) <= "11100000";
         when 61780 => mw_U_3rom_table(61780) <= "01000010";
         when 61781 => mw_U_3rom_table(61781) <= "10101101";
         when 61782 => mw_U_3rom_table(61782) <= "10010111";
         when 61783 => mw_U_3rom_table(61783) <= "10000101";
         when 61784 => mw_U_3rom_table(61784) <= "11100000";
         when 61785 => mw_U_3rom_table(61785) <= "01000001";
         when 61786 => mw_U_3rom_table(61786) <= "10101101";
         when 61787 => mw_U_3rom_table(61787) <= "10010110";
         when 61788 => mw_U_3rom_table(61788) <= "10000101";
         when 61789 => mw_U_3rom_table(61789) <= "11100000";
         when 61790 => mw_U_3rom_table(61790) <= "01000000";
         when 61791 => mw_U_3rom_table(61791) <= "10101101";
         when 61792 => mw_U_3rom_table(61792) <= "00110101";
         when 61793 => mw_U_3rom_table(61793) <= "01010110";
         when 61794 => mw_U_3rom_table(61794) <= "00110010";
         when 61795 => mw_U_3rom_table(61795) <= "01010110";
         when 61796 => mw_U_3rom_table(61796) <= "00110001";
         when 61797 => mw_U_3rom_table(61797) <= "01010110";
         when 61798 => mw_U_3rom_table(61798) <= "00100001";
         when 61799 => mw_U_3rom_table(61799) <= "01010110";
         when 61800 => mw_U_3rom_table(61800) <= "00101001";
         when 61801 => mw_U_3rom_table(61801) <= "11110001";
         when 61802 => mw_U_3rom_table(61802) <= "01100011";
         when 61803 => mw_U_3rom_table(61803) <= "01101101";
         when 61804 => mw_U_3rom_table(61804) <= "01010110";
         when 61805 => mw_U_3rom_table(61805) <= "01100101";
         when 61806 => mw_U_3rom_table(61806) <= "00000000";
         when 61807 => mw_U_3rom_table(61807) <= "01010110";
         when 61808 => mw_U_3rom_table(61808) <= "01111001";
         when 61809 => mw_U_3rom_table(61809) <= "01010110";
         when 61810 => mw_U_3rom_table(61810) <= "01110101";
         when 61811 => mw_U_3rom_table(61811) <= "01010110";
         when 61812 => mw_U_3rom_table(61812) <= "01110010";
         when 61813 => mw_U_3rom_table(61813) <= "01010110";
         when 61814 => mw_U_3rom_table(61814) <= "01110010";
         when 61815 => mw_U_3rom_table(61815) <= "01010110";
         when 61816 => mw_U_3rom_table(61816) <= "01110001";
         when 61817 => mw_U_3rom_table(61817) <= "01010110";
         when 61818 => mw_U_3rom_table(61818) <= "01100001";
         when 61819 => mw_U_3rom_table(61819) <= "01010110";
         when 61820 => mw_U_3rom_table(61820) <= "01101001";
         when 61821 => mw_U_3rom_table(61821) <= "10011100";
         when 61822 => mw_U_3rom_table(61822) <= "10000101";
         when 61823 => mw_U_3rom_table(61823) <= "11100000";
         when 61824 => mw_U_3rom_table(61824) <= "11101010";
         when 61825 => mw_U_3rom_table(61825) <= "00000001";
         when 61826 => mw_U_3rom_table(61826) <= "00010000";
         when 61827 => mw_U_3rom_table(61827) <= "11101010";
         when 61828 => mw_U_3rom_table(61828) <= "00000001";
         when 61829 => mw_U_3rom_table(61829) <= "00110000";
         when 61830 => mw_U_3rom_table(61830) <= "11101010";
         when 61831 => mw_U_3rom_table(61831) <= "00000001";
         when 61832 => mw_U_3rom_table(61832) <= "11010000";
         when 61833 => mw_U_3rom_table(61833) <= "11101010";
         when 61834 => mw_U_3rom_table(61834) <= "00000001";
         when 61835 => mw_U_3rom_table(61835) <= "11110000";
         when 61836 => mw_U_3rom_table(61836) <= "11101010";
         when 61837 => mw_U_3rom_table(61837) <= "00000001";
         when 61838 => mw_U_3rom_table(61838) <= "10110000";
         when 61839 => mw_U_3rom_table(61839) <= "11101010";
         when 61840 => mw_U_3rom_table(61840) <= "00000001";
         when 61841 => mw_U_3rom_table(61841) <= "10010000";
         when 61842 => mw_U_3rom_table(61842) <= "01010110";
         when 61843 => mw_U_3rom_table(61843) <= "00000110";
         when 61844 => mw_U_3rom_table(61844) <= "01010110";
         when 61845 => mw_U_3rom_table(61845) <= "00010110";
         when 61846 => mw_U_3rom_table(61846) <= "00001010";
         when 61847 => mw_U_3rom_table(61847) <= "11110001";
         when 61848 => mw_U_3rom_table(61848) <= "01100011";
         when 61849 => mw_U_3rom_table(61849) <= "00101101";
         when 61850 => mw_U_3rom_table(61850) <= "01010110";
         when 61851 => mw_U_3rom_table(61851) <= "00100101";
         when 61852 => mw_U_3rom_table(61852) <= "00000000";
         when 61853 => mw_U_3rom_table(61853) <= "01010110";
         when 61854 => mw_U_3rom_table(61854) <= "00111001";
         when 61855 => mw_U_3rom_table(61855) <= "01010110";
         when 61856 => mw_U_3rom_table(61856) <= "01010110";
         when 61857 => mw_U_3rom_table(61857) <= "11011001";
         when 61858 => mw_U_3rom_table(61858) <= "01010110";
         when 61859 => mw_U_3rom_table(61859) <= "11010101";
         when 61860 => mw_U_3rom_table(61860) <= "01010110";
         when 61861 => mw_U_3rom_table(61861) <= "11010010";
         when 61862 => mw_U_3rom_table(61862) <= "01010110";
         when 61863 => mw_U_3rom_table(61863) <= "11010001";
         when 61864 => mw_U_3rom_table(61864) <= "01010110";
         when 61865 => mw_U_3rom_table(61865) <= "11000001";
         when 61866 => mw_U_3rom_table(61866) <= "01010110";
         when 61867 => mw_U_3rom_table(61867) <= "11001001";
         when 61868 => mw_U_3rom_table(61868) <= "10111000";
         when 61869 => mw_U_3rom_table(61869) <= "01011000";
         when 61870 => mw_U_3rom_table(61870) <= "11011000";
         when 61871 => mw_U_3rom_table(61871) <= "00011000";
         when 61872 => mw_U_3rom_table(61872) <= "00000000";
         when 61873 => mw_U_3rom_table(61873) <= "11110001";
         when 61874 => mw_U_3rom_table(61874) <= "01100011";
         when 61875 => mw_U_3rom_table(61875) <= "00101100";
         when 61876 => mw_U_3rom_table(61876) <= "01010110";
         when 61877 => mw_U_3rom_table(61877) <= "00100100";
         when 61878 => mw_U_3rom_table(61878) <= "01010110";
         when 61879 => mw_U_3rom_table(61879) <= "00110100";
         when 61880 => mw_U_3rom_table(61880) <= "01010110";
         when 61881 => mw_U_3rom_table(61881) <= "10001001";
         when 61882 => mw_U_3rom_table(61882) <= "11101010";
         when 61883 => mw_U_3rom_table(61883) <= "00000001";
         when 61884 => mw_U_3rom_table(61884) <= "01110000";
         when 61885 => mw_U_3rom_table(61885) <= "11101010";
         when 61886 => mw_U_3rom_table(61886) <= "00000001";
         when 61887 => mw_U_3rom_table(61887) <= "01010000";
         when 61888 => mw_U_3rom_table(61888) <= "11001010";
         when 61889 => mw_U_3rom_table(61889) <= "11110001";
         when 61890 => mw_U_3rom_table(61890) <= "01100011";
         when 61891 => mw_U_3rom_table(61891) <= "11001110";
         when 61892 => mw_U_3rom_table(61892) <= "01010110";
         when 61893 => mw_U_3rom_table(61893) <= "11000110";
         when 61894 => mw_U_3rom_table(61894) <= "11110001";
         when 61895 => mw_U_3rom_table(61895) <= "01100011";
         when 61896 => mw_U_3rom_table(61896) <= "11011110";
         when 61897 => mw_U_3rom_table(61897) <= "01010110";
         when 61898 => mw_U_3rom_table(61898) <= "11010110";
         when 61899 => mw_U_3rom_table(61899) <= "00111010";
         when 61900 => mw_U_3rom_table(61900) <= "11110001";
         when 61901 => mw_U_3rom_table(61901) <= "01100011";
         when 61902 => mw_U_3rom_table(61902) <= "11001100";
         when 61903 => mw_U_3rom_table(61903) <= "01010110";
         when 61904 => mw_U_3rom_table(61904) <= "11000100";
         when 61905 => mw_U_3rom_table(61905) <= "01010110";
         when 61906 => mw_U_3rom_table(61906) <= "11000000";
         when 61907 => mw_U_3rom_table(61907) <= "11110001";
         when 61908 => mw_U_3rom_table(61908) <= "01100011";
         when 61909 => mw_U_3rom_table(61909) <= "11101100";
         when 61910 => mw_U_3rom_table(61910) <= "01010110";
         when 61911 => mw_U_3rom_table(61911) <= "11100100";
         when 61912 => mw_U_3rom_table(61912) <= "01010110";
         when 61913 => mw_U_3rom_table(61913) <= "11100000";
         when 61914 => mw_U_3rom_table(61914) <= "11110001";
         when 61915 => mw_U_3rom_table(61915) <= "01100011";
         when 61916 => mw_U_3rom_table(61916) <= "11001101";
         when 61917 => mw_U_3rom_table(61917) <= "01010110";
         when 61918 => mw_U_3rom_table(61918) <= "11000101";
         when 61919 => mw_U_3rom_table(61919) <= "00000000";
         when 61920 => mw_U_3rom_table(61920) <= "11001000";
         when 61921 => mw_U_3rom_table(61921) <= "11101000";
         when 61922 => mw_U_3rom_table(61922) <= "11110001";
         when 61923 => mw_U_3rom_table(61923) <= "01100011";
         when 61924 => mw_U_3rom_table(61924) <= "11101110";
         when 61925 => mw_U_3rom_table(61925) <= "01010110";
         when 61926 => mw_U_3rom_table(61926) <= "11100110";
         when 61927 => mw_U_3rom_table(61927) <= "11110001";
         when 61928 => mw_U_3rom_table(61928) <= "01100011";
         when 61929 => mw_U_3rom_table(61929) <= "11111110";
         when 61930 => mw_U_3rom_table(61930) <= "01010110";
         when 61931 => mw_U_3rom_table(61931) <= "11110110";
         when 61932 => mw_U_3rom_table(61932) <= "00011010";
         when 61933 => mw_U_3rom_table(61933) <= "11110001";
         when 61934 => mw_U_3rom_table(61934) <= "01100011";
         when 61935 => mw_U_3rom_table(61935) <= "01001101";
         when 61936 => mw_U_3rom_table(61936) <= "01010110";
         when 61937 => mw_U_3rom_table(61937) <= "01000101";
         when 61938 => mw_U_3rom_table(61938) <= "00000000";
         when 61939 => mw_U_3rom_table(61939) <= "01010110";
         when 61940 => mw_U_3rom_table(61940) <= "01011001";
         when 61941 => mw_U_3rom_table(61941) <= "01010110";
         when 61942 => mw_U_3rom_table(61942) <= "01010101";
         when 61943 => mw_U_3rom_table(61943) <= "01010110";
         when 61944 => mw_U_3rom_table(61944) <= "01010010";
         when 61945 => mw_U_3rom_table(61945) <= "01010110";
         when 61946 => mw_U_3rom_table(61946) <= "01010001";
         when 61947 => mw_U_3rom_table(61947) <= "01010110";
         when 61948 => mw_U_3rom_table(61948) <= "01000001";
         when 61949 => mw_U_3rom_table(61949) <= "01010110";
         when 61950 => mw_U_3rom_table(61950) <= "01001001";
         when 61951 => mw_U_3rom_table(61951) <= "10001000";
         when 61952 => mw_U_3rom_table(61952) <= "01100011";
         when 61953 => mw_U_3rom_table(61953) <= "10101101";
         when 61954 => mw_U_3rom_table(61954) <= "01010110";
         when 61955 => mw_U_3rom_table(61955) <= "10100101";
         when 61956 => mw_U_3rom_table(61956) <= "00000000";
         when 61957 => mw_U_3rom_table(61957) <= "01010110";
         when 61958 => mw_U_3rom_table(61958) <= "10111001";
         when 61959 => mw_U_3rom_table(61959) <= "01010110";
         when 61960 => mw_U_3rom_table(61960) <= "10110101";
         when 61961 => mw_U_3rom_table(61961) <= "01010110";
         when 61962 => mw_U_3rom_table(61962) <= "10110010";
         when 61963 => mw_U_3rom_table(61963) <= "01010110";
         when 61964 => mw_U_3rom_table(61964) <= "10110001";
         when 61965 => mw_U_3rom_table(61965) <= "01010110";
         when 61966 => mw_U_3rom_table(61966) <= "10100001";
         when 61967 => mw_U_3rom_table(61967) <= "01010110";
         when 61968 => mw_U_3rom_table(61968) <= "10101001";
         when 61969 => mw_U_3rom_table(61969) <= "11110001";
         when 61970 => mw_U_3rom_table(61970) <= "01100011";
         when 61971 => mw_U_3rom_table(61971) <= "00100000";
         when 61972 => mw_U_3rom_table(61972) <= "00000000";
         when 61973 => mw_U_3rom_table(61973) <= "01010110";
         when 61974 => mw_U_3rom_table(61974) <= "00100000";
         when 61975 => mw_U_3rom_table(61975) <= "00000000";
         when 61976 => mw_U_3rom_table(61976) <= "01010110";
         when 61977 => mw_U_3rom_table(61977) <= "01001100";
         when 61978 => mw_U_3rom_table(61978) <= "00000000";
         when 61979 => mw_U_3rom_table(61979) <= "01010110";
         when 61980 => mw_U_3rom_table(61980) <= "01101100";
         when 61981 => mw_U_3rom_table(61981) <= "00000000";
         when 61982 => mw_U_3rom_table(61982) <= "01010110";
         when 61983 => mw_U_3rom_table(61983) <= "01111100";
         when 61984 => mw_U_3rom_table(61984) <= "01010110";
         when 61985 => mw_U_3rom_table(61985) <= "00000001";
         when 61986 => mw_U_3rom_table(61986) <= "01010110";
         when 61987 => mw_U_3rom_table(61987) <= "00001001";
         when 61988 => mw_U_3rom_table(61988) <= "11101010";
         when 61989 => mw_U_3rom_table(61989) <= "11110001";
         when 61990 => mw_U_3rom_table(61990) <= "01100011";
         when 61991 => mw_U_3rom_table(61991) <= "01001110";
         when 61992 => mw_U_3rom_table(61992) <= "01010110";
         when 61993 => mw_U_3rom_table(61993) <= "01000110";
         when 61994 => mw_U_3rom_table(61994) <= "01010110";
         when 61995 => mw_U_3rom_table(61995) <= "01010110";
         when 61996 => mw_U_3rom_table(61996) <= "01001010";
         when 61997 => mw_U_3rom_table(61997) <= "11110001";
         when 61998 => mw_U_3rom_table(61998) <= "01100011";
         when 61999 => mw_U_3rom_table(61999) <= "10101100";
         when 62000 => mw_U_3rom_table(62000) <= "01010110";
         when 62001 => mw_U_3rom_table(62001) <= "10100100";
         when 62002 => mw_U_3rom_table(62002) <= "01010110";
         when 62003 => mw_U_3rom_table(62003) <= "10110100";
         when 62004 => mw_U_3rom_table(62004) <= "01010110";
         when 62005 => mw_U_3rom_table(62005) <= "10100000";
         when 62006 => mw_U_3rom_table(62006) <= "11110001";
         when 62007 => mw_U_3rom_table(62007) <= "01100011";
         when 62008 => mw_U_3rom_table(62008) <= "10101110";
         when 62009 => mw_U_3rom_table(62009) <= "01010110";
         when 62010 => mw_U_3rom_table(62010) <= "10100110";
         when 62011 => mw_U_3rom_table(62011) <= "01010110";
         when 62012 => mw_U_3rom_table(62012) <= "10110110";
         when 62013 => mw_U_3rom_table(62013) <= "01010110";
         when 62014 => mw_U_3rom_table(62014) <= "10100010";
         when 62015 => mw_U_3rom_table(62015) <= "11110001";
         when 62016 => mw_U_3rom_table(62016) <= "11110001";
         when 62017 => mw_U_3rom_table(62017) <= "01100011";
         when 62018 => mw_U_3rom_table(62018) <= "01111110";
         when 62019 => mw_U_3rom_table(62019) <= "01010110";
         when 62020 => mw_U_3rom_table(62020) <= "01110110";
         when 62021 => mw_U_3rom_table(62021) <= "01101010";
         when 62022 => mw_U_3rom_table(62022) <= "11110001";
         when 62023 => mw_U_3rom_table(62023) <= "01100011";
         when 62024 => mw_U_3rom_table(62024) <= "00101110";
         when 62025 => mw_U_3rom_table(62025) <= "01010110";
         when 62026 => mw_U_3rom_table(62026) <= "00100110";
         when 62027 => mw_U_3rom_table(62027) <= "01010110";
         when 62028 => mw_U_3rom_table(62028) <= "00110110";
         when 62029 => mw_U_3rom_table(62029) <= "00101010";
         when 62030 => mw_U_3rom_table(62030) <= "00101000";
         when 62031 => mw_U_3rom_table(62031) <= "01101000";
         when 62032 => mw_U_3rom_table(62032) <= "00001000";
         when 62033 => mw_U_3rom_table(62033) <= "01001000";
         when 62034 => mw_U_3rom_table(62034) <= "11110001";
         when 62035 => mw_U_3rom_table(62035) <= "01100011";
         when 62036 => mw_U_3rom_table(62036) <= "00001101";
         when 62037 => mw_U_3rom_table(62037) <= "01010110";
         when 62038 => mw_U_3rom_table(62038) <= "00000101";
         when 62039 => mw_U_3rom_table(62039) <= "00000000";
         when 62040 => mw_U_3rom_table(62040) <= "01010110";
         when 62041 => mw_U_3rom_table(62041) <= "00011001";
         when 62042 => mw_U_3rom_table(62042) <= "01010110";
         when 62043 => mw_U_3rom_table(62043) <= "00010101";
         when 62044 => mw_U_3rom_table(62044) <= "01010110";
         when 62045 => mw_U_3rom_table(62045) <= "00010010";
         when 62046 => mw_U_3rom_table(62046) <= "01010110";
         when 62047 => mw_U_3rom_table(62047) <= "00010001";
         when 62048 => mw_U_3rom_table(62048) <= "01010110";
         when 62049 => mw_U_3rom_table(62049) <= "10010001";
         when 62050 => mw_U_3rom_table(62050) <= "01010110";
         when 62051 => mw_U_3rom_table(62051) <= "10000001";
         when 62052 => mw_U_3rom_table(62052) <= "01111000";
         when 62053 => mw_U_3rom_table(62053) <= "11111000";
         when 62054 => mw_U_3rom_table(62054) <= "00111000";
         when 62055 => mw_U_3rom_table(62055) <= "11110001";
         when 62056 => mw_U_3rom_table(62056) <= "01100011";
         when 62057 => mw_U_3rom_table(62057) <= "11101101";
         when 62058 => mw_U_3rom_table(62058) <= "01010110";
         when 62059 => mw_U_3rom_table(62059) <= "11100101";
         when 62060 => mw_U_3rom_table(62060) <= "00000000";
         when 62061 => mw_U_3rom_table(62061) <= "01010110";
         when 62062 => mw_U_3rom_table(62062) <= "11111001";
         when 62063 => mw_U_3rom_table(62063) <= "01010110";
         when 62064 => mw_U_3rom_table(62064) <= "11110101";
         when 62065 => mw_U_3rom_table(62065) <= "01010110";
         when 62066 => mw_U_3rom_table(62066) <= "11110010";
         when 62067 => mw_U_3rom_table(62067) <= "01010110";
         when 62068 => mw_U_3rom_table(62068) <= "11110001";
         when 62069 => mw_U_3rom_table(62069) <= "01010110";
         when 62070 => mw_U_3rom_table(62070) <= "11100001";
         when 62071 => mw_U_3rom_table(62071) <= "01010110";
         when 62072 => mw_U_3rom_table(62072) <= "11101001";
         when 62073 => mw_U_3rom_table(62073) <= "01100000";
         when 62074 => mw_U_3rom_table(62074) <= "01000000";
         when 62075 => mw_U_3rom_table(62075) <= "11110001";
         when 62076 => mw_U_3rom_table(62076) <= "01100011";
         when 62077 => mw_U_3rom_table(62077) <= "01101110";
         when 62078 => mw_U_3rom_table(62078) <= "01010110";
         when 62079 => mw_U_3rom_table(62079) <= "01100110";
         when 62080 => mw_U_3rom_table(62080) <= "10011000";
         when 62081 => mw_U_3rom_table(62081) <= "10011010";
         when 62082 => mw_U_3rom_table(62082) <= "10001010";
         when 62083 => mw_U_3rom_table(62083) <= "10111010";
         when 62084 => mw_U_3rom_table(62084) <= "10101000";
         when 62085 => mw_U_3rom_table(62085) <= "10101010";
         when 62086 => mw_U_3rom_table(62086) <= "11110001";
         when 62087 => mw_U_3rom_table(62087) <= "01100011";
         when 62088 => mw_U_3rom_table(62088) <= "10001100";
         when 62089 => mw_U_3rom_table(62089) <= "01010110";
         when 62090 => mw_U_3rom_table(62090) <= "10000100";
         when 62091 => mw_U_3rom_table(62091) <= "01010110";
         when 62092 => mw_U_3rom_table(62092) <= "10010100";
         when 62093 => mw_U_3rom_table(62093) <= "11110001";
         when 62094 => mw_U_3rom_table(62094) <= "01100011";
         when 62095 => mw_U_3rom_table(62095) <= "10001110";
         when 62096 => mw_U_3rom_table(62096) <= "01010110";
         when 62097 => mw_U_3rom_table(62097) <= "10000110";
         when 62098 => mw_U_3rom_table(62098) <= "01010110";
         when 62099 => mw_U_3rom_table(62099) <= "10010110";
         when 62100 => mw_U_3rom_table(62100) <= "11110001";
         when 62101 => mw_U_3rom_table(62101) <= "01100011";
         when 62102 => mw_U_3rom_table(62102) <= "10001101";
         when 62103 => mw_U_3rom_table(62103) <= "01010110";
         when 62104 => mw_U_3rom_table(62104) <= "10000101";
         when 62105 => mw_U_3rom_table(62105) <= "00000000";
         when 62106 => mw_U_3rom_table(62106) <= "01010110";
         when 62107 => mw_U_3rom_table(62107) <= "10011001";
         when 62108 => mw_U_3rom_table(62108) <= "01010110";
         when 62109 => mw_U_3rom_table(62109) <= "10010101";
         when 62110 => mw_U_3rom_table(62110) <= "01010110";
         when 62111 => mw_U_3rom_table(62111) <= "10010010";
         when 62112 => mw_U_3rom_table(62112) <= "11100010";
         when 62113 => mw_U_3rom_table(62113) <= "01010110";
         when 62114 => mw_U_3rom_table(62114) <= "10011111";
         when 62115 => mw_U_3rom_table(62115) <= "11100101";
         when 62116 => mw_U_3rom_table(62116) <= "01010110";
         when 62117 => mw_U_3rom_table(62117) <= "10001111";
         when 62118 => mw_U_3rom_table(62118) <= "11101000";
         when 62119 => mw_U_3rom_table(62119) <= "01010110";
         when 62120 => mw_U_3rom_table(62120) <= "01111111";
         when 62121 => mw_U_3rom_table(62121) <= "11101011";
         when 62122 => mw_U_3rom_table(62122) <= "01010110";
         when 62123 => mw_U_3rom_table(62123) <= "01101111";
         when 62124 => mw_U_3rom_table(62124) <= "11101110";
         when 62125 => mw_U_3rom_table(62125) <= "01010110";
         when 62126 => mw_U_3rom_table(62126) <= "01011111";
         when 62127 => mw_U_3rom_table(62127) <= "11110001";
         when 62128 => mw_U_3rom_table(62128) <= "01010110";
         when 62129 => mw_U_3rom_table(62129) <= "01001111";
         when 62130 => mw_U_3rom_table(62130) <= "11110100";
         when 62131 => mw_U_3rom_table(62131) <= "01010110";
         when 62132 => mw_U_3rom_table(62132) <= "00111111";
         when 62133 => mw_U_3rom_table(62133) <= "11110111";
         when 62134 => mw_U_3rom_table(62134) <= "01010110";
         when 62135 => mw_U_3rom_table(62135) <= "00101111";
         when 62136 => mw_U_3rom_table(62136) <= "11111010";
         when 62137 => mw_U_3rom_table(62137) <= "01010110";
         when 62138 => mw_U_3rom_table(62138) <= "00011111";
         when 62139 => mw_U_3rom_table(62139) <= "11111101";
         when 62140 => mw_U_3rom_table(62140) <= "01010110";
         when 62141 => mw_U_3rom_table(62141) <= "00001111";
         when 62142 => mw_U_3rom_table(62142) <= "00000000";
         when 62143 => mw_U_3rom_table(62143) <= "10000000";
         when 62144 => mw_U_3rom_table(62144) <= "01000111";
         when 62145 => mw_U_3rom_table(62145) <= "01010110";
         when 62146 => mw_U_3rom_table(62146) <= "00110111";
         when 62147 => mw_U_3rom_table(62147) <= "01010110";
         when 62148 => mw_U_3rom_table(62148) <= "00100111";
         when 62149 => mw_U_3rom_table(62149) <= "01010110";
         when 62150 => mw_U_3rom_table(62150) <= "00010111";
         when 62151 => mw_U_3rom_table(62151) <= "01010110";
         when 62152 => mw_U_3rom_table(62152) <= "00000111";
         when 62153 => mw_U_3rom_table(62153) <= "01111010";
         when 62154 => mw_U_3rom_table(62154) <= "11111010";
         when 62155 => mw_U_3rom_table(62155) <= "01011010";
         when 62156 => mw_U_3rom_table(62156) <= "11011010";
         when 62157 => mw_U_3rom_table(62157) <= "00000010";
         when 62158 => mw_U_3rom_table(62158) <= "11010000";
         when 62159 => mw_U_3rom_table(62159) <= "01010110";
         when 62160 => mw_U_3rom_table(62160) <= "11111111";
         when 62161 => mw_U_3rom_table(62161) <= "11010011";
         when 62162 => mw_U_3rom_table(62162) <= "01010110";
         when 62163 => mw_U_3rom_table(62163) <= "11101111";
         when 62164 => mw_U_3rom_table(62164) <= "11010110";
         when 62165 => mw_U_3rom_table(62165) <= "01010110";
         when 62166 => mw_U_3rom_table(62166) <= "11011111";
         when 62167 => mw_U_3rom_table(62167) <= "11011001";
         when 62168 => mw_U_3rom_table(62168) <= "01010110";
         when 62169 => mw_U_3rom_table(62169) <= "11001111";
         when 62170 => mw_U_3rom_table(62170) <= "11011100";
         when 62171 => mw_U_3rom_table(62171) <= "01010110";
         when 62172 => mw_U_3rom_table(62172) <= "10111111";
         when 62173 => mw_U_3rom_table(62173) <= "11011111";
         when 62174 => mw_U_3rom_table(62174) <= "01010110";
         when 62175 => mw_U_3rom_table(62175) <= "10101111";
         when 62176 => mw_U_3rom_table(62176) <= "01010110";
         when 62177 => mw_U_3rom_table(62177) <= "00010100";
         when 62178 => mw_U_3rom_table(62178) <= "11110001";
         when 62179 => mw_U_3rom_table(62179) <= "01100011";
         when 62180 => mw_U_3rom_table(62180) <= "10011100";
         when 62181 => mw_U_3rom_table(62181) <= "01010110";
         when 62182 => mw_U_3rom_table(62182) <= "01100100";
         when 62183 => mw_U_3rom_table(62183) <= "01010110";
         when 62184 => mw_U_3rom_table(62184) <= "01110100";
         when 62185 => mw_U_3rom_table(62185) <= "01010110";
         when 62186 => mw_U_3rom_table(62186) <= "11110111";
         when 62187 => mw_U_3rom_table(62187) <= "01010110";
         when 62188 => mw_U_3rom_table(62188) <= "11100111";
         when 62189 => mw_U_3rom_table(62189) <= "01010110";
         when 62190 => mw_U_3rom_table(62190) <= "11010111";
         when 62191 => mw_U_3rom_table(62191) <= "01010110";
         when 62192 => mw_U_3rom_table(62192) <= "11000111";
         when 62193 => mw_U_3rom_table(62193) <= "01010110";
         when 62194 => mw_U_3rom_table(62194) <= "10110111";
         when 62195 => mw_U_3rom_table(62195) <= "01010110";
         when 62196 => mw_U_3rom_table(62196) <= "10100111";
         when 62197 => mw_U_3rom_table(62197) <= "01010110";
         when 62198 => mw_U_3rom_table(62198) <= "10010111";
         when 62199 => mw_U_3rom_table(62199) <= "01010110";
         when 62200 => mw_U_3rom_table(62200) <= "10000111";
         when 62201 => mw_U_3rom_table(62201) <= "01010110";
         when 62202 => mw_U_3rom_table(62202) <= "01110111";
         when 62203 => mw_U_3rom_table(62203) <= "01010110";
         when 62204 => mw_U_3rom_table(62204) <= "01100111";
         when 62205 => mw_U_3rom_table(62205) <= "01010110";
         when 62206 => mw_U_3rom_table(62206) <= "01010111";
         when 62207 => mw_U_3rom_table(62207) <= "01010110";
         when 62208 => mw_U_3rom_table(62208) <= "11111111";
         when 62209 => mw_U_3rom_table(62209) <= "11111111";
         when 62210 => mw_U_3rom_table(62210) <= "11111111";
         when 62211 => mw_U_3rom_table(62211) <= "11111111";
         when 62212 => mw_U_3rom_table(62212) <= "11111111";
         when 62213 => mw_U_3rom_table(62213) <= "11111111";
         when 62214 => mw_U_3rom_table(62214) <= "11111111";
         when 62215 => mw_U_3rom_table(62215) <= "11111111";
         when 62216 => mw_U_3rom_table(62216) <= "11111111";
         when 62217 => mw_U_3rom_table(62217) <= "11111111";
         when 62218 => mw_U_3rom_table(62218) <= "11111111";
         when 62219 => mw_U_3rom_table(62219) <= "11111111";
         when 62220 => mw_U_3rom_table(62220) <= "11111111";
         when 62221 => mw_U_3rom_table(62221) <= "11111111";
         when 62222 => mw_U_3rom_table(62222) <= "11111111";
         when 62223 => mw_U_3rom_table(62223) <= "11111111";
         when 62224 => mw_U_3rom_table(62224) <= "11111111";
         when 62225 => mw_U_3rom_table(62225) <= "11111111";
         when 62226 => mw_U_3rom_table(62226) <= "11111111";
         when 62227 => mw_U_3rom_table(62227) <= "11111111";
         when 62228 => mw_U_3rom_table(62228) <= "11111111";
         when 62229 => mw_U_3rom_table(62229) <= "11111111";
         when 62230 => mw_U_3rom_table(62230) <= "11111111";
         when 62231 => mw_U_3rom_table(62231) <= "11111111";
         when 62232 => mw_U_3rom_table(62232) <= "11111111";
         when 62233 => mw_U_3rom_table(62233) <= "11111111";
         when 62234 => mw_U_3rom_table(62234) <= "11111111";
         when 62235 => mw_U_3rom_table(62235) <= "11111111";
         when 62236 => mw_U_3rom_table(62236) <= "11111111";
         when 62237 => mw_U_3rom_table(62237) <= "11111111";
         when 62238 => mw_U_3rom_table(62238) <= "01010110";
         when 62239 => mw_U_3rom_table(62239) <= "00000100";
         when 65504 => mw_U_3rom_table(65504) <= "11111111";
         when 65505 => mw_U_3rom_table(65505) <= "11111111";
         when 65506 => mw_U_3rom_table(65506) <= "11110000";
         when 65507 => mw_U_3rom_table(65507) <= "00000000";
         when 65508 => mw_U_3rom_table(65508) <= "11111111";
         when 65509 => mw_U_3rom_table(65509) <= "11111111";
         when 65510 => mw_U_3rom_table(65510) <= "11111111";
         when 65511 => mw_U_3rom_table(65511) <= "11111111";
         when 65512 => mw_U_3rom_table(65512) <= "11111111";
         when 65513 => mw_U_3rom_table(65513) <= "11111111";
         when 65514 => mw_U_3rom_table(65514) <= "11111111";
         when 65515 => mw_U_3rom_table(65515) <= "11111111";
         when 65516 => mw_U_3rom_table(65516) <= "11111111";
         when 65517 => mw_U_3rom_table(65517) <= "11111111";
         when 65518 => mw_U_3rom_table(65518) <= "11111111";
         when 65519 => mw_U_3rom_table(65519) <= "11111111";
         when 65520 => mw_U_3rom_table(65520) <= "11111111";
         when 65521 => mw_U_3rom_table(65521) <= "11111111";
         when 65522 => mw_U_3rom_table(65522) <= "11111111";
         when 65523 => mw_U_3rom_table(65523) <= "11111111";
         when 65524 => mw_U_3rom_table(65524) <= "11111111";
         when 65525 => mw_U_3rom_table(65525) <= "11111111";
         when 65526 => mw_U_3rom_table(65526) <= "11111111";
         when 65527 => mw_U_3rom_table(65527) <= "11111111";
         when 65528 => mw_U_3rom_table(65528) <= "11111111";
         when 65529 => mw_U_3rom_table(65529) <= "11111111";
         when 65530 => mw_U_3rom_table(65530) <= "11111111";
         when 65531 => mw_U_3rom_table(65531) <= "11111111";
         when 65532 => mw_U_3rom_table(65532) <= "11111111";
         when 65533 => mw_U_3rom_table(65533) <= "11111111";
         when 65534 => mw_U_3rom_table(65534) <= "11111111";
         when 65535 => mw_U_3rom_table(65535) <= "11111111";
         when others => mw_U_3rom_table(mw_U_3addr_int) <= (others => 'X') ;
      end case;
   end process ;
   
   u_3rom_read_proc : process ( clk1 )
   begin
      if  (clk1'event and clk1='1')  then
         dout1 <= mw_U_3rom_table(mw_U_3addr_int);
      end if;
   end process ;

   -- Instance port mappings.
   U_0 : R6502_TC
      port map (
         clk_clk_i   => clk,
         d_i         => RAM_DOUT_internal,
         irq_n_i     => IRQn,
         nmi_n_i     => NMIn,
         rdy_i       => RDY,
         rst_rst_n_i => RSTn,
         so_n_i      => so_n_i,
         a_o         => A_internal,
         d_o         => CPU_DOUT_internal,
         rd_o        => RD,
         sync_o      => SYNC,
         wr_n_o      => open,
         wr_o        => WR_internal
      );

   -- Implicit buffered output assignments
   CPU_DOUT <= CPU_DOUT_internal;
   RAM_DOUT <= RAM_DOUT_internal;
   WR       <= WR_internal;
   A        <= A_internal;

end struct;
