#define VGA256 0x13   //320x200x256...
#define TEXT_MODE 0x03  //tavallinen tekstimoodi..

int viiva;

void init_graph(int vmode)
{
asm{
mov	ah,0x0f
mov	ax, [vmode]
int	0x10
}
}

unsigned char scan( void )
{
	      //tavallinen nppimien painalluksen luku hommeli..
_asm{
	mov	ah,01h
	int	16h
	jz	empty
	mov	ah,00h
	int	16h
	mov	al,ah

	xor	ah,ah
	jmp	done

}
empty:
_asm xor	ax,ax
done:
}

unsigned char far *video_buffer = (char far *)0xA0000000L;
unsigned char far *double_buffer = NULL;  //ensin piirto kaksois bufferiin(2-6 kertaa nopeempaa)
					  // ja sitten siirto nytt bufferiin...
unsigned char far *tausta_buffer = NULL;  //tua on tausta kuva..

unsigned int far *clock =  (unsigned int far *)0x0000046C; //ajastimen osote...

void timer(int clicks)
{
unsigned int now;
now = *clock;                   //ajastin silmukka..
while(abs(*clock - now) < clicks){};
}


unsigned char get_pixel(int x, int y)
{
asm{
les	di,double_buffer
mov	di,y
shl	di,6
mov	bx,di
shl	di,2
add	di,bx
add	di,x
mov	ax,es:[di]
}
}


void put_pixel(int x, int y, unsigned char color)
{


_asm{
les	di,double_buffer
mov	di,y
shl	di,6
mov	bx,di
shl	di,2
add	di,bx
add	di,x
mov	al,BYTE PTR color
mov	es:[di], al

}
}




void setrgb256(char vari, char red, char green, char blue)
{
	_asm{
	xor	ah,ah
	mov	al,[vari]
	mov	dx,0x3c8
	out	dx,al
	inc	dx
	mov	al,[red]
	out	dx,al
	mov	al,[green]
	out	dx,al
	mov	al,[blue]
	out	dx,al
	}

}

void clear_screen(int color)
{
_asm{

mov	ax,0xA000
mov	es,ax
xor	di,di
mov	cx,64000
mov	al, BYTE PTR color
mov	ah,al
rep	stosw
}

}




void load_back(char *filename)
{
FILE *fp;
unsigned int color;
unsigned int l;

fp=fopen(filename, "rb");
fseek(fp, 0, SEEK_SET);

l = 0;

while(l < 64000)
{
l ++;
color = fgetc(fp);
asm{
les	di,tausta_buffer
add	di,l
mov	al,BYTE PTR color
mov	es:[di], al
}

}
fclose(fp);
}

void tausta()
{
/*
asm{
push	ds
les	di,double_buffer
lds	si,tausta_buffer  //ikv hiri tulee ylnurkkaan ton kanssa..
mov	cx,64000
cld
rep	movsw
pop	ds
} */
_fmemcpy(double_buffer,tausta_buffer, 64000);

}

void bufferi_nayttoon(int x, int y)
{
/*
unsigned int l;                       //IKKUNAAN
int apu;
int apuy;
int apux;
unsigned int screen_off, double_off;

_asm{
mov	di,y
shl	di,6
mov	bx,di
shl	di,2
add	di,bx
add	di,x
mov	apu,di
}

double_off = apu-12230;
//apuy = y;
if(y < 35) apuy = 35 - y;
else if(y > 165) apuy = y - 165;
if(x < 50) apux = 50 - x;
if(x > 270) apux = x - 270;

apuy *= 320;

if(y < 35) double_off += apuy;//11200;
if(y > 165) double_off -= apuy;//11200;
if(x < 50) double_off += apux;//50;
if(x > 270) double_off -= apux;//50;





screen_off = 0;


for(l=0;l<70;l++)
{

_fmemmove((char far *)&video_buffer[screen_off],
	   (char far *)&double_buffer[double_off], 110);
screen_off += 320;
double_off += 320;
}

  */

/*
asm{
push	ds
les	di,video_buffer
lds	si,double_buffer       //hiriit!!
mov	cx,64000
cld
rep	movsw
pop	ds
} */
_fmemcpy(video_buffer, double_buffer, 64000);	   //kokonyttn...

}



void draw_line(int x, int y, int x0, int y0, int color)
{

if(x>x0)
{
int temp=x;
x=x0;
x0=temp;
}

if(y>y0)
{
int temp=y;
y=y0;
y0=temp;
}

int deltax=x0-x,deltay=y0-y;

float xaskellus=1, yaskellus=1;
float xx=x, yy=y;

float k=deltay/(float) deltax;

if(k<1) yaskellus = k;
else xaskellus = 1/k;

int apux, apuy;
while(xx<=x0 &&  yy<=y0)
{
apux = (int)xx;
apuy = (int)yy;

_asm{
les	di,double_buffer
mov	di,apuy
shl	di,6
mov	bx,di
shl	di,2
add	di,bx
add	di,apux
mov	al,BYTE PTR color
mov	es:[di], al

}

//double_buffer[(int)xx + ((int)yy<<6+(int)yy<<8)] = color;//(int)xx+(int)yy*320] = color;

xx += xaskellus;
yy += yaskellus;
}

}














